# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['ServiceDynamicSnippetContentArgs', 'ServiceDynamicSnippetContent']

@pulumi.input_type
class ServiceDynamicSnippetContentArgs:
    def __init__(__self__, *,
                 content: pulumi.Input[str],
                 service_id: pulumi.Input[str],
                 snippet_id: pulumi.Input[str],
                 manage_snippets: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a ServiceDynamicSnippetContent resource.
        :param pulumi.Input[str] content: The VCL code that specifies exactly what the snippet does
        :param pulumi.Input[str] service_id: The ID of the service that the dynamic snippet belongs to
        :param pulumi.Input[str] snippet_id: The ID of the dynamic snippet that the content belong to
        :param pulumi.Input[bool] manage_snippets: Whether to reapply changes if the state of the snippets drifts, i.e. if snippets are managed externally
        """
        ServiceDynamicSnippetContentArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            content=content,
            service_id=service_id,
            snippet_id=snippet_id,
            manage_snippets=manage_snippets,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             content: pulumi.Input[str],
             service_id: pulumi.Input[str],
             snippet_id: pulumi.Input[str],
             manage_snippets: Optional[pulumi.Input[bool]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("content", content)
        _setter("service_id", service_id)
        _setter("snippet_id", snippet_id)
        if manage_snippets is not None:
            _setter("manage_snippets", manage_snippets)

    @property
    @pulumi.getter
    def content(self) -> pulumi.Input[str]:
        """
        The VCL code that specifies exactly what the snippet does
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: pulumi.Input[str]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Input[str]:
        """
        The ID of the service that the dynamic snippet belongs to
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_id", value)

    @property
    @pulumi.getter(name="snippetId")
    def snippet_id(self) -> pulumi.Input[str]:
        """
        The ID of the dynamic snippet that the content belong to
        """
        return pulumi.get(self, "snippet_id")

    @snippet_id.setter
    def snippet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "snippet_id", value)

    @property
    @pulumi.getter(name="manageSnippets")
    def manage_snippets(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to reapply changes if the state of the snippets drifts, i.e. if snippets are managed externally
        """
        return pulumi.get(self, "manage_snippets")

    @manage_snippets.setter
    def manage_snippets(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "manage_snippets", value)


@pulumi.input_type
class _ServiceDynamicSnippetContentState:
    def __init__(__self__, *,
                 content: Optional[pulumi.Input[str]] = None,
                 manage_snippets: Optional[pulumi.Input[bool]] = None,
                 service_id: Optional[pulumi.Input[str]] = None,
                 snippet_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ServiceDynamicSnippetContent resources.
        :param pulumi.Input[str] content: The VCL code that specifies exactly what the snippet does
        :param pulumi.Input[bool] manage_snippets: Whether to reapply changes if the state of the snippets drifts, i.e. if snippets are managed externally
        :param pulumi.Input[str] service_id: The ID of the service that the dynamic snippet belongs to
        :param pulumi.Input[str] snippet_id: The ID of the dynamic snippet that the content belong to
        """
        _ServiceDynamicSnippetContentState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            content=content,
            manage_snippets=manage_snippets,
            service_id=service_id,
            snippet_id=snippet_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             content: Optional[pulumi.Input[str]] = None,
             manage_snippets: Optional[pulumi.Input[bool]] = None,
             service_id: Optional[pulumi.Input[str]] = None,
             snippet_id: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if content is not None:
            _setter("content", content)
        if manage_snippets is not None:
            _setter("manage_snippets", manage_snippets)
        if service_id is not None:
            _setter("service_id", service_id)
        if snippet_id is not None:
            _setter("snippet_id", snippet_id)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[str]]:
        """
        The VCL code that specifies exactly what the snippet does
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter(name="manageSnippets")
    def manage_snippets(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to reapply changes if the state of the snippets drifts, i.e. if snippets are managed externally
        """
        return pulumi.get(self, "manage_snippets")

    @manage_snippets.setter
    def manage_snippets(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "manage_snippets", value)

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the service that the dynamic snippet belongs to
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_id", value)

    @property
    @pulumi.getter(name="snippetId")
    def snippet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the dynamic snippet that the content belong to
        """
        return pulumi.get(self, "snippet_id")

    @snippet_id.setter
    def snippet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snippet_id", value)


class ServiceDynamicSnippetContent(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content: Optional[pulumi.Input[str]] = None,
                 manage_snippets: Optional[pulumi.Input[bool]] = None,
                 service_id: Optional[pulumi.Input[str]] = None,
                 snippet_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Import

        This is an example of the import command being applied to the resource named `fastly_service_dynamic_snippet_content.content` The resource ID is a combined value of the `service_id` and `snippet_id` separated by a forward slash.

        ```sh
         $ pulumi import fastly:index/serviceDynamicSnippetContent:ServiceDynamicSnippetContent content xxxxxxxxxxxxxxxxxxxx/xxxxxxxxxxxxxxxxxxxx
        ```

         If Terraform is already managing remote content against a resource being imported then the user will be asked to remove it from the existing Terraform state. The following is an example of the Terraform state command to remove the resource named `fastly_service_dynamic_snippet_content.content` from the Terraform state file. $ terraform state rm fastly_service_dynamic_snippet_content.content

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] content: The VCL code that specifies exactly what the snippet does
        :param pulumi.Input[bool] manage_snippets: Whether to reapply changes if the state of the snippets drifts, i.e. if snippets are managed externally
        :param pulumi.Input[str] service_id: The ID of the service that the dynamic snippet belongs to
        :param pulumi.Input[str] snippet_id: The ID of the dynamic snippet that the content belong to
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceDynamicSnippetContentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        This is an example of the import command being applied to the resource named `fastly_service_dynamic_snippet_content.content` The resource ID is a combined value of the `service_id` and `snippet_id` separated by a forward slash.

        ```sh
         $ pulumi import fastly:index/serviceDynamicSnippetContent:ServiceDynamicSnippetContent content xxxxxxxxxxxxxxxxxxxx/xxxxxxxxxxxxxxxxxxxx
        ```

         If Terraform is already managing remote content against a resource being imported then the user will be asked to remove it from the existing Terraform state. The following is an example of the Terraform state command to remove the resource named `fastly_service_dynamic_snippet_content.content` from the Terraform state file. $ terraform state rm fastly_service_dynamic_snippet_content.content

        :param str resource_name: The name of the resource.
        :param ServiceDynamicSnippetContentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceDynamicSnippetContentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            ServiceDynamicSnippetContentArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content: Optional[pulumi.Input[str]] = None,
                 manage_snippets: Optional[pulumi.Input[bool]] = None,
                 service_id: Optional[pulumi.Input[str]] = None,
                 snippet_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceDynamicSnippetContentArgs.__new__(ServiceDynamicSnippetContentArgs)

            if content is None and not opts.urn:
                raise TypeError("Missing required property 'content'")
            __props__.__dict__["content"] = content
            __props__.__dict__["manage_snippets"] = manage_snippets
            if service_id is None and not opts.urn:
                raise TypeError("Missing required property 'service_id'")
            __props__.__dict__["service_id"] = service_id
            if snippet_id is None and not opts.urn:
                raise TypeError("Missing required property 'snippet_id'")
            __props__.__dict__["snippet_id"] = snippet_id
        super(ServiceDynamicSnippetContent, __self__).__init__(
            'fastly:index/serviceDynamicSnippetContent:ServiceDynamicSnippetContent',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            content: Optional[pulumi.Input[str]] = None,
            manage_snippets: Optional[pulumi.Input[bool]] = None,
            service_id: Optional[pulumi.Input[str]] = None,
            snippet_id: Optional[pulumi.Input[str]] = None) -> 'ServiceDynamicSnippetContent':
        """
        Get an existing ServiceDynamicSnippetContent resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] content: The VCL code that specifies exactly what the snippet does
        :param pulumi.Input[bool] manage_snippets: Whether to reapply changes if the state of the snippets drifts, i.e. if snippets are managed externally
        :param pulumi.Input[str] service_id: The ID of the service that the dynamic snippet belongs to
        :param pulumi.Input[str] snippet_id: The ID of the dynamic snippet that the content belong to
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceDynamicSnippetContentState.__new__(_ServiceDynamicSnippetContentState)

        __props__.__dict__["content"] = content
        __props__.__dict__["manage_snippets"] = manage_snippets
        __props__.__dict__["service_id"] = service_id
        __props__.__dict__["snippet_id"] = snippet_id
        return ServiceDynamicSnippetContent(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def content(self) -> pulumi.Output[str]:
        """
        The VCL code that specifies exactly what the snippet does
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="manageSnippets")
    def manage_snippets(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to reapply changes if the state of the snippets drifts, i.e. if snippets are managed externally
        """
        return pulumi.get(self, "manage_snippets")

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Output[str]:
        """
        The ID of the service that the dynamic snippet belongs to
        """
        return pulumi.get(self, "service_id")

    @property
    @pulumi.getter(name="snippetId")
    def snippet_id(self) -> pulumi.Output[str]:
        """
        The ID of the dynamic snippet that the content belong to
        """
        return pulumi.get(self, "snippet_id")

