"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Storage class to move an object to
 */
class StorageClass {
    constructor(value) {
        this.value = value;
    }
    toString() { return this.value; }
}
exports.StorageClass = StorageClass;
/**
 * Storage class for data that is accessed less frequently, but requires rapid
 * access when needed.
 *
 * Has lower availability than Standard storage.
 */
StorageClass.INFREQUENT_ACCESS = new StorageClass('STANDARD_IA');
/**
 * Infrequent Access that's only stored in one availability zone.
 *
 * Has lower availability than standard InfrequentAccess.
 */
StorageClass.ONE_ZONE_INFREQUENT_ACCESS = new StorageClass('ONEZONE_IA');
/**
 * Storage class for long-term archival that can take between minutes and
 * hours to access.
 *
 * Use for archives where portions of the data might need to be retrieved in
 * minutes. Data stored in the GLACIER storage class has a minimum storage
 * duration period of 90 days and can be accessed in as little as 1-5 minutes
 * using expedited retrieval. If you delete an object before the 90-day
 * minimum, you are charged for 90 days.
 */
StorageClass.GLACIER = new StorageClass('GLACIER');
/**
 * Use for archiving data that rarely needs to be accessed. Data stored in the
 * DEEP_ARCHIVE storage class has a minimum storage duration period of 180
 * days and a default retrieval time of 12 hours. If you delete an object
 * before the 180-day minimum, you are charged for 180 days. For pricing
 * information, see Amazon S3 Pricing.
 */
StorageClass.DEEP_ARCHIVE = new StorageClass('DEEP_ARCHIVE');
/**
 * The INTELLIGENT_TIERING storage class is designed to optimize storage costs
 * by automatically moving data to the most cost-effective storage access
 * tier, without performance impact or operational overhead.
 * INTELLIGENT_TIERING delivers automatic cost savings by moving data on a
 * granular object level between two access tiers, a frequent access tier and
 * a lower-cost infrequent access tier, when access patterns change. The
 * INTELLIGENT_TIERING storage class is ideal if you want to optimize storage
 * costs automatically for long-lived data when access patterns are unknown or
 * unpredictable.
 */
StorageClass.INTELLIGENT_TIERING = new StorageClass('INTELLIGENT_TIERING');
//# sourceMappingURL=data:application/json;base64,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