# Auto-generating python bindings for a command line tool

[kicadcliwrapper](https://github.com/faebryk/kicadcliwrapper) is a python wrapper for the kicad-cli application.
It is fully auto-generated by traversing the help tree recursively of all subcommands.
There is three levels of parsing: L1, L2, and L3 with L3 being the actual dataclass bindings.

## Source

```bash
> kicad-cli -h

Usage: kicad-cli [--version] [--help] {fp,pcb,sch,sym,version}

Optional arguments:
  -v, --version  prints version information and exits 
  -h, --help     Shows help message and exits 

Subcommands:
  fp            Footprint and Footprint Libraries
  pcb           PCB
  sch           Schematics
  sym           Symbol and Symbol Libraries
  version       Reports the version info in various formats
```

## L1 result

```python
ParserL1.Command(
    command="kicad-cli",
    sections=[
        ParserL1.Section(
            name="Usage",
            lines=["Usage: kicad-cli [--version] [--help] {fp,pcb,sch,sym,version}"],
        ),
        ParserL1.Section(
            name="Optional arguments",
            lines=[
                "Optional arguments:",
                "-v, --version  prints version information and exits",
                "-h, --help     Shows help message and exits",
            ],
        ),
        ParserL1.Section(
            name="Subcommands",
            lines=[
                "Subcommands:",
                "fp            Footprint and Footprint Libraries",
                "pcb           PCB",
                "sch           Schematics",
                "sym           Symbol and Symbol Libraries",
                "version       Reports the version info in various formats",
            ],
        ),
    ],
    subcommands=[
        ...
    ]
)
```

### L2 result

```python
ParserL2.Command(
    name="kicad-cli",
    description="",
    args=[],
    flags=[
        ParserL2.Flag(
            name="--version",
            commands=["-v", "--version"],
            description="prints version information and exits",
            default=False,
        ),
        ParserL2.Flag(
            name="--help",
            commands=["-h", "--help"],
            description="Shows help message and exits",
            default=False,
        ),
    ],
    subcommands=[
        ...
    ]
)
```

## L3/bindings result

```python
@dataclass
class kicad_cli:
    """
    Args:
        a_version: prints version information and exits
        help: Shows help message and exits
    """

    cmd: "fp | pcb | sch | sym | version"
    # Arguments (Required)
    # Arguments (Optional)
    # Flags
    a_version: bool = False
    help: bool = False
```

## Usage

```python
# Export pdf for pcb
kicad_cli(
    kicad_cli.pcb(
        kicad_cli.pcb.export(
            kicad_cli.pcb.export.pdf(
                INPUT_FILE="input.kicad_pcb"
            )
        )
    ),
).exec()
```
