# coding: utf-8

"""
Earnix DataService API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import datetime
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing_extensions import Self

from earnix_elevate.clients.data.models.export_s3_job_status import ExportS3JobStatus


class ExportS3JobStatusResponse(BaseModel):
    """
    Export S3 job status response
    """  # noqa: E501

    bucket: Optional[StrictStr] = None
    key: Optional[StrictStr] = None
    total_files: Optional[StrictInt] = Field(default=None, alias="totalFiles")
    uploaded_files: Optional[List[StrictStr]] = Field(
        default=None, alias="uploadedFiles"
    )
    status: Optional[ExportS3JobStatus] = None
    created_date: Optional[datetime] = Field(default=None, alias="createdDate")
    __properties: ClassVar[List[str]] = [
        "bucket",
        "key",
        "totalFiles",
        "uploadedFiles",
        "status",
        "createdDate",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ExportS3JobStatusResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of status
        if self.status:
            _dict["status"] = self.status.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ExportS3JobStatusResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "bucket": obj.get("bucket"),
                "key": obj.get("key"),
                "totalFiles": obj.get("totalFiles"),
                "uploadedFiles": obj.get("uploadedFiles"),
                "status": ExportS3JobStatus.from_dict(obj["status"])
                if obj.get("status") is not None
                else None,
                "createdDate": obj.get("createdDate"),
            }
        )
        return _obj
