# coding: utf-8

"""
Earnix import export API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import datetime
from importlib import import_module
from typing import TYPE_CHECKING, Any, ClassVar, Dict, List, Optional, Set, Union

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing_extensions import Annotated

from earnix_elevate.clients.imx.models.user import User

if TYPE_CHECKING:
    from earnix_elevate.clients.imx.models.s3_connection_response import (
        S3ConnectionResponse,
    )
    from earnix_elevate.clients.imx.models.snowflake_connection_response import (
        SnowflakeConnectionResponse,
    )


class ConnectionResponse(BaseModel):
    """
    ConnectionResponse
    """  # noqa: E501

    type: StrictStr
    id: StrictInt
    version: StrictInt
    name: Optional[Annotated[str, Field(min_length=3, strict=True, max_length=100)]] = (
        None
    )
    description: Optional[Annotated[str, Field(strict=True, max_length=500)]] = None
    tags: Optional[List[StrictStr]] = None
    created_by: Optional[User] = Field(default=None, alias="createdBy")
    created_date: Optional[datetime] = Field(default=None, alias="createdDate")
    last_modified_by: Optional[User] = Field(default=None, alias="lastModifiedBy")
    last_modified_date: Optional[datetime] = Field(
        default=None, alias="lastModifiedDate"
    )
    __properties: ClassVar[List[str]] = [
        "id",
        "version",
        "name",
        "description",
        "tags",
        "createdBy",
        "createdDate",
        "lastModifiedBy",
        "lastModifiedDate",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    # JSON field name that stores the object type
    __discriminator_property_name: ClassVar[str] = "type"

    # discriminator mappings
    __discriminator_value_class_map: ClassVar[Dict[str, str]] = {
        "s3": "S3ConnectionResponse",
        "snowflake": "SnowflakeConnectionResponse",
    }

    @classmethod
    def get_discriminator_value(cls, obj: Dict[str, Any]) -> Optional[str]:
        """Returns the discriminator value (object type) of the data"""
        discriminator_value = obj[cls.__discriminator_property_name]
        if discriminator_value:
            return cls.__discriminator_value_class_map.get(discriminator_value)
        else:
            return None

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(
        cls, json_str: str
    ) -> Optional[Union[S3ConnectionResponse, SnowflakeConnectionResponse]]:
        """Create an instance of ConnectionResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of created_by
        if self.created_by:
            _dict["createdBy"] = self.created_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of last_modified_by
        if self.last_modified_by:
            _dict["lastModifiedBy"] = self.last_modified_by.to_dict()
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict["description"] = None

        return _dict

    @classmethod
    def from_dict(
        cls, obj: Dict[str, Any]
    ) -> Optional[Union[S3ConnectionResponse, SnowflakeConnectionResponse]]:
        """Create an instance of ConnectionResponse from a dict"""
        # look up the object type based on discriminator mapping
        object_type = cls.get_discriminator_value(obj)
        if object_type == "S3ConnectionResponse":
            return import_module(
                "earnix_elevate.clients.imx.models.s3_connection_response"
            ).S3ConnectionResponse.from_dict(obj)
        if object_type == "SnowflakeConnectionResponse":
            return import_module(
                "earnix_elevate.clients.imx.models.snowflake_connection_response"
            ).SnowflakeConnectionResponse.from_dict(obj)

        raise ValueError(
            "ConnectionResponse failed to lookup discriminator value from "
            + json.dumps(obj)
            + ". Discriminator property name: "
            + cls.__discriminator_property_name
            + ", mapping: "
            + json.dumps(cls.__discriminator_value_class_map)
        )
