from ruamel import yaml

from pathlib import Path
from typing import NamedTuple, Dict


class Config(NamedTuple):
    locale: str = "cs"

    extension_to_runtime: Dict[str, str] = {
        "cs": "mono",
        "c": "c-gcc-linux",
        "pas": "freepascal-linux",
        "java": "java",
        "cpp": "cxx-gcc-linux"
    }

    judges: Dict[str, str] = {
        "bin/codex_judge": "recodex-judge-normal",
        "bin/codex_shufflejudge": "recodex-judge-shuffle",
        "diff": "diff"
    }

    @classmethod
    def load(cls, config_path: Path):
        if not config_path.exists():
            return cls()

        config = yaml.safe_load(config_path.open("r"))
        return cls(**config)
