# coding: utf-8

"""
    Geo Engine API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.8.0
    Contact: dev@geoengine.de
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBytes, StrictFloat, StrictInt, StrictStr
from typing import Any, Optional, Tuple, Union
from typing_extensions import Annotated
from uuid import UUID
from geoengine_openapi_client.models.describe_coverage_request import DescribeCoverageRequest
from geoengine_openapi_client.models.get_capabilities_request import GetCapabilitiesRequest
from geoengine_openapi_client.models.get_coverage_format import GetCoverageFormat
from geoengine_openapi_client.models.get_coverage_request import GetCoverageRequest
from geoengine_openapi_client.models.wcs_service import WcsService
from geoengine_openapi_client.models.wcs_version import WcsVersion

from geoengine_openapi_client.api_client import ApiClient, RequestSerialized
from geoengine_openapi_client.api_response import ApiResponse
from geoengine_openapi_client.rest import RESTResponseType


class OGCWCSApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def wcs_capabilities_handler(
        self,
        workflow: Annotated[UUID, Field(description="Workflow id")],
        service: WcsService,
        request: GetCapabilitiesRequest,
        version: Optional[Any] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> str:
        """Get WCS Capabilities


        :param workflow: Workflow id (required)
        :type workflow: UUID
        :param service: (required)
        :type service: WcsService
        :param request: (required)
        :type request: GetCapabilitiesRequest
        :param version:
        :type version: WcsVersion
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._wcs_capabilities_handler_serialize(
            workflow=workflow,
            service=service,
            request=request,
            version=version,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "str",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def wcs_capabilities_handler_with_http_info(
        self,
        workflow: Annotated[UUID, Field(description="Workflow id")],
        service: WcsService,
        request: GetCapabilitiesRequest,
        version: Optional[Any] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[str]:
        """Get WCS Capabilities


        :param workflow: Workflow id (required)
        :type workflow: UUID
        :param service: (required)
        :type service: WcsService
        :param request: (required)
        :type request: GetCapabilitiesRequest
        :param version:
        :type version: WcsVersion
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._wcs_capabilities_handler_serialize(
            workflow=workflow,
            service=service,
            request=request,
            version=version,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "str",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def wcs_capabilities_handler_without_preload_content(
        self,
        workflow: Annotated[UUID, Field(description="Workflow id")],
        service: WcsService,
        request: GetCapabilitiesRequest,
        version: Optional[Any] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get WCS Capabilities


        :param workflow: Workflow id (required)
        :type workflow: UUID
        :param service: (required)
        :type service: WcsService
        :param request: (required)
        :type request: GetCapabilitiesRequest
        :param version:
        :type version: WcsVersion
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._wcs_capabilities_handler_serialize(
            workflow=workflow,
            service=service,
            request=request,
            version=version,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "str",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _wcs_capabilities_handler_serialize(
        self,
        workflow,
        service,
        request,
        version,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workflow is not None:
            _path_params['workflow'] = workflow
        # process the query parameters
        if version is not None:
            
            _query_params.append(('version', version.value))
            
        if service is not None:
            
            _query_params.append(('service', service.value))
            
        if request is not None:
            
            _query_params.append(('request', request.value))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/xml'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'session_token'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/wcs/{workflow}?request=GetCapabilities',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def wcs_describe_coverage_handler(
        self,
        workflow: Annotated[UUID, Field(description="Workflow id")],
        version: WcsVersion,
        service: WcsService,
        request: DescribeCoverageRequest,
        identifiers: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> str:
        """Get WCS Coverage Description


        :param workflow: Workflow id (required)
        :type workflow: UUID
        :param version: (required)
        :type version: WcsVersion
        :param service: (required)
        :type service: WcsService
        :param request: (required)
        :type request: DescribeCoverageRequest
        :param identifiers: (required)
        :type identifiers: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._wcs_describe_coverage_handler_serialize(
            workflow=workflow,
            version=version,
            service=service,
            request=request,
            identifiers=identifiers,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "str",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def wcs_describe_coverage_handler_with_http_info(
        self,
        workflow: Annotated[UUID, Field(description="Workflow id")],
        version: WcsVersion,
        service: WcsService,
        request: DescribeCoverageRequest,
        identifiers: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[str]:
        """Get WCS Coverage Description


        :param workflow: Workflow id (required)
        :type workflow: UUID
        :param version: (required)
        :type version: WcsVersion
        :param service: (required)
        :type service: WcsService
        :param request: (required)
        :type request: DescribeCoverageRequest
        :param identifiers: (required)
        :type identifiers: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._wcs_describe_coverage_handler_serialize(
            workflow=workflow,
            version=version,
            service=service,
            request=request,
            identifiers=identifiers,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "str",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def wcs_describe_coverage_handler_without_preload_content(
        self,
        workflow: Annotated[UUID, Field(description="Workflow id")],
        version: WcsVersion,
        service: WcsService,
        request: DescribeCoverageRequest,
        identifiers: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get WCS Coverage Description


        :param workflow: Workflow id (required)
        :type workflow: UUID
        :param version: (required)
        :type version: WcsVersion
        :param service: (required)
        :type service: WcsService
        :param request: (required)
        :type request: DescribeCoverageRequest
        :param identifiers: (required)
        :type identifiers: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._wcs_describe_coverage_handler_serialize(
            workflow=workflow,
            version=version,
            service=service,
            request=request,
            identifiers=identifiers,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "str",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _wcs_describe_coverage_handler_serialize(
        self,
        workflow,
        version,
        service,
        request,
        identifiers,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workflow is not None:
            _path_params['workflow'] = workflow
        # process the query parameters
        if version is not None:
            
            _query_params.append(('version', version.value))
            
        if service is not None:
            
            _query_params.append(('service', service.value))
            
        if request is not None:
            
            _query_params.append(('request', request.value))
            
        if identifiers is not None:
            
            _query_params.append(('identifiers', identifiers))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/xml'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'session_token'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/wcs/{workflow}?request=DescribeCoverage',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def wcs_get_coverage_handler(
        self,
        workflow: Annotated[UUID, Field(description="Workflow id")],
        version: WcsVersion,
        service: WcsService,
        request: GetCoverageRequest,
        format: GetCoverageFormat,
        identifier: StrictStr,
        boundingbox: StrictStr,
        gridbasecrs: StrictStr,
        gridorigin: Optional[StrictStr] = None,
        gridoffsets: Optional[StrictStr] = None,
        time: Optional[StrictStr] = None,
        resx: Optional[Union[StrictFloat, StrictInt]] = None,
        resy: Optional[Union[StrictFloat, StrictInt]] = None,
        nodatavalue: Optional[Union[StrictFloat, StrictInt]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Get WCS Coverage


        :param workflow: Workflow id (required)
        :type workflow: UUID
        :param version: (required)
        :type version: WcsVersion
        :param service: (required)
        :type service: WcsService
        :param request: (required)
        :type request: GetCoverageRequest
        :param format: (required)
        :type format: GetCoverageFormat
        :param identifier: (required)
        :type identifier: str
        :param boundingbox: (required)
        :type boundingbox: str
        :param gridbasecrs: (required)
        :type gridbasecrs: str
        :param gridorigin:
        :type gridorigin: str
        :param gridoffsets:
        :type gridoffsets: str
        :param time:
        :type time: str
        :param resx:
        :type resx: float
        :param resy:
        :type resy: float
        :param nodatavalue:
        :type nodatavalue: float
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._wcs_get_coverage_handler_serialize(
            workflow=workflow,
            version=version,
            service=service,
            request=request,
            format=format,
            identifier=identifier,
            boundingbox=boundingbox,
            gridbasecrs=gridbasecrs,
            gridorigin=gridorigin,
            gridoffsets=gridoffsets,
            time=time,
            resx=resx,
            resy=resy,
            nodatavalue=nodatavalue,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def wcs_get_coverage_handler_with_http_info(
        self,
        workflow: Annotated[UUID, Field(description="Workflow id")],
        version: WcsVersion,
        service: WcsService,
        request: GetCoverageRequest,
        format: GetCoverageFormat,
        identifier: StrictStr,
        boundingbox: StrictStr,
        gridbasecrs: StrictStr,
        gridorigin: Optional[StrictStr] = None,
        gridoffsets: Optional[StrictStr] = None,
        time: Optional[StrictStr] = None,
        resx: Optional[Union[StrictFloat, StrictInt]] = None,
        resy: Optional[Union[StrictFloat, StrictInt]] = None,
        nodatavalue: Optional[Union[StrictFloat, StrictInt]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Get WCS Coverage


        :param workflow: Workflow id (required)
        :type workflow: UUID
        :param version: (required)
        :type version: WcsVersion
        :param service: (required)
        :type service: WcsService
        :param request: (required)
        :type request: GetCoverageRequest
        :param format: (required)
        :type format: GetCoverageFormat
        :param identifier: (required)
        :type identifier: str
        :param boundingbox: (required)
        :type boundingbox: str
        :param gridbasecrs: (required)
        :type gridbasecrs: str
        :param gridorigin:
        :type gridorigin: str
        :param gridoffsets:
        :type gridoffsets: str
        :param time:
        :type time: str
        :param resx:
        :type resx: float
        :param resy:
        :type resy: float
        :param nodatavalue:
        :type nodatavalue: float
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._wcs_get_coverage_handler_serialize(
            workflow=workflow,
            version=version,
            service=service,
            request=request,
            format=format,
            identifier=identifier,
            boundingbox=boundingbox,
            gridbasecrs=gridbasecrs,
            gridorigin=gridorigin,
            gridoffsets=gridoffsets,
            time=time,
            resx=resx,
            resy=resy,
            nodatavalue=nodatavalue,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def wcs_get_coverage_handler_without_preload_content(
        self,
        workflow: Annotated[UUID, Field(description="Workflow id")],
        version: WcsVersion,
        service: WcsService,
        request: GetCoverageRequest,
        format: GetCoverageFormat,
        identifier: StrictStr,
        boundingbox: StrictStr,
        gridbasecrs: StrictStr,
        gridorigin: Optional[StrictStr] = None,
        gridoffsets: Optional[StrictStr] = None,
        time: Optional[StrictStr] = None,
        resx: Optional[Union[StrictFloat, StrictInt]] = None,
        resy: Optional[Union[StrictFloat, StrictInt]] = None,
        nodatavalue: Optional[Union[StrictFloat, StrictInt]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get WCS Coverage


        :param workflow: Workflow id (required)
        :type workflow: UUID
        :param version: (required)
        :type version: WcsVersion
        :param service: (required)
        :type service: WcsService
        :param request: (required)
        :type request: GetCoverageRequest
        :param format: (required)
        :type format: GetCoverageFormat
        :param identifier: (required)
        :type identifier: str
        :param boundingbox: (required)
        :type boundingbox: str
        :param gridbasecrs: (required)
        :type gridbasecrs: str
        :param gridorigin:
        :type gridorigin: str
        :param gridoffsets:
        :type gridoffsets: str
        :param time:
        :type time: str
        :param resx:
        :type resx: float
        :param resy:
        :type resy: float
        :param nodatavalue:
        :type nodatavalue: float
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._wcs_get_coverage_handler_serialize(
            workflow=workflow,
            version=version,
            service=service,
            request=request,
            format=format,
            identifier=identifier,
            boundingbox=boundingbox,
            gridbasecrs=gridbasecrs,
            gridorigin=gridorigin,
            gridoffsets=gridoffsets,
            time=time,
            resx=resx,
            resy=resy,
            nodatavalue=nodatavalue,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _wcs_get_coverage_handler_serialize(
        self,
        workflow,
        version,
        service,
        request,
        format,
        identifier,
        boundingbox,
        gridbasecrs,
        gridorigin,
        gridoffsets,
        time,
        resx,
        resy,
        nodatavalue,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workflow is not None:
            _path_params['workflow'] = workflow
        # process the query parameters
        if version is not None:
            
            _query_params.append(('version', version.value))
            
        if service is not None:
            
            _query_params.append(('service', service.value))
            
        if request is not None:
            
            _query_params.append(('request', request.value))
            
        if format is not None:
            
            _query_params.append(('format', format.value))
            
        if identifier is not None:
            
            _query_params.append(('identifier', identifier))
            
        if boundingbox is not None:
            
            _query_params.append(('boundingbox', boundingbox))
            
        if gridbasecrs is not None:
            
            _query_params.append(('gridbasecrs', gridbasecrs))
            
        if gridorigin is not None:
            
            _query_params.append(('gridorigin', gridorigin))
            
        if gridoffsets is not None:
            
            _query_params.append(('gridoffsets', gridoffsets))
            
        if time is not None:
            
            _query_params.append(('time', time))
            
        if resx is not None:
            
            _query_params.append(('resx', resx))
            
        if resy is not None:
            
            _query_params.append(('resy', resy))
            
        if nodatavalue is not None:
            
            _query_params.append(('nodatavalue', nodatavalue))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'image/png'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'session_token'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/wcs/{workflow}?request=GetCoverage',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


