# coding: utf-8

"""
    Geo Engine API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.8.0
    Contact: dev@geoengine.de
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictStr
from typing import Any, Optional
from typing_extensions import Annotated
from uuid import UUID
from geoengine_openapi_client.models.geo_json import GeoJson
from geoengine_openapi_client.models.get_capabilities_request import GetCapabilitiesRequest
from geoengine_openapi_client.models.get_feature_request import GetFeatureRequest
from geoengine_openapi_client.models.wfs_service import WfsService

from geoengine_openapi_client.api_client import ApiClient, RequestSerialized
from geoengine_openapi_client.api_response import ApiResponse
from geoengine_openapi_client.rest import RESTResponseType


class OGCWFSApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def wfs_capabilities_handler(
        self,
        workflow: Annotated[UUID, Field(description="Workflow id")],
        version: Optional[Any],
        service: WfsService,
        request: GetCapabilitiesRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> str:
        """Get WFS Capabilities


        :param workflow: Workflow id (required)
        :type workflow: UUID
        :param version: (required)
        :type version: WfsVersion
        :param service: (required)
        :type service: WfsService
        :param request: (required)
        :type request: GetCapabilitiesRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._wfs_capabilities_handler_serialize(
            workflow=workflow,
            version=version,
            service=service,
            request=request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "str",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def wfs_capabilities_handler_with_http_info(
        self,
        workflow: Annotated[UUID, Field(description="Workflow id")],
        version: Optional[Any],
        service: WfsService,
        request: GetCapabilitiesRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[str]:
        """Get WFS Capabilities


        :param workflow: Workflow id (required)
        :type workflow: UUID
        :param version: (required)
        :type version: WfsVersion
        :param service: (required)
        :type service: WfsService
        :param request: (required)
        :type request: GetCapabilitiesRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._wfs_capabilities_handler_serialize(
            workflow=workflow,
            version=version,
            service=service,
            request=request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "str",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def wfs_capabilities_handler_without_preload_content(
        self,
        workflow: Annotated[UUID, Field(description="Workflow id")],
        version: Optional[Any],
        service: WfsService,
        request: GetCapabilitiesRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get WFS Capabilities


        :param workflow: Workflow id (required)
        :type workflow: UUID
        :param version: (required)
        :type version: WfsVersion
        :param service: (required)
        :type service: WfsService
        :param request: (required)
        :type request: GetCapabilitiesRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._wfs_capabilities_handler_serialize(
            workflow=workflow,
            version=version,
            service=service,
            request=request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "str",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _wfs_capabilities_handler_serialize(
        self,
        workflow,
        version,
        service,
        request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workflow is not None:
            _path_params['workflow'] = workflow
        if version is not None:
            _path_params['version'] = version.value
        if service is not None:
            _path_params['service'] = service.value
        if request is not None:
            _path_params['request'] = request.value
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/xml'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'session_token'
        ]

        return self.api_client.param_serialize(
            method='GET',
            # Note: remove query string in path part for ogc endpoints
            resource_path='/wfs/{workflow}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def wfs_feature_handler(
        self,
        workflow: Annotated[UUID, Field(description="Workflow id")],
        service: WfsService,
        request: GetFeatureRequest,
        type_names: StrictStr,
        bbox: StrictStr,
        version: Optional[Any] = None,
        time: Optional[StrictStr] = None,
        srs_name: Optional[StrictStr] = None,
        namespaces: Optional[StrictStr] = None,
        count: Optional[Annotated[int, Field(strict=True, ge=0)]] = None,
        sort_by: Optional[StrictStr] = None,
        result_type: Optional[StrictStr] = None,
        filter: Optional[StrictStr] = None,
        property_name: Optional[StrictStr] = None,
        query_resolution: Annotated[Optional[Any], Field(description="Vendor parameter for specifying a spatial query resolution")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GeoJson:
        """Get WCS Features


        :param workflow: Workflow id (required)
        :type workflow: UUID
        :param service: (required)
        :type service: WfsService
        :param request: (required)
        :type request: GetFeatureRequest
        :param type_names: (required)
        :type type_names: str
        :param bbox: (required)
        :type bbox: str
        :param version:
        :type version: WfsVersion
        :param time:
        :type time: str
        :param srs_name:
        :type srs_name: str
        :param namespaces:
        :type namespaces: str
        :param count:
        :type count: int
        :param sort_by:
        :type sort_by: str
        :param result_type:
        :type result_type: str
        :param filter:
        :type filter: str
        :param property_name:
        :type property_name: str
        :param query_resolution: Vendor parameter for specifying a spatial query resolution
        :type query_resolution: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._wfs_feature_handler_serialize(
            workflow=workflow,
            service=service,
            request=request,
            type_names=type_names,
            bbox=bbox,
            version=version,
            time=time,
            srs_name=srs_name,
            namespaces=namespaces,
            count=count,
            sort_by=sort_by,
            result_type=result_type,
            filter=filter,
            property_name=property_name,
            query_resolution=query_resolution,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GeoJson",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def wfs_feature_handler_with_http_info(
        self,
        workflow: Annotated[UUID, Field(description="Workflow id")],
        service: WfsService,
        request: GetFeatureRequest,
        type_names: StrictStr,
        bbox: StrictStr,
        version: Optional[Any] = None,
        time: Optional[StrictStr] = None,
        srs_name: Optional[StrictStr] = None,
        namespaces: Optional[StrictStr] = None,
        count: Optional[Annotated[int, Field(strict=True, ge=0)]] = None,
        sort_by: Optional[StrictStr] = None,
        result_type: Optional[StrictStr] = None,
        filter: Optional[StrictStr] = None,
        property_name: Optional[StrictStr] = None,
        query_resolution: Annotated[Optional[Any], Field(description="Vendor parameter for specifying a spatial query resolution")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GeoJson]:
        """Get WCS Features


        :param workflow: Workflow id (required)
        :type workflow: UUID
        :param service: (required)
        :type service: WfsService
        :param request: (required)
        :type request: GetFeatureRequest
        :param type_names: (required)
        :type type_names: str
        :param bbox: (required)
        :type bbox: str
        :param version:
        :type version: WfsVersion
        :param time:
        :type time: str
        :param srs_name:
        :type srs_name: str
        :param namespaces:
        :type namespaces: str
        :param count:
        :type count: int
        :param sort_by:
        :type sort_by: str
        :param result_type:
        :type result_type: str
        :param filter:
        :type filter: str
        :param property_name:
        :type property_name: str
        :param query_resolution: Vendor parameter for specifying a spatial query resolution
        :type query_resolution: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._wfs_feature_handler_serialize(
            workflow=workflow,
            service=service,
            request=request,
            type_names=type_names,
            bbox=bbox,
            version=version,
            time=time,
            srs_name=srs_name,
            namespaces=namespaces,
            count=count,
            sort_by=sort_by,
            result_type=result_type,
            filter=filter,
            property_name=property_name,
            query_resolution=query_resolution,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GeoJson",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def wfs_feature_handler_without_preload_content(
        self,
        workflow: Annotated[UUID, Field(description="Workflow id")],
        service: WfsService,
        request: GetFeatureRequest,
        type_names: StrictStr,
        bbox: StrictStr,
        version: Optional[Any] = None,
        time: Optional[StrictStr] = None,
        srs_name: Optional[StrictStr] = None,
        namespaces: Optional[StrictStr] = None,
        count: Optional[Annotated[int, Field(strict=True, ge=0)]] = None,
        sort_by: Optional[StrictStr] = None,
        result_type: Optional[StrictStr] = None,
        filter: Optional[StrictStr] = None,
        property_name: Optional[StrictStr] = None,
        query_resolution: Annotated[Optional[Any], Field(description="Vendor parameter for specifying a spatial query resolution")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get WCS Features


        :param workflow: Workflow id (required)
        :type workflow: UUID
        :param service: (required)
        :type service: WfsService
        :param request: (required)
        :type request: GetFeatureRequest
        :param type_names: (required)
        :type type_names: str
        :param bbox: (required)
        :type bbox: str
        :param version:
        :type version: WfsVersion
        :param time:
        :type time: str
        :param srs_name:
        :type srs_name: str
        :param namespaces:
        :type namespaces: str
        :param count:
        :type count: int
        :param sort_by:
        :type sort_by: str
        :param result_type:
        :type result_type: str
        :param filter:
        :type filter: str
        :param property_name:
        :type property_name: str
        :param query_resolution: Vendor parameter for specifying a spatial query resolution
        :type query_resolution: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._wfs_feature_handler_serialize(
            workflow=workflow,
            service=service,
            request=request,
            type_names=type_names,
            bbox=bbox,
            version=version,
            time=time,
            srs_name=srs_name,
            namespaces=namespaces,
            count=count,
            sort_by=sort_by,
            result_type=result_type,
            filter=filter,
            property_name=property_name,
            query_resolution=query_resolution,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GeoJson",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _wfs_feature_handler_serialize(
        self,
        workflow,
        service,
        request,
        type_names,
        bbox,
        version,
        time,
        srs_name,
        namespaces,
        count,
        sort_by,
        result_type,
        filter,
        property_name,
        query_resolution,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workflow is not None:
            _path_params['workflow'] = workflow
        # process the query parameters
        if version is not None:
            
            _query_params.append(('version', version.value))
            
        if service is not None:
            
            _query_params.append(('service', service.value))
            
        if request is not None:
            
            _query_params.append(('request', request.value))
            
        if type_names is not None:
            
            _query_params.append(('typeNames', type_names))
            
        if bbox is not None:
            
            _query_params.append(('bbox', bbox))
            
        if time is not None:
            
            _query_params.append(('time', time))
            
        if srs_name is not None:
            
            _query_params.append(('srsName', srs_name))
            
        if namespaces is not None:
            
            _query_params.append(('namespaces', namespaces))
            
        if count is not None:
            
            _query_params.append(('count', count))
            
        if sort_by is not None:
            
            _query_params.append(('sortBy', sort_by))
            
        if result_type is not None:
            
            _query_params.append(('resultType', result_type))
            
        if filter is not None:
            
            _query_params.append(('filter', filter))
            
        if property_name is not None:
            
            _query_params.append(('propertyName', property_name))
            
        if query_resolution is not None:
            
            _query_params.append(('queryResolution', query_resolution))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'session_token'
        ]

        return self.api_client.param_serialize(
            method='GET',
            # Note: remove query string in path part for ogc endpoints
            resource_path='/wfs/{workflow}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


