# coding: utf-8

"""
    Geo Engine API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.8.0
    Contact: dev@geoengine.de
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List
from geoengine_openapi_client.models.coordinate2_d import Coordinate2D
from typing import Optional, Set
from typing_extensions import Self

class BoundingBox2D(BaseModel):
    """
    A bounding box that includes all border points. Note: may degenerate to a point!
    """ # noqa: E501
    lower_left_coordinate: Coordinate2D = Field(alias="lowerLeftCoordinate")
    upper_right_coordinate: Coordinate2D = Field(alias="upperRightCoordinate")
    __properties: ClassVar[List[str]] = ["lowerLeftCoordinate", "upperRightCoordinate"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BoundingBox2D from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of lower_left_coordinate
        if self.lower_left_coordinate:
            _dict['lowerLeftCoordinate'] = self.lower_left_coordinate.to_dict()
        # override the default output from pydantic by calling `to_dict()` of upper_right_coordinate
        if self.upper_right_coordinate:
            _dict['upperRightCoordinate'] = self.upper_right_coordinate.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BoundingBox2D from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "lowerLeftCoordinate": Coordinate2D.from_dict(obj["lowerLeftCoordinate"]) if obj.get("lowerLeftCoordinate") is not None else None,
            "upperRightCoordinate": Coordinate2D.from_dict(obj["upperRightCoordinate"]) if obj.get("upperRightCoordinate") is not None else None
        })
        return _obj


