# coding: utf-8

"""
    Geo Engine API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.8.0
    Contact: dev@geoengine.de
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from uuid import UUID
from geoengine_openapi_client.models.dataset_layer_listing_collection import DatasetLayerListingCollection
from typing import Optional, Set
from typing_extensions import Self

class DatasetLayerListingProviderDefinition(BaseModel):
    """
    DatasetLayerListingProviderDefinition
    """ # noqa: E501
    collections: List[DatasetLayerListingCollection]
    description: StrictStr
    id: UUID
    name: StrictStr
    priority: Optional[StrictInt] = None
    type: StrictStr
    __properties: ClassVar[List[str]] = ["collections", "description", "id", "name", "priority", "type"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['DatasetLayerListing']):
            raise ValueError("must be one of enum values ('DatasetLayerListing')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DatasetLayerListingProviderDefinition from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in collections (list)
        _items = []
        if self.collections:
            for _item_collections in self.collections:
                if _item_collections:
                    _items.append(_item_collections.to_dict())
            _dict['collections'] = _items
        # set to None if priority (nullable) is None
        # and model_fields_set contains the field
        if self.priority is None and "priority" in self.model_fields_set:
            _dict['priority'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DatasetLayerListingProviderDefinition from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "collections": [DatasetLayerListingCollection.from_dict(_item) for _item in obj["collections"]] if obj.get("collections") is not None else None,
            "description": obj.get("description"),
            "id": obj.get("id"),
            "name": obj.get("name"),
            "priority": obj.get("priority"),
            "type": obj.get("type")
        })
        return _obj


