# coding: utf-8

"""
    Geo Engine API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.8.0
    Contact: dev@geoengine.de
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from uuid import UUID
from geoengine_openapi_client.models.symbology import Symbology
from geoengine_openapi_client.models.typed_result_descriptor import TypedResultDescriptor
from typing import Optional, Set
from typing_extensions import Self

class DatasetListing(BaseModel):
    """
    DatasetListing
    """ # noqa: E501
    description: StrictStr
    display_name: StrictStr = Field(alias="displayName")
    id: UUID
    name: StrictStr
    result_descriptor: TypedResultDescriptor = Field(alias="resultDescriptor")
    source_operator: StrictStr = Field(alias="sourceOperator")
    symbology: Optional[Symbology] = None
    tags: List[StrictStr]
    __properties: ClassVar[List[str]] = ["description", "displayName", "id", "name", "resultDescriptor", "sourceOperator", "symbology", "tags"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DatasetListing from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of result_descriptor
        if self.result_descriptor:
            _dict['resultDescriptor'] = self.result_descriptor.to_dict()
        # override the default output from pydantic by calling `to_dict()` of symbology
        if self.symbology:
            _dict['symbology'] = self.symbology.to_dict()
        # set to None if symbology (nullable) is None
        # and model_fields_set contains the field
        if self.symbology is None and "symbology" in self.model_fields_set:
            _dict['symbology'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DatasetListing from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "description": obj.get("description"),
            "displayName": obj.get("displayName"),
            "id": obj.get("id"),
            "name": obj.get("name"),
            "resultDescriptor": TypedResultDescriptor.from_dict(obj["resultDescriptor"]) if obj.get("resultDescriptor") is not None else None,
            "sourceOperator": obj.get("sourceOperator"),
            "symbology": Symbology.from_dict(obj["symbology"]) if obj.get("symbology") is not None else None,
            "tags": obj.get("tags")
        })
        return _obj


