# coding: utf-8

"""
    Geo Engine API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.8.0
    Contact: dev@geoengine.de
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from uuid import UUID
from geoengine_openapi_client.models.edr_vector_spec import EdrVectorSpec
from geoengine_openapi_client.models.provenance import Provenance
from typing import Optional, Set
from typing_extensions import Self

class EdrDataProviderDefinition(BaseModel):
    """
    EdrDataProviderDefinition
    """ # noqa: E501
    base_url: StrictStr = Field(alias="baseUrl")
    cache_ttl: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="cacheTtl")
    description: StrictStr
    discrete_vrs: Optional[List[StrictStr]] = Field(default=None, description="List of vertical reference systems with a discrete scale", alias="discreteVrs")
    id: UUID
    name: StrictStr
    priority: Optional[StrictInt] = None
    provenance: Optional[List[Provenance]] = None
    type: StrictStr
    vector_spec: Optional[EdrVectorSpec] = Field(default=None, alias="vectorSpec")
    __properties: ClassVar[List[str]] = ["baseUrl", "cacheTtl", "description", "discreteVrs", "id", "name", "priority", "provenance", "type", "vectorSpec"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['Edr']):
            raise ValueError("must be one of enum values ('Edr')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EdrDataProviderDefinition from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in provenance (list)
        _items = []
        if self.provenance:
            for _item_provenance in self.provenance:
                if _item_provenance:
                    _items.append(_item_provenance.to_dict())
            _dict['provenance'] = _items
        # override the default output from pydantic by calling `to_dict()` of vector_spec
        if self.vector_spec:
            _dict['vectorSpec'] = self.vector_spec.to_dict()
        # set to None if priority (nullable) is None
        # and model_fields_set contains the field
        if self.priority is None and "priority" in self.model_fields_set:
            _dict['priority'] = None

        # set to None if provenance (nullable) is None
        # and model_fields_set contains the field
        if self.provenance is None and "provenance" in self.model_fields_set:
            _dict['provenance'] = None

        # set to None if vector_spec (nullable) is None
        # and model_fields_set contains the field
        if self.vector_spec is None and "vector_spec" in self.model_fields_set:
            _dict['vectorSpec'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EdrDataProviderDefinition from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "baseUrl": obj.get("baseUrl"),
            "cacheTtl": obj.get("cacheTtl"),
            "description": obj.get("description"),
            "discreteVrs": obj.get("discreteVrs"),
            "id": obj.get("id"),
            "name": obj.get("name"),
            "priority": obj.get("priority"),
            "provenance": [Provenance.from_dict(_item) for _item in obj["provenance"]] if obj.get("provenance") is not None else None,
            "type": obj.get("type"),
            "vectorSpec": EdrVectorSpec.from_dict(obj["vectorSpec"]) if obj.get("vectorSpec") is not None else None
        })
        return _obj


