# coding: utf-8

"""
    Geo Engine API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.8.0
    Contact: dev@geoengine.de
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from geoengine_openapi_client.models.file_not_found_handling import FileNotFoundHandling
from geoengine_openapi_client.models.gdal_dataset_geo_transform import GdalDatasetGeoTransform
from geoengine_openapi_client.models.gdal_metadata_mapping import GdalMetadataMapping
from typing import Optional, Set
from typing_extensions import Self

class GdalDatasetParameters(BaseModel):
    """
    Parameters for loading data using Gdal
    """ # noqa: E501
    allow_alphaband_as_mask: Optional[StrictBool] = Field(default=None, alias="allowAlphabandAsMask")
    file_not_found_handling: FileNotFoundHandling = Field(alias="fileNotFoundHandling")
    file_path: StrictStr = Field(alias="filePath")
    gdal_config_options: Optional[List[Annotated[List[StrictStr], Field(min_length=2, max_length=2)]]] = Field(default=None, alias="gdalConfigOptions")
    gdal_open_options: Optional[List[StrictStr]] = Field(default=None, alias="gdalOpenOptions")
    geo_transform: GdalDatasetGeoTransform = Field(alias="geoTransform")
    height: Annotated[int, Field(strict=True, ge=0)]
    no_data_value: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="noDataValue")
    properties_mapping: Optional[List[GdalMetadataMapping]] = Field(default=None, alias="propertiesMapping")
    rasterband_channel: Annotated[int, Field(strict=True, ge=0)] = Field(alias="rasterbandChannel")
    width: Annotated[int, Field(strict=True, ge=0)]
    __properties: ClassVar[List[str]] = ["allowAlphabandAsMask", "fileNotFoundHandling", "filePath", "gdalConfigOptions", "gdalOpenOptions", "geoTransform", "height", "noDataValue", "propertiesMapping", "rasterbandChannel", "width"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GdalDatasetParameters from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of geo_transform
        if self.geo_transform:
            _dict['geoTransform'] = self.geo_transform.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in properties_mapping (list)
        _items = []
        if self.properties_mapping:
            for _item_properties_mapping in self.properties_mapping:
                if _item_properties_mapping:
                    _items.append(_item_properties_mapping.to_dict())
            _dict['propertiesMapping'] = _items
        # set to None if gdal_config_options (nullable) is None
        # and model_fields_set contains the field
        if self.gdal_config_options is None and "gdal_config_options" in self.model_fields_set:
            _dict['gdalConfigOptions'] = None

        # set to None if gdal_open_options (nullable) is None
        # and model_fields_set contains the field
        if self.gdal_open_options is None and "gdal_open_options" in self.model_fields_set:
            _dict['gdalOpenOptions'] = None

        # set to None if no_data_value (nullable) is None
        # and model_fields_set contains the field
        if self.no_data_value is None and "no_data_value" in self.model_fields_set:
            _dict['noDataValue'] = None

        # set to None if properties_mapping (nullable) is None
        # and model_fields_set contains the field
        if self.properties_mapping is None and "properties_mapping" in self.model_fields_set:
            _dict['propertiesMapping'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GdalDatasetParameters from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "allowAlphabandAsMask": obj.get("allowAlphabandAsMask"),
            "fileNotFoundHandling": obj.get("fileNotFoundHandling"),
            "filePath": obj.get("filePath"),
            "gdalConfigOptions": obj.get("gdalConfigOptions"),
            "gdalOpenOptions": obj.get("gdalOpenOptions"),
            "geoTransform": GdalDatasetGeoTransform.from_dict(obj["geoTransform"]) if obj.get("geoTransform") is not None else None,
            "height": obj.get("height"),
            "noDataValue": obj.get("noDataValue"),
            "propertiesMapping": [GdalMetadataMapping.from_dict(_item) for _item in obj["propertiesMapping"]] if obj.get("propertiesMapping") is not None else None,
            "rasterbandChannel": obj.get("rasterbandChannel"),
            "width": obj.get("width")
        })
        return _obj


