# coding: utf-8

"""
    Geo Engine API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.8.0
    Contact: dev@geoengine.de
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List
from typing_extensions import Annotated
from geoengine_openapi_client.models.breakpoint import Breakpoint
from typing import Optional, Set
from typing_extensions import Self

class LinearGradient(BaseModel):
    """
    LinearGradient
    """ # noqa: E501
    breakpoints: List[Breakpoint]
    no_data_color: Annotated[List[StrictInt], Field(min_length=4, max_length=4)] = Field(alias="noDataColor")
    over_color: Annotated[List[StrictInt], Field(min_length=4, max_length=4)] = Field(alias="overColor")
    type: StrictStr
    under_color: Annotated[List[StrictInt], Field(min_length=4, max_length=4)] = Field(alias="underColor")
    __properties: ClassVar[List[str]] = ["breakpoints", "noDataColor", "overColor", "type", "underColor"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['linearGradient']):
            raise ValueError("must be one of enum values ('linearGradient')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LinearGradient from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in breakpoints (list)
        _items = []
        if self.breakpoints:
            for _item_breakpoints in self.breakpoints:
                if _item_breakpoints:
                    _items.append(_item_breakpoints.to_dict())
            _dict['breakpoints'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LinearGradient from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "breakpoints": [Breakpoint.from_dict(_item) for _item in obj["breakpoints"]] if obj.get("breakpoints") is not None else None,
            "noDataColor": obj.get("noDataColor"),
            "overColor": obj.get("overColor"),
            "type": obj.get("type"),
            "underColor": obj.get("underColor")
        })
        return _obj


