# coding: utf-8

"""
    Geo Engine API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.8.0
    Contact: dev@geoengine.de
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from geoengine_openapi_client.models.color_param import ColorParam
from geoengine_openapi_client.models.number_param import NumberParam
from geoengine_openapi_client.models.stroke_param import StrokeParam
from geoengine_openapi_client.models.text_symbology import TextSymbology
from typing import Optional, Set
from typing_extensions import Self

class PointSymbology(BaseModel):
    """
    PointSymbology
    """ # noqa: E501
    fill_color: ColorParam = Field(alias="fillColor")
    radius: NumberParam
    stroke: StrokeParam
    text: Optional[TextSymbology] = None
    type: StrictStr
    __properties: ClassVar[List[str]] = ["fillColor", "radius", "stroke", "text", "type"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['point']):
            raise ValueError("must be one of enum values ('point')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PointSymbology from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of fill_color
        if self.fill_color:
            _dict['fillColor'] = self.fill_color.to_dict()
        # override the default output from pydantic by calling `to_dict()` of radius
        if self.radius:
            _dict['radius'] = self.radius.to_dict()
        # override the default output from pydantic by calling `to_dict()` of stroke
        if self.stroke:
            _dict['stroke'] = self.stroke.to_dict()
        # override the default output from pydantic by calling `to_dict()` of text
        if self.text:
            _dict['text'] = self.text.to_dict()
        # set to None if text (nullable) is None
        # and model_fields_set contains the field
        if self.text is None and "text" in self.model_fields_set:
            _dict['text'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PointSymbology from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "fillColor": ColorParam.from_dict(obj["fillColor"]) if obj.get("fillColor") is not None else None,
            "radius": NumberParam.from_dict(obj["radius"]) if obj.get("radius") is not None else None,
            "stroke": StrokeParam.from_dict(obj["stroke"]) if obj.get("stroke") is not None else None,
            "text": TextSymbology.from_dict(obj["text"]) if obj.get("text") is not None else None,
            "type": obj.get("type")
        })
        return _obj


