# coding: utf-8

"""
    Geo Engine API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.8.0
    Contact: dev@geoengine.de
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from geoengine_openapi_client.models.multi_band_raster_colorizer import MultiBandRasterColorizer
from geoengine_openapi_client.models.single_band_raster_colorizer import SingleBandRasterColorizer
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

RASTERCOLORIZER_ONE_OF_SCHEMAS = ["MultiBandRasterColorizer", "SingleBandRasterColorizer"]

class RasterColorizer(BaseModel):
    """
    RasterColorizer
    """
    # data type: SingleBandRasterColorizer
    oneof_schema_1_validator: Optional[SingleBandRasterColorizer] = None
    # data type: MultiBandRasterColorizer
    oneof_schema_2_validator: Optional[MultiBandRasterColorizer] = None
    actual_instance: Optional[Union[MultiBandRasterColorizer, SingleBandRasterColorizer]] = None
    one_of_schemas: Set[str] = { "MultiBandRasterColorizer", "SingleBandRasterColorizer" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = RasterColorizer.model_construct()
        error_messages = []
        match = 0
        # validate data type: SingleBandRasterColorizer
        if not isinstance(v, SingleBandRasterColorizer):
            error_messages.append(f"Error! Input type `{type(v)}` is not `SingleBandRasterColorizer`")
        else:
            match += 1
        # validate data type: MultiBandRasterColorizer
        if not isinstance(v, MultiBandRasterColorizer):
            error_messages.append(f"Error! Input type `{type(v)}` is not `MultiBandRasterColorizer`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in RasterColorizer with oneOf schemas: MultiBandRasterColorizer, SingleBandRasterColorizer. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in RasterColorizer with oneOf schemas: MultiBandRasterColorizer, SingleBandRasterColorizer. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # use oneOf discriminator to lookup the data type
        _data_type = json.loads(json_str).get("type")
        if not _data_type:
            raise ValueError("Failed to lookup data type from the field `type` in the input.")

        # check if data type is `MultiBandRasterColorizer`
        if _data_type == "multiBand":
            instance.actual_instance = MultiBandRasterColorizer.from_json(json_str)
            return instance

        # check if data type is `SingleBandRasterColorizer`
        if _data_type == "singleBand":
            instance.actual_instance = SingleBandRasterColorizer.from_json(json_str)
            return instance

        # deserialize data into SingleBandRasterColorizer
        try:
            instance.actual_instance = SingleBandRasterColorizer.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into MultiBandRasterColorizer
        try:
            instance.actual_instance = MultiBandRasterColorizer.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into RasterColorizer with oneOf schemas: MultiBandRasterColorizer, SingleBandRasterColorizer. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into RasterColorizer with oneOf schemas: MultiBandRasterColorizer, SingleBandRasterColorizer. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], MultiBandRasterColorizer, SingleBandRasterColorizer]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


