# coding: utf-8

"""
    Geo Engine API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.8.0
    Contact: dev@geoengine.de
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from geoengine_openapi_client.models.data_provider_resource import DataProviderResource
from geoengine_openapi_client.models.dataset_resource import DatasetResource
from geoengine_openapi_client.models.layer_collection_resource import LayerCollectionResource
from geoengine_openapi_client.models.layer_resource import LayerResource
from geoengine_openapi_client.models.ml_model_resource import MlModelResource
from geoengine_openapi_client.models.project_resource import ProjectResource
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

RESOURCE_ONE_OF_SCHEMAS = ["DataProviderResource", "DatasetResource", "LayerCollectionResource", "LayerResource", "MlModelResource", "ProjectResource"]

class Resource(BaseModel):
    """
    A resource that is affected by a permission.
    """
    # data type: LayerResource
    oneof_schema_1_validator: Optional[LayerResource] = None
    # data type: LayerCollectionResource
    oneof_schema_2_validator: Optional[LayerCollectionResource] = None
    # data type: ProjectResource
    oneof_schema_3_validator: Optional[ProjectResource] = None
    # data type: DatasetResource
    oneof_schema_4_validator: Optional[DatasetResource] = None
    # data type: MlModelResource
    oneof_schema_5_validator: Optional[MlModelResource] = None
    # data type: DataProviderResource
    oneof_schema_6_validator: Optional[DataProviderResource] = None
    actual_instance: Optional[Union[DataProviderResource, DatasetResource, LayerCollectionResource, LayerResource, MlModelResource, ProjectResource]] = None
    one_of_schemas: Set[str] = { "DataProviderResource", "DatasetResource", "LayerCollectionResource", "LayerResource", "MlModelResource", "ProjectResource" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = Resource.model_construct()
        error_messages = []
        match = 0
        # validate data type: LayerResource
        if not isinstance(v, LayerResource):
            error_messages.append(f"Error! Input type `{type(v)}` is not `LayerResource`")
        else:
            match += 1
        # validate data type: LayerCollectionResource
        if not isinstance(v, LayerCollectionResource):
            error_messages.append(f"Error! Input type `{type(v)}` is not `LayerCollectionResource`")
        else:
            match += 1
        # validate data type: ProjectResource
        if not isinstance(v, ProjectResource):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ProjectResource`")
        else:
            match += 1
        # validate data type: DatasetResource
        if not isinstance(v, DatasetResource):
            error_messages.append(f"Error! Input type `{type(v)}` is not `DatasetResource`")
        else:
            match += 1
        # validate data type: MlModelResource
        if not isinstance(v, MlModelResource):
            error_messages.append(f"Error! Input type `{type(v)}` is not `MlModelResource`")
        else:
            match += 1
        # validate data type: DataProviderResource
        if not isinstance(v, DataProviderResource):
            error_messages.append(f"Error! Input type `{type(v)}` is not `DataProviderResource`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in Resource with oneOf schemas: DataProviderResource, DatasetResource, LayerCollectionResource, LayerResource, MlModelResource, ProjectResource. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in Resource with oneOf schemas: DataProviderResource, DatasetResource, LayerCollectionResource, LayerResource, MlModelResource, ProjectResource. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # use oneOf discriminator to lookup the data type
        _data_type = json.loads(json_str).get("type")
        if not _data_type:
            raise ValueError("Failed to lookup data type from the field `type` in the input.")

        # check if data type is `DatasetResource`
        if _data_type == "dataset":
            instance.actual_instance = DatasetResource.from_json(json_str)
            return instance

        # check if data type is `LayerResource`
        if _data_type == "layer":
            instance.actual_instance = LayerResource.from_json(json_str)
            return instance

        # check if data type is `LayerCollectionResource`
        if _data_type == "layerCollection":
            instance.actual_instance = LayerCollectionResource.from_json(json_str)
            return instance

        # check if data type is `MlModelResource`
        if _data_type == "mlModel":
            instance.actual_instance = MlModelResource.from_json(json_str)
            return instance

        # check if data type is `ProjectResource`
        if _data_type == "project":
            instance.actual_instance = ProjectResource.from_json(json_str)
            return instance

        # check if data type is `DataProviderResource`
        if _data_type == "provider":
            instance.actual_instance = DataProviderResource.from_json(json_str)
            return instance

        # deserialize data into LayerResource
        try:
            instance.actual_instance = LayerResource.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into LayerCollectionResource
        try:
            instance.actual_instance = LayerCollectionResource.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into ProjectResource
        try:
            instance.actual_instance = ProjectResource.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into DatasetResource
        try:
            instance.actual_instance = DatasetResource.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into MlModelResource
        try:
            instance.actual_instance = MlModelResource.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into DataProviderResource
        try:
            instance.actual_instance = DataProviderResource.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into Resource with oneOf schemas: DataProviderResource, DatasetResource, LayerCollectionResource, LayerResource, MlModelResource, ProjectResource. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into Resource with oneOf schemas: DataProviderResource, DatasetResource, LayerCollectionResource, LayerResource, MlModelResource, ProjectResource. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], DataProviderResource, DatasetResource, LayerCollectionResource, LayerResource, MlModelResource, ProjectResource]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


