# coding: utf-8

"""
    Geo Engine API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.8.0
    Contact: dev@geoengine.de
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from uuid import UUID
from geoengine_openapi_client.models.stac_api_retries import StacApiRetries
from geoengine_openapi_client.models.stac_band import StacBand
from geoengine_openapi_client.models.stac_query_buffer import StacQueryBuffer
from geoengine_openapi_client.models.stac_zone import StacZone
from typing import Optional, Set
from typing_extensions import Self

class SentinelS2L2ACogsProviderDefinition(BaseModel):
    """
    SentinelS2L2ACogsProviderDefinition
    """ # noqa: E501
    api_url: StrictStr = Field(alias="apiUrl")
    bands: List[StacBand]
    cache_ttl: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="cacheTtl")
    description: StrictStr
    gdal_retries: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="gdalRetries")
    id: UUID
    name: StrictStr
    priority: Optional[StrictInt] = None
    query_buffer: Optional[StacQueryBuffer] = Field(default=None, alias="queryBuffer")
    stac_api_retries: Optional[StacApiRetries] = Field(default=None, alias="stacApiRetries")
    type: StrictStr
    zones: List[StacZone]
    __properties: ClassVar[List[str]] = ["apiUrl", "bands", "cacheTtl", "description", "gdalRetries", "id", "name", "priority", "queryBuffer", "stacApiRetries", "type", "zones"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['SentinelS2L2ACogs']):
            raise ValueError("must be one of enum values ('SentinelS2L2ACogs')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SentinelS2L2ACogsProviderDefinition from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in bands (list)
        _items = []
        if self.bands:
            for _item_bands in self.bands:
                if _item_bands:
                    _items.append(_item_bands.to_dict())
            _dict['bands'] = _items
        # override the default output from pydantic by calling `to_dict()` of query_buffer
        if self.query_buffer:
            _dict['queryBuffer'] = self.query_buffer.to_dict()
        # override the default output from pydantic by calling `to_dict()` of stac_api_retries
        if self.stac_api_retries:
            _dict['stacApiRetries'] = self.stac_api_retries.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in zones (list)
        _items = []
        if self.zones:
            for _item_zones in self.zones:
                if _item_zones:
                    _items.append(_item_zones.to_dict())
            _dict['zones'] = _items
        # set to None if priority (nullable) is None
        # and model_fields_set contains the field
        if self.priority is None and "priority" in self.model_fields_set:
            _dict['priority'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SentinelS2L2ACogsProviderDefinition from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "apiUrl": obj.get("apiUrl"),
            "bands": [StacBand.from_dict(_item) for _item in obj["bands"]] if obj.get("bands") is not None else None,
            "cacheTtl": obj.get("cacheTtl"),
            "description": obj.get("description"),
            "gdalRetries": obj.get("gdalRetries"),
            "id": obj.get("id"),
            "name": obj.get("name"),
            "priority": obj.get("priority"),
            "queryBuffer": StacQueryBuffer.from_dict(obj["queryBuffer"]) if obj.get("queryBuffer") is not None else None,
            "stacApiRetries": StacApiRetries.from_dict(obj["stacApiRetries"]) if obj.get("stacApiRetries") is not None else None,
            "type": obj.get("type"),
            "zones": [StacZone.from_dict(_item) for _item in obj["zones"]] if obj.get("zones") is not None else None
        })
        return _obj


