# coding: utf-8

"""
    Geo Engine API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.8.0
    Contact: dev@geoengine.de
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from geoengine_openapi_client.models.axis_order import AxisOrder
from geoengine_openapi_client.models.bounding_box2_d import BoundingBox2D
from typing import Optional, Set
from typing_extensions import Self

class SpatialReferenceSpecification(BaseModel):
    """
    The specification of a spatial reference, where extent and axis labels are given in natural order (x, y) = (east, north)
    """ # noqa: E501
    axis_labels: Optional[Annotated[List[StrictStr], Field(min_length=2, max_length=2)]] = Field(default=None, alias="axisLabels")
    axis_order: Optional[AxisOrder] = Field(default=None, alias="axisOrder")
    extent: BoundingBox2D
    name: StrictStr
    proj_string: StrictStr = Field(alias="projString")
    spatial_reference: StrictStr = Field(alias="spatialReference")
    __properties: ClassVar[List[str]] = ["axisLabels", "axisOrder", "extent", "name", "projString", "spatialReference"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SpatialReferenceSpecification from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of extent
        if self.extent:
            _dict['extent'] = self.extent.to_dict()
        # set to None if axis_labels (nullable) is None
        # and model_fields_set contains the field
        if self.axis_labels is None and "axis_labels" in self.model_fields_set:
            _dict['axisLabels'] = None

        # set to None if axis_order (nullable) is None
        # and model_fields_set contains the field
        if self.axis_order is None and "axis_order" in self.model_fields_set:
            _dict['axisOrder'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SpatialReferenceSpecification from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "axisLabels": obj.get("axisLabels"),
            "axisOrder": obj.get("axisOrder"),
            "extent": BoundingBox2D.from_dict(obj["extent"]) if obj.get("extent") is not None else None,
            "name": obj.get("name"),
            "projString": obj.get("projString"),
            "spatialReference": obj.get("spatialReference")
        })
        return _obj


