# coding: utf-8

"""
    Geo Engine API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.8.0
    Contact: dev@geoengine.de
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from geoengine_openapi_client.models.line_symbology import LineSymbology
from geoengine_openapi_client.models.point_symbology import PointSymbology
from geoengine_openapi_client.models.polygon_symbology import PolygonSymbology
from geoengine_openapi_client.models.raster_symbology import RasterSymbology
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

SYMBOLOGY_ONE_OF_SCHEMAS = ["LineSymbology", "PointSymbology", "PolygonSymbology", "RasterSymbology"]

class Symbology(BaseModel):
    """
    Symbology
    """
    # data type: RasterSymbology
    oneof_schema_1_validator: Optional[RasterSymbology] = None
    # data type: PointSymbology
    oneof_schema_2_validator: Optional[PointSymbology] = None
    # data type: LineSymbology
    oneof_schema_3_validator: Optional[LineSymbology] = None
    # data type: PolygonSymbology
    oneof_schema_4_validator: Optional[PolygonSymbology] = None
    actual_instance: Optional[Union[LineSymbology, PointSymbology, PolygonSymbology, RasterSymbology]] = None
    one_of_schemas: Set[str] = { "LineSymbology", "PointSymbology", "PolygonSymbology", "RasterSymbology" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = Symbology.model_construct()
        error_messages = []
        match = 0
        # validate data type: RasterSymbology
        if not isinstance(v, RasterSymbology):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RasterSymbology`")
        else:
            match += 1
        # validate data type: PointSymbology
        if not isinstance(v, PointSymbology):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PointSymbology`")
        else:
            match += 1
        # validate data type: LineSymbology
        if not isinstance(v, LineSymbology):
            error_messages.append(f"Error! Input type `{type(v)}` is not `LineSymbology`")
        else:
            match += 1
        # validate data type: PolygonSymbology
        if not isinstance(v, PolygonSymbology):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PolygonSymbology`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in Symbology with oneOf schemas: LineSymbology, PointSymbology, PolygonSymbology, RasterSymbology. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in Symbology with oneOf schemas: LineSymbology, PointSymbology, PolygonSymbology, RasterSymbology. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # use oneOf discriminator to lookup the data type
        _data_type = json.loads(json_str).get("type")
        if not _data_type:
            raise ValueError("Failed to lookup data type from the field `type` in the input.")

        # check if data type is `LineSymbology`
        if _data_type == "line":
            instance.actual_instance = LineSymbology.from_json(json_str)
            return instance

        # check if data type is `PointSymbology`
        if _data_type == "point":
            instance.actual_instance = PointSymbology.from_json(json_str)
            return instance

        # check if data type is `PolygonSymbology`
        if _data_type == "polygon":
            instance.actual_instance = PolygonSymbology.from_json(json_str)
            return instance

        # check if data type is `RasterSymbology`
        if _data_type == "raster":
            instance.actual_instance = RasterSymbology.from_json(json_str)
            return instance

        # deserialize data into RasterSymbology
        try:
            instance.actual_instance = RasterSymbology.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into PointSymbology
        try:
            instance.actual_instance = PointSymbology.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into LineSymbology
        try:
            instance.actual_instance = LineSymbology.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into PolygonSymbology
        try:
            instance.actual_instance = PolygonSymbology.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into Symbology with oneOf schemas: LineSymbology, PointSymbology, PolygonSymbology, RasterSymbology. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into Symbology with oneOf schemas: LineSymbology, PointSymbology, PolygonSymbology, RasterSymbology. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], LineSymbology, PointSymbology, PolygonSymbology, RasterSymbology]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


