# coding: utf-8

"""
    Geo Engine API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.8.0
    Contact: dev@geoengine.de
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from geoengine_openapi_client.models.typed_plot_result_descriptor import TypedPlotResultDescriptor
from geoengine_openapi_client.models.typed_raster_result_descriptor import TypedRasterResultDescriptor
from geoengine_openapi_client.models.typed_vector_result_descriptor import TypedVectorResultDescriptor
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

TYPEDRESULTDESCRIPTOR_ONE_OF_SCHEMAS = ["TypedPlotResultDescriptor", "TypedRasterResultDescriptor", "TypedVectorResultDescriptor"]

class TypedResultDescriptor(BaseModel):
    """
    TypedResultDescriptor
    """
    # data type: TypedPlotResultDescriptor
    oneof_schema_1_validator: Optional[TypedPlotResultDescriptor] = None
    # data type: TypedRasterResultDescriptor
    oneof_schema_2_validator: Optional[TypedRasterResultDescriptor] = None
    # data type: TypedVectorResultDescriptor
    oneof_schema_3_validator: Optional[TypedVectorResultDescriptor] = None
    actual_instance: Optional[Union[TypedPlotResultDescriptor, TypedRasterResultDescriptor, TypedVectorResultDescriptor]] = None
    one_of_schemas: Set[str] = { "TypedPlotResultDescriptor", "TypedRasterResultDescriptor", "TypedVectorResultDescriptor" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = TypedResultDescriptor.model_construct()
        error_messages = []
        match = 0
        # validate data type: TypedPlotResultDescriptor
        if not isinstance(v, TypedPlotResultDescriptor):
            error_messages.append(f"Error! Input type `{type(v)}` is not `TypedPlotResultDescriptor`")
        else:
            match += 1
        # validate data type: TypedRasterResultDescriptor
        if not isinstance(v, TypedRasterResultDescriptor):
            error_messages.append(f"Error! Input type `{type(v)}` is not `TypedRasterResultDescriptor`")
        else:
            match += 1
        # validate data type: TypedVectorResultDescriptor
        if not isinstance(v, TypedVectorResultDescriptor):
            error_messages.append(f"Error! Input type `{type(v)}` is not `TypedVectorResultDescriptor`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in TypedResultDescriptor with oneOf schemas: TypedPlotResultDescriptor, TypedRasterResultDescriptor, TypedVectorResultDescriptor. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in TypedResultDescriptor with oneOf schemas: TypedPlotResultDescriptor, TypedRasterResultDescriptor, TypedVectorResultDescriptor. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # use oneOf discriminator to lookup the data type
        _data_type = json.loads(json_str).get("type")
        if not _data_type:
            raise ValueError("Failed to lookup data type from the field `type` in the input.")

        # check if data type is `TypedPlotResultDescriptor`
        if _data_type == "plot":
            instance.actual_instance = TypedPlotResultDescriptor.from_json(json_str)
            return instance

        # check if data type is `TypedRasterResultDescriptor`
        if _data_type == "raster":
            instance.actual_instance = TypedRasterResultDescriptor.from_json(json_str)
            return instance

        # check if data type is `TypedVectorResultDescriptor`
        if _data_type == "vector":
            instance.actual_instance = TypedVectorResultDescriptor.from_json(json_str)
            return instance

        # deserialize data into TypedPlotResultDescriptor
        try:
            instance.actual_instance = TypedPlotResultDescriptor.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into TypedRasterResultDescriptor
        try:
            instance.actual_instance = TypedRasterResultDescriptor.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into TypedVectorResultDescriptor
        try:
            instance.actual_instance = TypedVectorResultDescriptor.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into TypedResultDescriptor with oneOf schemas: TypedPlotResultDescriptor, TypedRasterResultDescriptor, TypedVectorResultDescriptor. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into TypedResultDescriptor with oneOf schemas: TypedPlotResultDescriptor, TypedRasterResultDescriptor, TypedVectorResultDescriptor. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], TypedPlotResultDescriptor, TypedRasterResultDescriptor, TypedVectorResultDescriptor]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


