# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetRemediationRecipeResult',
    'AwaitableGetRemediationRecipeResult',
    'get_remediation_recipe',
    'get_remediation_recipe_output',
]

@pulumi.output_type
class GetRemediationRecipeResult:
    """
    A collection of values returned by getRemediationRecipe.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, detect_configurations=None, display_name=None, freeform_tags=None, id=None, is_run_triggered_on_kb_change=None, knowledge_base_id=None, network_configurations=None, remediation_recipe_id=None, scm_configurations=None, state=None, system_tags=None, time_created=None, time_updated=None, verify_configurations=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if detect_configurations and not isinstance(detect_configurations, list):
            raise TypeError("Expected argument 'detect_configurations' to be a list")
        pulumi.set(__self__, "detect_configurations", detect_configurations)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_run_triggered_on_kb_change and not isinstance(is_run_triggered_on_kb_change, bool):
            raise TypeError("Expected argument 'is_run_triggered_on_kb_change' to be a bool")
        pulumi.set(__self__, "is_run_triggered_on_kb_change", is_run_triggered_on_kb_change)
        if knowledge_base_id and not isinstance(knowledge_base_id, str):
            raise TypeError("Expected argument 'knowledge_base_id' to be a str")
        pulumi.set(__self__, "knowledge_base_id", knowledge_base_id)
        if network_configurations and not isinstance(network_configurations, list):
            raise TypeError("Expected argument 'network_configurations' to be a list")
        pulumi.set(__self__, "network_configurations", network_configurations)
        if remediation_recipe_id and not isinstance(remediation_recipe_id, str):
            raise TypeError("Expected argument 'remediation_recipe_id' to be a str")
        pulumi.set(__self__, "remediation_recipe_id", remediation_recipe_id)
        if scm_configurations and not isinstance(scm_configurations, list):
            raise TypeError("Expected argument 'scm_configurations' to be a list")
        pulumi.set(__self__, "scm_configurations", scm_configurations)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if verify_configurations and not isinstance(verify_configurations, list):
            raise TypeError("Expected argument 'verify_configurations' to be a list")
        pulumi.set(__self__, "verify_configurations", verify_configurations)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The compartment Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the remediation recipe.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="detectConfigurations")
    def detect_configurations(self) -> Sequence['outputs.GetRemediationRecipeDetectConfigurationResult']:
        """
        A configuration to define the constraints when detecting vulnerable dependencies and recommending remediations.
        """
        return pulumi.get(self, "detect_configurations")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The name of the Remediation Recipe.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the remediation recipe.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isRunTriggeredOnKbChange")
    def is_run_triggered_on_kb_change(self) -> _builtins.bool:
        """
        Boolean indicating if a run should be automatically triggered once the Knowledge Base contents are updated.
        """
        return pulumi.get(self, "is_run_triggered_on_kb_change")

    @_builtins.property
    @pulumi.getter(name="knowledgeBaseId")
    def knowledge_base_id(self) -> _builtins.str:
        """
        The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the knowledge base.
        """
        return pulumi.get(self, "knowledge_base_id")

    @_builtins.property
    @pulumi.getter(name="networkConfigurations")
    def network_configurations(self) -> Sequence['outputs.GetRemediationRecipeNetworkConfigurationResult']:
        """
        A network configuration defines the required network characteristics for the remediation run of the recipe to access the source repository and/or verify build services.
        """
        return pulumi.get(self, "network_configurations")

    @_builtins.property
    @pulumi.getter(name="remediationRecipeId")
    def remediation_recipe_id(self) -> _builtins.str:
        return pulumi.get(self, "remediation_recipe_id")

    @_builtins.property
    @pulumi.getter(name="scmConfigurations")
    def scm_configurations(self) -> Sequence['outputs.GetRemediationRecipeScmConfigurationResult']:
        """
        A configuration for the Source Code Management tool/platform used by a remediation recipe.
        """
        return pulumi.get(self, "scm_configurations")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current lifecycle state of the Remediation Recipe.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The creation date and time of the Remediation Recipe (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The date and time the Remediation Recipe was last updated (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter(name="verifyConfigurations")
    def verify_configurations(self) -> Sequence['outputs.GetRemediationRecipeVerifyConfigurationResult']:
        """
        The Verify stage configuration specifies a build service to run a pipeline for the recommended code changes. The build pipeline will be initiated to ensure that there is no breaking change after the dependency versions have been updated in source to avoid vulnerabilities.
        """
        return pulumi.get(self, "verify_configurations")


class AwaitableGetRemediationRecipeResult(GetRemediationRecipeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRemediationRecipeResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            detect_configurations=self.detect_configurations,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_run_triggered_on_kb_change=self.is_run_triggered_on_kb_change,
            knowledge_base_id=self.knowledge_base_id,
            network_configurations=self.network_configurations,
            remediation_recipe_id=self.remediation_recipe_id,
            scm_configurations=self.scm_configurations,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated,
            verify_configurations=self.verify_configurations)


def get_remediation_recipe(remediation_recipe_id: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRemediationRecipeResult:
    """
    This data source provides details about a specific Remediation Recipe resource in Oracle Cloud Infrastructure Adm service.

    Returns the details of the specified RemediationRecipe.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_remediation_recipe = oci.Adm.get_remediation_recipe(remediation_recipe_id=test_remediation_recipe_oci_adm_remediation_recipe["id"])
    ```


    :param _builtins.str remediation_recipe_id: The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of a Remediation Recipe, as a URL path parameter.
    """
    __args__ = dict()
    __args__['remediationRecipeId'] = remediation_recipe_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Adm/getRemediationRecipe:getRemediationRecipe', __args__, opts=opts, typ=GetRemediationRecipeResult).value

    return AwaitableGetRemediationRecipeResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        detect_configurations=pulumi.get(__ret__, 'detect_configurations'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_run_triggered_on_kb_change=pulumi.get(__ret__, 'is_run_triggered_on_kb_change'),
        knowledge_base_id=pulumi.get(__ret__, 'knowledge_base_id'),
        network_configurations=pulumi.get(__ret__, 'network_configurations'),
        remediation_recipe_id=pulumi.get(__ret__, 'remediation_recipe_id'),
        scm_configurations=pulumi.get(__ret__, 'scm_configurations'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        verify_configurations=pulumi.get(__ret__, 'verify_configurations'))
def get_remediation_recipe_output(remediation_recipe_id: Optional[pulumi.Input[_builtins.str]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRemediationRecipeResult]:
    """
    This data source provides details about a specific Remediation Recipe resource in Oracle Cloud Infrastructure Adm service.

    Returns the details of the specified RemediationRecipe.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_remediation_recipe = oci.Adm.get_remediation_recipe(remediation_recipe_id=test_remediation_recipe_oci_adm_remediation_recipe["id"])
    ```


    :param _builtins.str remediation_recipe_id: The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of a Remediation Recipe, as a URL path parameter.
    """
    __args__ = dict()
    __args__['remediationRecipeId'] = remediation_recipe_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Adm/getRemediationRecipe:getRemediationRecipe', __args__, opts=opts, typ=GetRemediationRecipeResult)
    return __ret__.apply(lambda __response__: GetRemediationRecipeResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        detect_configurations=pulumi.get(__response__, 'detect_configurations'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        is_run_triggered_on_kb_change=pulumi.get(__response__, 'is_run_triggered_on_kb_change'),
        knowledge_base_id=pulumi.get(__response__, 'knowledge_base_id'),
        network_configurations=pulumi.get(__response__, 'network_configurations'),
        remediation_recipe_id=pulumi.get(__response__, 'remediation_recipe_id'),
        scm_configurations=pulumi.get(__response__, 'scm_configurations'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        verify_configurations=pulumi.get(__response__, 'verify_configurations')))
