# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'DataAssetDataSourceDetailsArgs',
    'DataAssetDataSourceDetailsArgsDict',
    'DataAssetDataSourceDetailsVersionSpecificDetailsArgs',
    'DataAssetDataSourceDetailsVersionSpecificDetailsArgsDict',
    'DetectAnomalyJobInputDetailsArgs',
    'DetectAnomalyJobInputDetailsArgsDict',
    'DetectAnomalyJobInputDetailsDataArgs',
    'DetectAnomalyJobInputDetailsDataArgsDict',
    'DetectAnomalyJobInputDetailsObjectLocationArgs',
    'DetectAnomalyJobInputDetailsObjectLocationArgsDict',
    'DetectAnomalyJobOutputDetailsArgs',
    'DetectAnomalyJobOutputDetailsArgsDict',
    'ModelModelTrainingDetailsArgs',
    'ModelModelTrainingDetailsArgsDict',
    'ModelModelTrainingResultArgs',
    'ModelModelTrainingResultArgsDict',
    'ModelModelTrainingResultRowReductionDetailArgs',
    'ModelModelTrainingResultRowReductionDetailArgsDict',
    'ModelModelTrainingResultSignalDetailArgs',
    'ModelModelTrainingResultSignalDetailArgsDict',
    'GetAiPrivateEndpointsFilterArgs',
    'GetAiPrivateEndpointsFilterArgsDict',
    'GetDetectAnomalyJobsFilterArgs',
    'GetDetectAnomalyJobsFilterArgsDict',
    'GetDetectionDataAssetsFilterArgs',
    'GetDetectionDataAssetsFilterArgsDict',
    'GetDetectionModelsFilterArgs',
    'GetDetectionModelsFilterArgsDict',
    'GetDetectionProjectsFilterArgs',
    'GetDetectionProjectsFilterArgsDict',
]

MYPY = False

if not MYPY:
    class DataAssetDataSourceDetailsArgsDict(TypedDict):
        data_source_type: pulumi.Input[_builtins.str]
        """
        Data source type where actually data asset is being stored
        """
        atp_password_secret_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        atp db password Secret Id
        """
        atp_user_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        atp db user name
        """
        bucket: NotRequired[pulumi.Input[_builtins.str]]
        """
        Object storage bucket name
        """
        cwallet_file_secret_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        OCID of the secret containing the containers certificates of ATP wallet
        """
        database_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        atp database name
        """
        ewallet_file_secret_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        OCID of the secret containing the PDB'S certificates of ATP wallet
        """
        key_store_file_secret_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        OCID of the secret containing Keystore.jks file of the ATP wallet
        """
        measurement_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Measurement name for influx
        """
        namespace: NotRequired[pulumi.Input[_builtins.str]]
        """
        Object storage namespace
        """
        object: NotRequired[pulumi.Input[_builtins.str]]
        """
        File name
        """
        ojdbc_file_secret_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        OCID of the secret that contains jdbc properties file of ATP wallet
        """
        password_secret_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Password Secret Id for the influx connection
        """
        table_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        atp database table name
        """
        tnsnames_file_secret_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        OCID of the secret that contains the tnsnames file of ATP wallet
        """
        truststore_file_secret_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        OCID of the secret containing truststore.jks file of the ATP wallet
        """
        url: NotRequired[pulumi.Input[_builtins.str]]
        """
        public IP address and port to influx DB
        """
        user_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Username for connection to Influx
        """
        version_specific_details: NotRequired[pulumi.Input['DataAssetDataSourceDetailsVersionSpecificDetailsArgsDict']]
        """
        Possible data sources
        """
        wallet_password_secret_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        wallet password Secret ID in String format
        """
elif False:
    DataAssetDataSourceDetailsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DataAssetDataSourceDetailsArgs:
    def __init__(__self__, *,
                 data_source_type: pulumi.Input[_builtins.str],
                 atp_password_secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 atp_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 cwallet_file_secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ewallet_file_secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_store_file_secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 measurement_name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 object: Optional[pulumi.Input[_builtins.str]] = None,
                 ojdbc_file_secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 password_secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 table_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tnsnames_file_secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 truststore_file_secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 version_specific_details: Optional[pulumi.Input['DataAssetDataSourceDetailsVersionSpecificDetailsArgs']] = None,
                 wallet_password_secret_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] data_source_type: Data source type where actually data asset is being stored
        :param pulumi.Input[_builtins.str] atp_password_secret_id: atp db password Secret Id
        :param pulumi.Input[_builtins.str] atp_user_name: atp db user name
        :param pulumi.Input[_builtins.str] bucket: Object storage bucket name
        :param pulumi.Input[_builtins.str] cwallet_file_secret_id: OCID of the secret containing the containers certificates of ATP wallet
        :param pulumi.Input[_builtins.str] database_name: atp database name
        :param pulumi.Input[_builtins.str] ewallet_file_secret_id: OCID of the secret containing the PDB'S certificates of ATP wallet
        :param pulumi.Input[_builtins.str] key_store_file_secret_id: OCID of the secret containing Keystore.jks file of the ATP wallet
        :param pulumi.Input[_builtins.str] measurement_name: Measurement name for influx
        :param pulumi.Input[_builtins.str] namespace: Object storage namespace
        :param pulumi.Input[_builtins.str] object: File name
        :param pulumi.Input[_builtins.str] ojdbc_file_secret_id: OCID of the secret that contains jdbc properties file of ATP wallet
        :param pulumi.Input[_builtins.str] password_secret_id: Password Secret Id for the influx connection
        :param pulumi.Input[_builtins.str] table_name: atp database table name
        :param pulumi.Input[_builtins.str] tnsnames_file_secret_id: OCID of the secret that contains the tnsnames file of ATP wallet
        :param pulumi.Input[_builtins.str] truststore_file_secret_id: OCID of the secret containing truststore.jks file of the ATP wallet
        :param pulumi.Input[_builtins.str] url: public IP address and port to influx DB
        :param pulumi.Input[_builtins.str] user_name: Username for connection to Influx
        :param pulumi.Input['DataAssetDataSourceDetailsVersionSpecificDetailsArgs'] version_specific_details: Possible data sources
        :param pulumi.Input[_builtins.str] wallet_password_secret_id: wallet password Secret ID in String format
        """
        pulumi.set(__self__, "data_source_type", data_source_type)
        if atp_password_secret_id is not None:
            pulumi.set(__self__, "atp_password_secret_id", atp_password_secret_id)
        if atp_user_name is not None:
            pulumi.set(__self__, "atp_user_name", atp_user_name)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if cwallet_file_secret_id is not None:
            pulumi.set(__self__, "cwallet_file_secret_id", cwallet_file_secret_id)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if ewallet_file_secret_id is not None:
            pulumi.set(__self__, "ewallet_file_secret_id", ewallet_file_secret_id)
        if key_store_file_secret_id is not None:
            pulumi.set(__self__, "key_store_file_secret_id", key_store_file_secret_id)
        if measurement_name is not None:
            pulumi.set(__self__, "measurement_name", measurement_name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if object is not None:
            pulumi.set(__self__, "object", object)
        if ojdbc_file_secret_id is not None:
            pulumi.set(__self__, "ojdbc_file_secret_id", ojdbc_file_secret_id)
        if password_secret_id is not None:
            pulumi.set(__self__, "password_secret_id", password_secret_id)
        if table_name is not None:
            pulumi.set(__self__, "table_name", table_name)
        if tnsnames_file_secret_id is not None:
            pulumi.set(__self__, "tnsnames_file_secret_id", tnsnames_file_secret_id)
        if truststore_file_secret_id is not None:
            pulumi.set(__self__, "truststore_file_secret_id", truststore_file_secret_id)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)
        if version_specific_details is not None:
            pulumi.set(__self__, "version_specific_details", version_specific_details)
        if wallet_password_secret_id is not None:
            pulumi.set(__self__, "wallet_password_secret_id", wallet_password_secret_id)

    @_builtins.property
    @pulumi.getter(name="dataSourceType")
    def data_source_type(self) -> pulumi.Input[_builtins.str]:
        """
        Data source type where actually data asset is being stored
        """
        return pulumi.get(self, "data_source_type")

    @data_source_type.setter
    def data_source_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "data_source_type", value)

    @_builtins.property
    @pulumi.getter(name="atpPasswordSecretId")
    def atp_password_secret_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        atp db password Secret Id
        """
        return pulumi.get(self, "atp_password_secret_id")

    @atp_password_secret_id.setter
    def atp_password_secret_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "atp_password_secret_id", value)

    @_builtins.property
    @pulumi.getter(name="atpUserName")
    def atp_user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        atp db user name
        """
        return pulumi.get(self, "atp_user_name")

    @atp_user_name.setter
    def atp_user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "atp_user_name", value)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Object storage bucket name
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter(name="cwalletFileSecretId")
    def cwallet_file_secret_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OCID of the secret containing the containers certificates of ATP wallet
        """
        return pulumi.get(self, "cwallet_file_secret_id")

    @cwallet_file_secret_id.setter
    def cwallet_file_secret_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cwallet_file_secret_id", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        atp database name
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter(name="ewalletFileSecretId")
    def ewallet_file_secret_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OCID of the secret containing the PDB'S certificates of ATP wallet
        """
        return pulumi.get(self, "ewallet_file_secret_id")

    @ewallet_file_secret_id.setter
    def ewallet_file_secret_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ewallet_file_secret_id", value)

    @_builtins.property
    @pulumi.getter(name="keyStoreFileSecretId")
    def key_store_file_secret_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OCID of the secret containing Keystore.jks file of the ATP wallet
        """
        return pulumi.get(self, "key_store_file_secret_id")

    @key_store_file_secret_id.setter
    def key_store_file_secret_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_store_file_secret_id", value)

    @_builtins.property
    @pulumi.getter(name="measurementName")
    def measurement_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Measurement name for influx
        """
        return pulumi.get(self, "measurement_name")

    @measurement_name.setter
    def measurement_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "measurement_name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Object storage namespace
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        File name
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "object", value)

    @_builtins.property
    @pulumi.getter(name="ojdbcFileSecretId")
    def ojdbc_file_secret_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OCID of the secret that contains jdbc properties file of ATP wallet
        """
        return pulumi.get(self, "ojdbc_file_secret_id")

    @ojdbc_file_secret_id.setter
    def ojdbc_file_secret_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ojdbc_file_secret_id", value)

    @_builtins.property
    @pulumi.getter(name="passwordSecretId")
    def password_secret_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Password Secret Id for the influx connection
        """
        return pulumi.get(self, "password_secret_id")

    @password_secret_id.setter
    def password_secret_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password_secret_id", value)

    @_builtins.property
    @pulumi.getter(name="tableName")
    def table_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        atp database table name
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "table_name", value)

    @_builtins.property
    @pulumi.getter(name="tnsnamesFileSecretId")
    def tnsnames_file_secret_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OCID of the secret that contains the tnsnames file of ATP wallet
        """
        return pulumi.get(self, "tnsnames_file_secret_id")

    @tnsnames_file_secret_id.setter
    def tnsnames_file_secret_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tnsnames_file_secret_id", value)

    @_builtins.property
    @pulumi.getter(name="truststoreFileSecretId")
    def truststore_file_secret_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OCID of the secret containing truststore.jks file of the ATP wallet
        """
        return pulumi.get(self, "truststore_file_secret_id")

    @truststore_file_secret_id.setter
    def truststore_file_secret_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "truststore_file_secret_id", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        public IP address and port to influx DB
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Username for connection to Influx
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_name", value)

    @_builtins.property
    @pulumi.getter(name="versionSpecificDetails")
    def version_specific_details(self) -> Optional[pulumi.Input['DataAssetDataSourceDetailsVersionSpecificDetailsArgs']]:
        """
        Possible data sources
        """
        return pulumi.get(self, "version_specific_details")

    @version_specific_details.setter
    def version_specific_details(self, value: Optional[pulumi.Input['DataAssetDataSourceDetailsVersionSpecificDetailsArgs']]):
        pulumi.set(self, "version_specific_details", value)

    @_builtins.property
    @pulumi.getter(name="walletPasswordSecretId")
    def wallet_password_secret_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        wallet password Secret ID in String format
        """
        return pulumi.get(self, "wallet_password_secret_id")

    @wallet_password_secret_id.setter
    def wallet_password_secret_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "wallet_password_secret_id", value)


if not MYPY:
    class DataAssetDataSourceDetailsVersionSpecificDetailsArgsDict(TypedDict):
        influx_version: pulumi.Input[_builtins.str]
        """
        Data source type where actually data asset is being stored
        """
        bucket: NotRequired[pulumi.Input[_builtins.str]]
        """
        Bucket Name for influx connection
        """
        database_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        DB Name for influx connection
        """
        organization_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Org name for the influx db
        """
        retention_policy_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        retention policy is how long the bucket would last
        """
elif False:
    DataAssetDataSourceDetailsVersionSpecificDetailsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DataAssetDataSourceDetailsVersionSpecificDetailsArgs:
    def __init__(__self__, *,
                 influx_version: pulumi.Input[_builtins.str],
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_name: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_policy_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] influx_version: Data source type where actually data asset is being stored
        :param pulumi.Input[_builtins.str] bucket: Bucket Name for influx connection
        :param pulumi.Input[_builtins.str] database_name: DB Name for influx connection
        :param pulumi.Input[_builtins.str] organization_name: Org name for the influx db
        :param pulumi.Input[_builtins.str] retention_policy_name: retention policy is how long the bucket would last
        """
        pulumi.set(__self__, "influx_version", influx_version)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if organization_name is not None:
            pulumi.set(__self__, "organization_name", organization_name)
        if retention_policy_name is not None:
            pulumi.set(__self__, "retention_policy_name", retention_policy_name)

    @_builtins.property
    @pulumi.getter(name="influxVersion")
    def influx_version(self) -> pulumi.Input[_builtins.str]:
        """
        Data source type where actually data asset is being stored
        """
        return pulumi.get(self, "influx_version")

    @influx_version.setter
    def influx_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "influx_version", value)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Bucket Name for influx connection
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        DB Name for influx connection
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter(name="organizationName")
    def organization_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Org name for the influx db
        """
        return pulumi.get(self, "organization_name")

    @organization_name.setter
    def organization_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_name", value)

    @_builtins.property
    @pulumi.getter(name="retentionPolicyName")
    def retention_policy_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        retention policy is how long the bucket would last
        """
        return pulumi.get(self, "retention_policy_name")

    @retention_policy_name.setter
    def retention_policy_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "retention_policy_name", value)


if not MYPY:
    class DetectAnomalyJobInputDetailsArgsDict(TypedDict):
        input_type: pulumi.Input[_builtins.str]
        """
        Type of request. This parameter is automatically populated by classes generated by the SDK. For raw curl requests, you must provide this field.
        """
        content: NotRequired[pulumi.Input[_builtins.str]]
        content_type: NotRequired[pulumi.Input[_builtins.str]]
        datas: NotRequired[pulumi.Input[Sequence[pulumi.Input['DetectAnomalyJobInputDetailsDataArgsDict']]]]
        """
        Array containing data.
        """
        message: NotRequired[pulumi.Input[_builtins.str]]
        """
        Inline input details.
        """
        object_locations: NotRequired[pulumi.Input[Sequence[pulumi.Input['DetectAnomalyJobInputDetailsObjectLocationArgsDict']]]]
        """
        List of ObjectLocations.
        """
        signal_names: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        List of signal names.
        """
elif False:
    DetectAnomalyJobInputDetailsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DetectAnomalyJobInputDetailsArgs:
    def __init__(__self__, *,
                 input_type: pulumi.Input[_builtins.str],
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 content_type: Optional[pulumi.Input[_builtins.str]] = None,
                 datas: Optional[pulumi.Input[Sequence[pulumi.Input['DetectAnomalyJobInputDetailsDataArgs']]]] = None,
                 message: Optional[pulumi.Input[_builtins.str]] = None,
                 object_locations: Optional[pulumi.Input[Sequence[pulumi.Input['DetectAnomalyJobInputDetailsObjectLocationArgs']]]] = None,
                 signal_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[_builtins.str] input_type: Type of request. This parameter is automatically populated by classes generated by the SDK. For raw curl requests, you must provide this field.
        :param pulumi.Input[Sequence[pulumi.Input['DetectAnomalyJobInputDetailsDataArgs']]] datas: Array containing data.
        :param pulumi.Input[_builtins.str] message: Inline input details.
        :param pulumi.Input[Sequence[pulumi.Input['DetectAnomalyJobInputDetailsObjectLocationArgs']]] object_locations: List of ObjectLocations.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] signal_names: List of signal names.
        """
        pulumi.set(__self__, "input_type", input_type)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if datas is not None:
            pulumi.set(__self__, "datas", datas)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if object_locations is not None:
            pulumi.set(__self__, "object_locations", object_locations)
        if signal_names is not None:
            pulumi.set(__self__, "signal_names", signal_names)

    @_builtins.property
    @pulumi.getter(name="inputType")
    def input_type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of request. This parameter is automatically populated by classes generated by the SDK. For raw curl requests, you must provide this field.
        """
        return pulumi.get(self, "input_type")

    @input_type.setter
    def input_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "input_type", value)

    @_builtins.property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content", value)

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_type", value)

    @_builtins.property
    @pulumi.getter
    def datas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DetectAnomalyJobInputDetailsDataArgs']]]]:
        """
        Array containing data.
        """
        return pulumi.get(self, "datas")

    @datas.setter
    def datas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DetectAnomalyJobInputDetailsDataArgs']]]]):
        pulumi.set(self, "datas", value)

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Inline input details.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "message", value)

    @_builtins.property
    @pulumi.getter(name="objectLocations")
    def object_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DetectAnomalyJobInputDetailsObjectLocationArgs']]]]:
        """
        List of ObjectLocations.
        """
        return pulumi.get(self, "object_locations")

    @object_locations.setter
    def object_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DetectAnomalyJobInputDetailsObjectLocationArgs']]]]):
        pulumi.set(self, "object_locations", value)

    @_builtins.property
    @pulumi.getter(name="signalNames")
    def signal_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of signal names.
        """
        return pulumi.get(self, "signal_names")

    @signal_names.setter
    def signal_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "signal_names", value)


if not MYPY:
    class DetectAnomalyJobInputDetailsDataArgsDict(TypedDict):
        timestamp: NotRequired[pulumi.Input[_builtins.str]]
        """
        Nullable string representing timestamp.
        """
        values: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.float]]]]
        """
        Array of double precision values.
        """
elif False:
    DetectAnomalyJobInputDetailsDataArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DetectAnomalyJobInputDetailsDataArgs:
    def __init__(__self__, *,
                 timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.float]]]] = None):
        """
        :param pulumi.Input[_builtins.str] timestamp: Nullable string representing timestamp.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.float]]] values: Array of double precision values.
        """
        if timestamp is not None:
            pulumi.set(__self__, "timestamp", timestamp)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def timestamp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Nullable string representing timestamp.
        """
        return pulumi.get(self, "timestamp")

    @timestamp.setter
    def timestamp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timestamp", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.float]]]]:
        """
        Array of double precision values.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.float]]]]):
        pulumi.set(self, "values", value)


if not MYPY:
    class DetectAnomalyJobInputDetailsObjectLocationArgsDict(TypedDict):
        bucket: NotRequired[pulumi.Input[_builtins.str]]
        """
        Object Storage bucket name.
        """
        namespace: NotRequired[pulumi.Input[_builtins.str]]
        """
        Object Storage namespace name.
        """
        object: NotRequired[pulumi.Input[_builtins.str]]
        """
        Object Storage object name.
        """
elif False:
    DetectAnomalyJobInputDetailsObjectLocationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DetectAnomalyJobInputDetailsObjectLocationArgs:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 object: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] bucket: Object Storage bucket name.
        :param pulumi.Input[_builtins.str] namespace: Object Storage namespace name.
        :param pulumi.Input[_builtins.str] object: Object Storage object name.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if object is not None:
            pulumi.set(__self__, "object", object)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Object Storage bucket name.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Object Storage namespace name.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Object Storage object name.
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "object", value)


if not MYPY:
    class DetectAnomalyJobOutputDetailsArgsDict(TypedDict):
        bucket: pulumi.Input[_builtins.str]
        """
        Object Storage bucket name.
        """
        namespace: pulumi.Input[_builtins.str]
        """
        Object Storage namespace.
        """
        output_type: pulumi.Input[_builtins.str]
        """
        The type of output location. Allowed values are:
        * `OBJECT_STORAGE`: Object store output location.
        """
        prefix: NotRequired[pulumi.Input[_builtins.str]]
        """
        Object Storage folder name.
        """
elif False:
    DetectAnomalyJobOutputDetailsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DetectAnomalyJobOutputDetailsArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[_builtins.str],
                 namespace: pulumi.Input[_builtins.str],
                 output_type: pulumi.Input[_builtins.str],
                 prefix: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] bucket: Object Storage bucket name.
        :param pulumi.Input[_builtins.str] namespace: Object Storage namespace.
        :param pulumi.Input[_builtins.str] output_type: The type of output location. Allowed values are:
               * `OBJECT_STORAGE`: Object store output location.
        :param pulumi.Input[_builtins.str] prefix: Object Storage folder name.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "output_type", output_type)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[_builtins.str]:
        """
        Object Storage bucket name.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[_builtins.str]:
        """
        Object Storage namespace.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="outputType")
    def output_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of output location. Allowed values are:
        * `OBJECT_STORAGE`: Object store output location.
        """
        return pulumi.get(self, "output_type")

    @output_type.setter
    def output_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "output_type", value)

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Object Storage folder name.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "prefix", value)


if not MYPY:
    class ModelModelTrainingDetailsArgsDict(TypedDict):
        data_asset_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        The list of OCIDs of the data assets to train the model. The dataAssets have to be in the same project where the ai model would reside.
        """
        algorithm_hint: NotRequired[pulumi.Input[_builtins.str]]
        """
        User can choose specific algorithm for training.
        """
        target_fap: NotRequired[pulumi.Input[_builtins.float]]
        """
        A target model accuracy metric user provides as their requirement
        """
        training_fraction: NotRequired[pulumi.Input[_builtins.float]]
        """
        Fraction of total data that is used for training the model. The remaining is used for validation of the model.
        """
        window_size: NotRequired[pulumi.Input[_builtins.int]]
        """
        This value would determine the window size of the training algorithm.
        """
elif False:
    ModelModelTrainingDetailsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ModelModelTrainingDetailsArgs:
    def __init__(__self__, *,
                 data_asset_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 algorithm_hint: Optional[pulumi.Input[_builtins.str]] = None,
                 target_fap: Optional[pulumi.Input[_builtins.float]] = None,
                 training_fraction: Optional[pulumi.Input[_builtins.float]] = None,
                 window_size: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] data_asset_ids: The list of OCIDs of the data assets to train the model. The dataAssets have to be in the same project where the ai model would reside.
        :param pulumi.Input[_builtins.str] algorithm_hint: User can choose specific algorithm for training.
        :param pulumi.Input[_builtins.float] target_fap: A target model accuracy metric user provides as their requirement
        :param pulumi.Input[_builtins.float] training_fraction: Fraction of total data that is used for training the model. The remaining is used for validation of the model.
        :param pulumi.Input[_builtins.int] window_size: This value would determine the window size of the training algorithm.
        """
        pulumi.set(__self__, "data_asset_ids", data_asset_ids)
        if algorithm_hint is not None:
            pulumi.set(__self__, "algorithm_hint", algorithm_hint)
        if target_fap is not None:
            pulumi.set(__self__, "target_fap", target_fap)
        if training_fraction is not None:
            pulumi.set(__self__, "training_fraction", training_fraction)
        if window_size is not None:
            pulumi.set(__self__, "window_size", window_size)

    @_builtins.property
    @pulumi.getter(name="dataAssetIds")
    def data_asset_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The list of OCIDs of the data assets to train the model. The dataAssets have to be in the same project where the ai model would reside.
        """
        return pulumi.get(self, "data_asset_ids")

    @data_asset_ids.setter
    def data_asset_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "data_asset_ids", value)

    @_builtins.property
    @pulumi.getter(name="algorithmHint")
    def algorithm_hint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User can choose specific algorithm for training.
        """
        return pulumi.get(self, "algorithm_hint")

    @algorithm_hint.setter
    def algorithm_hint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "algorithm_hint", value)

    @_builtins.property
    @pulumi.getter(name="targetFap")
    def target_fap(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        A target model accuracy metric user provides as their requirement
        """
        return pulumi.get(self, "target_fap")

    @target_fap.setter
    def target_fap(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "target_fap", value)

    @_builtins.property
    @pulumi.getter(name="trainingFraction")
    def training_fraction(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Fraction of total data that is used for training the model. The remaining is used for validation of the model.
        """
        return pulumi.get(self, "training_fraction")

    @training_fraction.setter
    def training_fraction(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "training_fraction", value)

    @_builtins.property
    @pulumi.getter(name="windowSize")
    def window_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        This value would determine the window size of the training algorithm.
        """
        return pulumi.get(self, "window_size")

    @window_size.setter
    def window_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "window_size", value)


if not MYPY:
    class ModelModelTrainingResultArgsDict(TypedDict):
        fap: NotRequired[pulumi.Input[_builtins.float]]
        """
        Accuracy metric for a signal.
        """
        is_training_goal_achieved: NotRequired[pulumi.Input[_builtins.bool]]
        """
        A boolean value to indicate if train goal/targetFap is achieved for trained model
        """
        mae: NotRequired[pulumi.Input[_builtins.float]]
        max_inference_sync_rows: NotRequired[pulumi.Input[_builtins.int]]
        multivariate_fap: NotRequired[pulumi.Input[_builtins.float]]
        """
        The model accuracy metric on timestamp level.
        """
        rmse: NotRequired[pulumi.Input[_builtins.float]]
        row_reduction_details: NotRequired[pulumi.Input[Sequence[pulumi.Input['ModelModelTrainingResultRowReductionDetailArgsDict']]]]
        """
        Information regarding how/what row reduction methods will be applied. If this property is not present or is null, then it means row reduction is not applied.
        """
        signal_details: NotRequired[pulumi.Input[Sequence[pulumi.Input['ModelModelTrainingResultSignalDetailArgsDict']]]]
        """
        The list of signal details.
        """
        warning: NotRequired[pulumi.Input[_builtins.str]]
        """
        A warning message to explain the reason when targetFap cannot be achieved for trained model
        """
        window_size: NotRequired[pulumi.Input[_builtins.int]]
        """
        Window size defined during training or deduced by the algorithm.
        """
elif False:
    ModelModelTrainingResultArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ModelModelTrainingResultArgs:
    def __init__(__self__, *,
                 fap: Optional[pulumi.Input[_builtins.float]] = None,
                 is_training_goal_achieved: Optional[pulumi.Input[_builtins.bool]] = None,
                 mae: Optional[pulumi.Input[_builtins.float]] = None,
                 max_inference_sync_rows: Optional[pulumi.Input[_builtins.int]] = None,
                 multivariate_fap: Optional[pulumi.Input[_builtins.float]] = None,
                 rmse: Optional[pulumi.Input[_builtins.float]] = None,
                 row_reduction_details: Optional[pulumi.Input[Sequence[pulumi.Input['ModelModelTrainingResultRowReductionDetailArgs']]]] = None,
                 signal_details: Optional[pulumi.Input[Sequence[pulumi.Input['ModelModelTrainingResultSignalDetailArgs']]]] = None,
                 warning: Optional[pulumi.Input[_builtins.str]] = None,
                 window_size: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.float] fap: Accuracy metric for a signal.
        :param pulumi.Input[_builtins.bool] is_training_goal_achieved: A boolean value to indicate if train goal/targetFap is achieved for trained model
        :param pulumi.Input[_builtins.float] multivariate_fap: The model accuracy metric on timestamp level.
        :param pulumi.Input[Sequence[pulumi.Input['ModelModelTrainingResultRowReductionDetailArgs']]] row_reduction_details: Information regarding how/what row reduction methods will be applied. If this property is not present or is null, then it means row reduction is not applied.
        :param pulumi.Input[Sequence[pulumi.Input['ModelModelTrainingResultSignalDetailArgs']]] signal_details: The list of signal details.
        :param pulumi.Input[_builtins.str] warning: A warning message to explain the reason when targetFap cannot be achieved for trained model
        :param pulumi.Input[_builtins.int] window_size: Window size defined during training or deduced by the algorithm.
        """
        if fap is not None:
            pulumi.set(__self__, "fap", fap)
        if is_training_goal_achieved is not None:
            pulumi.set(__self__, "is_training_goal_achieved", is_training_goal_achieved)
        if mae is not None:
            pulumi.set(__self__, "mae", mae)
        if max_inference_sync_rows is not None:
            pulumi.set(__self__, "max_inference_sync_rows", max_inference_sync_rows)
        if multivariate_fap is not None:
            pulumi.set(__self__, "multivariate_fap", multivariate_fap)
        if rmse is not None:
            pulumi.set(__self__, "rmse", rmse)
        if row_reduction_details is not None:
            pulumi.set(__self__, "row_reduction_details", row_reduction_details)
        if signal_details is not None:
            pulumi.set(__self__, "signal_details", signal_details)
        if warning is not None:
            pulumi.set(__self__, "warning", warning)
        if window_size is not None:
            pulumi.set(__self__, "window_size", window_size)

    @_builtins.property
    @pulumi.getter
    def fap(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Accuracy metric for a signal.
        """
        return pulumi.get(self, "fap")

    @fap.setter
    def fap(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "fap", value)

    @_builtins.property
    @pulumi.getter(name="isTrainingGoalAchieved")
    def is_training_goal_achieved(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A boolean value to indicate if train goal/targetFap is achieved for trained model
        """
        return pulumi.get(self, "is_training_goal_achieved")

    @is_training_goal_achieved.setter
    def is_training_goal_achieved(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_training_goal_achieved", value)

    @_builtins.property
    @pulumi.getter
    def mae(self) -> Optional[pulumi.Input[_builtins.float]]:
        return pulumi.get(self, "mae")

    @mae.setter
    def mae(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "mae", value)

    @_builtins.property
    @pulumi.getter(name="maxInferenceSyncRows")
    def max_inference_sync_rows(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "max_inference_sync_rows")

    @max_inference_sync_rows.setter
    def max_inference_sync_rows(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_inference_sync_rows", value)

    @_builtins.property
    @pulumi.getter(name="multivariateFap")
    def multivariate_fap(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The model accuracy metric on timestamp level.
        """
        return pulumi.get(self, "multivariate_fap")

    @multivariate_fap.setter
    def multivariate_fap(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "multivariate_fap", value)

    @_builtins.property
    @pulumi.getter
    def rmse(self) -> Optional[pulumi.Input[_builtins.float]]:
        return pulumi.get(self, "rmse")

    @rmse.setter
    def rmse(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "rmse", value)

    @_builtins.property
    @pulumi.getter(name="rowReductionDetails")
    def row_reduction_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ModelModelTrainingResultRowReductionDetailArgs']]]]:
        """
        Information regarding how/what row reduction methods will be applied. If this property is not present or is null, then it means row reduction is not applied.
        """
        return pulumi.get(self, "row_reduction_details")

    @row_reduction_details.setter
    def row_reduction_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ModelModelTrainingResultRowReductionDetailArgs']]]]):
        pulumi.set(self, "row_reduction_details", value)

    @_builtins.property
    @pulumi.getter(name="signalDetails")
    def signal_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ModelModelTrainingResultSignalDetailArgs']]]]:
        """
        The list of signal details.
        """
        return pulumi.get(self, "signal_details")

    @signal_details.setter
    def signal_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ModelModelTrainingResultSignalDetailArgs']]]]):
        pulumi.set(self, "signal_details", value)

    @_builtins.property
    @pulumi.getter
    def warning(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A warning message to explain the reason when targetFap cannot be achieved for trained model
        """
        return pulumi.get(self, "warning")

    @warning.setter
    def warning(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "warning", value)

    @_builtins.property
    @pulumi.getter(name="windowSize")
    def window_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Window size defined during training or deduced by the algorithm.
        """
        return pulumi.get(self, "window_size")

    @window_size.setter
    def window_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "window_size", value)


if not MYPY:
    class ModelModelTrainingResultRowReductionDetailArgsDict(TypedDict):
        is_reduction_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        A boolean value to indicate if row reduction is applied
        """
        reduction_method: NotRequired[pulumi.Input[_builtins.str]]
        """
        Method for row reduction:
        * DELETE_ROW - delete rows with equal intervals
        * AVERAGE_ROW - average multiple rows to one row
        """
        reduction_percentage: NotRequired[pulumi.Input[_builtins.float]]
        """
        A percentage to reduce data size down to on top of original data
        """
elif False:
    ModelModelTrainingResultRowReductionDetailArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ModelModelTrainingResultRowReductionDetailArgs:
    def __init__(__self__, *,
                 is_reduction_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 reduction_method: Optional[pulumi.Input[_builtins.str]] = None,
                 reduction_percentage: Optional[pulumi.Input[_builtins.float]] = None):
        """
        :param pulumi.Input[_builtins.bool] is_reduction_enabled: A boolean value to indicate if row reduction is applied
        :param pulumi.Input[_builtins.str] reduction_method: Method for row reduction:
               * DELETE_ROW - delete rows with equal intervals
               * AVERAGE_ROW - average multiple rows to one row
        :param pulumi.Input[_builtins.float] reduction_percentage: A percentage to reduce data size down to on top of original data
        """
        if is_reduction_enabled is not None:
            pulumi.set(__self__, "is_reduction_enabled", is_reduction_enabled)
        if reduction_method is not None:
            pulumi.set(__self__, "reduction_method", reduction_method)
        if reduction_percentage is not None:
            pulumi.set(__self__, "reduction_percentage", reduction_percentage)

    @_builtins.property
    @pulumi.getter(name="isReductionEnabled")
    def is_reduction_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A boolean value to indicate if row reduction is applied
        """
        return pulumi.get(self, "is_reduction_enabled")

    @is_reduction_enabled.setter
    def is_reduction_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_reduction_enabled", value)

    @_builtins.property
    @pulumi.getter(name="reductionMethod")
    def reduction_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Method for row reduction:
        * DELETE_ROW - delete rows with equal intervals
        * AVERAGE_ROW - average multiple rows to one row
        """
        return pulumi.get(self, "reduction_method")

    @reduction_method.setter
    def reduction_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reduction_method", value)

    @_builtins.property
    @pulumi.getter(name="reductionPercentage")
    def reduction_percentage(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        A percentage to reduce data size down to on top of original data
        """
        return pulumi.get(self, "reduction_percentage")

    @reduction_percentage.setter
    def reduction_percentage(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "reduction_percentage", value)


if not MYPY:
    class ModelModelTrainingResultSignalDetailArgsDict(TypedDict):
        details: NotRequired[pulumi.Input[_builtins.str]]
        """
        detailed information for a signal.
        """
        fap: NotRequired[pulumi.Input[_builtins.float]]
        """
        Accuracy metric for a signal.
        """
        is_quantized: NotRequired[pulumi.Input[_builtins.bool]]
        """
        A boolean value to indicate if a signal is quantized or not.
        """
        max: NotRequired[pulumi.Input[_builtins.float]]
        """
        Max value within a signal.
        """
        min: NotRequired[pulumi.Input[_builtins.float]]
        """
        Min value within a signal.
        """
        mvi_ratio: NotRequired[pulumi.Input[_builtins.float]]
        """
        The ratio of missing values in a signal filled/imputed by the IDP algorithm.
        """
        signal_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of a signal.
        """
        status: NotRequired[pulumi.Input[_builtins.str]]
        """
        Status of the signal:
        * ACCEPTED - the signal is used for training the model
        * DROPPED - the signal does not meet requirement, and is dropped before training the model.
        * OTHER - placeholder for other status
        """
        std: NotRequired[pulumi.Input[_builtins.float]]
        """
        Standard deviation of values within a signal.
        """
elif False:
    ModelModelTrainingResultSignalDetailArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ModelModelTrainingResultSignalDetailArgs:
    def __init__(__self__, *,
                 details: Optional[pulumi.Input[_builtins.str]] = None,
                 fap: Optional[pulumi.Input[_builtins.float]] = None,
                 is_quantized: Optional[pulumi.Input[_builtins.bool]] = None,
                 max: Optional[pulumi.Input[_builtins.float]] = None,
                 min: Optional[pulumi.Input[_builtins.float]] = None,
                 mvi_ratio: Optional[pulumi.Input[_builtins.float]] = None,
                 signal_name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 std: Optional[pulumi.Input[_builtins.float]] = None):
        """
        :param pulumi.Input[_builtins.str] details: detailed information for a signal.
        :param pulumi.Input[_builtins.float] fap: Accuracy metric for a signal.
        :param pulumi.Input[_builtins.bool] is_quantized: A boolean value to indicate if a signal is quantized or not.
        :param pulumi.Input[_builtins.float] max: Max value within a signal.
        :param pulumi.Input[_builtins.float] min: Min value within a signal.
        :param pulumi.Input[_builtins.float] mvi_ratio: The ratio of missing values in a signal filled/imputed by the IDP algorithm.
        :param pulumi.Input[_builtins.str] signal_name: The name of a signal.
        :param pulumi.Input[_builtins.str] status: Status of the signal:
               * ACCEPTED - the signal is used for training the model
               * DROPPED - the signal does not meet requirement, and is dropped before training the model.
               * OTHER - placeholder for other status
        :param pulumi.Input[_builtins.float] std: Standard deviation of values within a signal.
        """
        if details is not None:
            pulumi.set(__self__, "details", details)
        if fap is not None:
            pulumi.set(__self__, "fap", fap)
        if is_quantized is not None:
            pulumi.set(__self__, "is_quantized", is_quantized)
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)
        if mvi_ratio is not None:
            pulumi.set(__self__, "mvi_ratio", mvi_ratio)
        if signal_name is not None:
            pulumi.set(__self__, "signal_name", signal_name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if std is not None:
            pulumi.set(__self__, "std", std)

    @_builtins.property
    @pulumi.getter
    def details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        detailed information for a signal.
        """
        return pulumi.get(self, "details")

    @details.setter
    def details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "details", value)

    @_builtins.property
    @pulumi.getter
    def fap(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Accuracy metric for a signal.
        """
        return pulumi.get(self, "fap")

    @fap.setter
    def fap(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "fap", value)

    @_builtins.property
    @pulumi.getter(name="isQuantized")
    def is_quantized(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A boolean value to indicate if a signal is quantized or not.
        """
        return pulumi.get(self, "is_quantized")

    @is_quantized.setter
    def is_quantized(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_quantized", value)

    @_builtins.property
    @pulumi.getter
    def max(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Max value within a signal.
        """
        return pulumi.get(self, "max")

    @max.setter
    def max(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "max", value)

    @_builtins.property
    @pulumi.getter
    def min(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Min value within a signal.
        """
        return pulumi.get(self, "min")

    @min.setter
    def min(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "min", value)

    @_builtins.property
    @pulumi.getter(name="mviRatio")
    def mvi_ratio(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The ratio of missing values in a signal filled/imputed by the IDP algorithm.
        """
        return pulumi.get(self, "mvi_ratio")

    @mvi_ratio.setter
    def mvi_ratio(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "mvi_ratio", value)

    @_builtins.property
    @pulumi.getter(name="signalName")
    def signal_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of a signal.
        """
        return pulumi.get(self, "signal_name")

    @signal_name.setter
    def signal_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "signal_name", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of the signal:
        * ACCEPTED - the signal is used for training the model
        * DROPPED - the signal does not meet requirement, and is dropped before training the model.
        * OTHER - placeholder for other status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def std(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Standard deviation of values within a signal.
        """
        return pulumi.get(self, "std")

    @std.setter
    def std(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "std", value)


if not MYPY:
    class GetAiPrivateEndpointsFilterArgsDict(TypedDict):
        name: _builtins.str
        values: Sequence[_builtins.str]
        regex: NotRequired[_builtins.bool]
elif False:
    GetAiPrivateEndpointsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetAiPrivateEndpointsFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[_builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetDetectAnomalyJobsFilterArgsDict(TypedDict):
        name: _builtins.str
        values: Sequence[_builtins.str]
        regex: NotRequired[_builtins.bool]
elif False:
    GetDetectAnomalyJobsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetDetectAnomalyJobsFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[_builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetDetectionDataAssetsFilterArgsDict(TypedDict):
        name: _builtins.str
        values: Sequence[_builtins.str]
        regex: NotRequired[_builtins.bool]
elif False:
    GetDetectionDataAssetsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetDetectionDataAssetsFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[_builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetDetectionModelsFilterArgsDict(TypedDict):
        name: _builtins.str
        values: Sequence[_builtins.str]
        regex: NotRequired[_builtins.bool]
elif False:
    GetDetectionModelsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetDetectionModelsFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[_builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetDetectionProjectsFilterArgsDict(TypedDict):
        name: _builtins.str
        values: Sequence[_builtins.str]
        regex: NotRequired[_builtins.bool]
elif False:
    GetDetectionProjectsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetDetectionProjectsFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[_builtins.bool]):
        pulumi.set(self, "regex", value)


