# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDetectionDataAssetsResult',
    'AwaitableGetDetectionDataAssetsResult',
    'get_detection_data_assets',
    'get_detection_data_assets_output',
]

@pulumi.output_type
class GetDetectionDataAssetsResult:
    """
    A collection of values returned by getDetectionDataAssets.
    """
    def __init__(__self__, compartment_id=None, data_asset_collections=None, display_name=None, filters=None, id=None, project_id=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if data_asset_collections and not isinstance(data_asset_collections, list):
            raise TypeError("Expected argument 'data_asset_collections' to be a list")
        pulumi.set(__self__, "data_asset_collections", data_asset_collections)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment containing the DataAsset.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="dataAssetCollections")
    def data_asset_collections(self) -> Sequence['outputs.GetDetectionDataAssetsDataAssetCollectionResult']:
        """
        The list of data_asset_collection.
        """
        return pulumi.get(self, "data_asset_collections")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDetectionDataAssetsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[_builtins.str]:
        """
        The Unique project id which is created at project creation that is immutable on creation.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The lifecycle state of the Data Asset.
        """
        return pulumi.get(self, "state")


class AwaitableGetDetectionDataAssetsResult(GetDetectionDataAssetsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDetectionDataAssetsResult(
            compartment_id=self.compartment_id,
            data_asset_collections=self.data_asset_collections,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            project_id=self.project_id,
            state=self.state)


def get_detection_data_assets(compartment_id: Optional[_builtins.str] = None,
                              display_name: Optional[_builtins.str] = None,
                              filters: Optional[Sequence[Union['GetDetectionDataAssetsFilterArgs', 'GetDetectionDataAssetsFilterArgsDict']]] = None,
                              project_id: Optional[_builtins.str] = None,
                              state: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDetectionDataAssetsResult:
    """
    This data source provides the list of Data Assets in Oracle Cloud Infrastructure Ai Anomaly Detection service.

    Returns a list of DataAssets.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_data_assets = oci.AiAnomalyDetection.get_detection_data_assets(compartment_id=compartment_id,
        display_name=data_asset_display_name,
        project_id=test_project["id"],
        state=data_asset_state)
    ```


    :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param _builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param _builtins.str project_id: The ID of the project for which to list the objects.
    :param _builtins.str state: <b>Filter</b> results by the specified lifecycle state. Must be a valid state for the resource type.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['projectId'] = project_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:AiAnomalyDetection/getDetectionDataAssets:getDetectionDataAssets', __args__, opts=opts, typ=GetDetectionDataAssetsResult).value

    return AwaitableGetDetectionDataAssetsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        data_asset_collections=pulumi.get(__ret__, 'data_asset_collections'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        state=pulumi.get(__ret__, 'state'))
def get_detection_data_assets_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                     display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     filters: Optional[pulumi.Input[Optional[Sequence[Union['GetDetectionDataAssetsFilterArgs', 'GetDetectionDataAssetsFilterArgsDict']]]]] = None,
                                     project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDetectionDataAssetsResult]:
    """
    This data source provides the list of Data Assets in Oracle Cloud Infrastructure Ai Anomaly Detection service.

    Returns a list of DataAssets.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_data_assets = oci.AiAnomalyDetection.get_detection_data_assets(compartment_id=compartment_id,
        display_name=data_asset_display_name,
        project_id=test_project["id"],
        state=data_asset_state)
    ```


    :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param _builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param _builtins.str project_id: The ID of the project for which to list the objects.
    :param _builtins.str state: <b>Filter</b> results by the specified lifecycle state. Must be a valid state for the resource type.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['projectId'] = project_id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:AiAnomalyDetection/getDetectionDataAssets:getDetectionDataAssets', __args__, opts=opts, typ=GetDetectionDataAssetsResult)
    return __ret__.apply(lambda __response__: GetDetectionDataAssetsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        data_asset_collections=pulumi.get(__response__, 'data_asset_collections'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        project_id=pulumi.get(__response__, 'project_id'),
        state=pulumi.get(__response__, 'state')))
