# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetInternalOccmDemandSignalItemsResult',
    'AwaitableGetInternalOccmDemandSignalItemsResult',
    'get_internal_occm_demand_signal_items',
    'get_internal_occm_demand_signal_items_output',
]

@pulumi.output_type
class GetInternalOccmDemandSignalItemsResult:
    """
    A collection of values returned by getInternalOccmDemandSignalItems.
    """
    def __init__(__self__, compartment_id=None, demand_signal_namespace=None, filters=None, id=None, internal_occm_demand_signal_item_collections=None, occ_customer_group_id=None, occm_demand_signal_id=None, resource_name=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if demand_signal_namespace and not isinstance(demand_signal_namespace, str):
            raise TypeError("Expected argument 'demand_signal_namespace' to be a str")
        pulumi.set(__self__, "demand_signal_namespace", demand_signal_namespace)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if internal_occm_demand_signal_item_collections and not isinstance(internal_occm_demand_signal_item_collections, list):
            raise TypeError("Expected argument 'internal_occm_demand_signal_item_collections' to be a list")
        pulumi.set(__self__, "internal_occm_demand_signal_item_collections", internal_occm_demand_signal_item_collections)
        if occ_customer_group_id and not isinstance(occ_customer_group_id, str):
            raise TypeError("Expected argument 'occ_customer_group_id' to be a str")
        pulumi.set(__self__, "occ_customer_group_id", occ_customer_group_id)
        if occm_demand_signal_id and not isinstance(occm_demand_signal_id, str):
            raise TypeError("Expected argument 'occm_demand_signal_id' to be a str")
        pulumi.set(__self__, "occm_demand_signal_id", occm_demand_signal_id)
        if resource_name and not isinstance(resource_name, str):
            raise TypeError("Expected argument 'resource_name' to be a str")
        pulumi.set(__self__, "resource_name", resource_name)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the tenancy from which the demand signal item was created.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="demandSignalNamespace")
    def demand_signal_namespace(self) -> Optional[_builtins.str]:
        """
        The name of the Oracle Cloud Infrastructure service in consideration for demand signal submission. For example: COMPUTE, NETWORK, GPU etc.
        """
        return pulumi.get(self, "demand_signal_namespace")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetInternalOccmDemandSignalItemsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="internalOccmDemandSignalItemCollections")
    def internal_occm_demand_signal_item_collections(self) -> Sequence['outputs.GetInternalOccmDemandSignalItemsInternalOccmDemandSignalItemCollectionResult']:
        """
        The list of internal_occm_demand_signal_item_collection.
        """
        return pulumi.get(self, "internal_occm_demand_signal_item_collections")

    @_builtins.property
    @pulumi.getter(name="occCustomerGroupId")
    def occ_customer_group_id(self) -> _builtins.str:
        """
        The OCID of the customer group in which the demand signal is created.
        """
        return pulumi.get(self, "occ_customer_group_id")

    @_builtins.property
    @pulumi.getter(name="occmDemandSignalId")
    def occm_demand_signal_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "occm_demand_signal_id")

    @_builtins.property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> Optional[_builtins.str]:
        """
        The name of the Oracle Cloud Infrastructure resource that you want to request.
        """
        return pulumi.get(self, "resource_name")


class AwaitableGetInternalOccmDemandSignalItemsResult(GetInternalOccmDemandSignalItemsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInternalOccmDemandSignalItemsResult(
            compartment_id=self.compartment_id,
            demand_signal_namespace=self.demand_signal_namespace,
            filters=self.filters,
            id=self.id,
            internal_occm_demand_signal_item_collections=self.internal_occm_demand_signal_item_collections,
            occ_customer_group_id=self.occ_customer_group_id,
            occm_demand_signal_id=self.occm_demand_signal_id,
            resource_name=self.resource_name)


def get_internal_occm_demand_signal_items(compartment_id: Optional[_builtins.str] = None,
                                          demand_signal_namespace: Optional[_builtins.str] = None,
                                          filters: Optional[Sequence[Union['GetInternalOccmDemandSignalItemsFilterArgs', 'GetInternalOccmDemandSignalItemsFilterArgsDict']]] = None,
                                          occ_customer_group_id: Optional[_builtins.str] = None,
                                          occm_demand_signal_id: Optional[_builtins.str] = None,
                                          resource_name: Optional[_builtins.str] = None,
                                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInternalOccmDemandSignalItemsResult:
    """
    This data source provides the list of Internal Occm Demand Signal Items in Oracle Cloud Infrastructure Capacity Management service.

    This internal API will list the detailed information about the resources demanded as part of the demand signal.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_internal_occm_demand_signal_items = oci.CapacityManagement.get_internal_occm_demand_signal_items(compartment_id=compartment_id,
        occ_customer_group_id=test_occ_customer_group["id"],
        demand_signal_namespace=internal_occm_demand_signal_item_demand_signal_namespace,
        occm_demand_signal_id=test_occm_demand_signal["id"],
        resource_name=test_resource["name"])
    ```


    :param _builtins.str compartment_id: The ocid of the compartment or tenancy in which resources are to be listed. This will also be used for authorization purposes.
    :param _builtins.str demand_signal_namespace: A query parameter to filter the list of demand signal details based on the namespace.
    :param _builtins.str occ_customer_group_id: The customer group ocid by which we would filter the list.
    :param _builtins.str occm_demand_signal_id: A query parameter to filter the list of demand signal items based on a demand signal id.
    :param _builtins.str resource_name: A query parameter to filter the list of demand signal details based on the resource name.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['demandSignalNamespace'] = demand_signal_namespace
    __args__['filters'] = filters
    __args__['occCustomerGroupId'] = occ_customer_group_id
    __args__['occmDemandSignalId'] = occm_demand_signal_id
    __args__['resourceName'] = resource_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CapacityManagement/getInternalOccmDemandSignalItems:getInternalOccmDemandSignalItems', __args__, opts=opts, typ=GetInternalOccmDemandSignalItemsResult).value

    return AwaitableGetInternalOccmDemandSignalItemsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        demand_signal_namespace=pulumi.get(__ret__, 'demand_signal_namespace'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        internal_occm_demand_signal_item_collections=pulumi.get(__ret__, 'internal_occm_demand_signal_item_collections'),
        occ_customer_group_id=pulumi.get(__ret__, 'occ_customer_group_id'),
        occm_demand_signal_id=pulumi.get(__ret__, 'occm_demand_signal_id'),
        resource_name=pulumi.get(__ret__, 'resource_name'))
def get_internal_occm_demand_signal_items_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                 demand_signal_namespace: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                 filters: Optional[pulumi.Input[Optional[Sequence[Union['GetInternalOccmDemandSignalItemsFilterArgs', 'GetInternalOccmDemandSignalItemsFilterArgsDict']]]]] = None,
                                                 occ_customer_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                 occm_demand_signal_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                 resource_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInternalOccmDemandSignalItemsResult]:
    """
    This data source provides the list of Internal Occm Demand Signal Items in Oracle Cloud Infrastructure Capacity Management service.

    This internal API will list the detailed information about the resources demanded as part of the demand signal.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_internal_occm_demand_signal_items = oci.CapacityManagement.get_internal_occm_demand_signal_items(compartment_id=compartment_id,
        occ_customer_group_id=test_occ_customer_group["id"],
        demand_signal_namespace=internal_occm_demand_signal_item_demand_signal_namespace,
        occm_demand_signal_id=test_occm_demand_signal["id"],
        resource_name=test_resource["name"])
    ```


    :param _builtins.str compartment_id: The ocid of the compartment or tenancy in which resources are to be listed. This will also be used for authorization purposes.
    :param _builtins.str demand_signal_namespace: A query parameter to filter the list of demand signal details based on the namespace.
    :param _builtins.str occ_customer_group_id: The customer group ocid by which we would filter the list.
    :param _builtins.str occm_demand_signal_id: A query parameter to filter the list of demand signal items based on a demand signal id.
    :param _builtins.str resource_name: A query parameter to filter the list of demand signal details based on the resource name.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['demandSignalNamespace'] = demand_signal_namespace
    __args__['filters'] = filters
    __args__['occCustomerGroupId'] = occ_customer_group_id
    __args__['occmDemandSignalId'] = occm_demand_signal_id
    __args__['resourceName'] = resource_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:CapacityManagement/getInternalOccmDemandSignalItems:getInternalOccmDemandSignalItems', __args__, opts=opts, typ=GetInternalOccmDemandSignalItemsResult)
    return __ret__.apply(lambda __response__: GetInternalOccmDemandSignalItemsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        demand_signal_namespace=pulumi.get(__response__, 'demand_signal_namespace'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        internal_occm_demand_signal_item_collections=pulumi.get(__response__, 'internal_occm_demand_signal_item_collections'),
        occ_customer_group_id=pulumi.get(__response__, 'occ_customer_group_id'),
        occm_demand_signal_id=pulumi.get(__response__, 'occm_demand_signal_id'),
        resource_name=pulumi.get(__response__, 'resource_name')))
