# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetManagedMySqlDatabaseResult',
    'AwaitableGetManagedMySqlDatabaseResult',
    'get_managed_my_sql_database',
    'get_managed_my_sql_database_output',
]

@pulumi.output_type
class GetManagedMySqlDatabaseResult:
    """
    A collection of values returned by getManagedMySqlDatabase.
    """
    def __init__(__self__, compartment_id=None, database_type=None, db_name=None, db_version=None, heat_wave_cluster_display_name=None, heat_wave_management_type=None, heat_wave_memory_size=None, heat_wave_node_shape=None, heat_wave_nodes=None, id=None, is_heat_wave_active=None, is_heat_wave_enabled=None, is_lakehouse_enabled=None, managed_my_sql_database_id=None, management_state=None, name=None, state=None, time_created=None, time_created_heat_wave=None, time_updated=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if database_type and not isinstance(database_type, str):
            raise TypeError("Expected argument 'database_type' to be a str")
        pulumi.set(__self__, "database_type", database_type)
        if db_name and not isinstance(db_name, str):
            raise TypeError("Expected argument 'db_name' to be a str")
        pulumi.set(__self__, "db_name", db_name)
        if db_version and not isinstance(db_version, str):
            raise TypeError("Expected argument 'db_version' to be a str")
        pulumi.set(__self__, "db_version", db_version)
        if heat_wave_cluster_display_name and not isinstance(heat_wave_cluster_display_name, str):
            raise TypeError("Expected argument 'heat_wave_cluster_display_name' to be a str")
        pulumi.set(__self__, "heat_wave_cluster_display_name", heat_wave_cluster_display_name)
        if heat_wave_management_type and not isinstance(heat_wave_management_type, str):
            raise TypeError("Expected argument 'heat_wave_management_type' to be a str")
        pulumi.set(__self__, "heat_wave_management_type", heat_wave_management_type)
        if heat_wave_memory_size and not isinstance(heat_wave_memory_size, int):
            raise TypeError("Expected argument 'heat_wave_memory_size' to be a int")
        pulumi.set(__self__, "heat_wave_memory_size", heat_wave_memory_size)
        if heat_wave_node_shape and not isinstance(heat_wave_node_shape, str):
            raise TypeError("Expected argument 'heat_wave_node_shape' to be a str")
        pulumi.set(__self__, "heat_wave_node_shape", heat_wave_node_shape)
        if heat_wave_nodes and not isinstance(heat_wave_nodes, list):
            raise TypeError("Expected argument 'heat_wave_nodes' to be a list")
        pulumi.set(__self__, "heat_wave_nodes", heat_wave_nodes)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_heat_wave_active and not isinstance(is_heat_wave_active, bool):
            raise TypeError("Expected argument 'is_heat_wave_active' to be a bool")
        pulumi.set(__self__, "is_heat_wave_active", is_heat_wave_active)
        if is_heat_wave_enabled and not isinstance(is_heat_wave_enabled, bool):
            raise TypeError("Expected argument 'is_heat_wave_enabled' to be a bool")
        pulumi.set(__self__, "is_heat_wave_enabled", is_heat_wave_enabled)
        if is_lakehouse_enabled and not isinstance(is_lakehouse_enabled, bool):
            raise TypeError("Expected argument 'is_lakehouse_enabled' to be a bool")
        pulumi.set(__self__, "is_lakehouse_enabled", is_lakehouse_enabled)
        if managed_my_sql_database_id and not isinstance(managed_my_sql_database_id, str):
            raise TypeError("Expected argument 'managed_my_sql_database_id' to be a str")
        pulumi.set(__self__, "managed_my_sql_database_id", managed_my_sql_database_id)
        if management_state and not isinstance(management_state, str):
            raise TypeError("Expected argument 'management_state' to be a str")
        pulumi.set(__self__, "management_state", management_state)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_created_heat_wave and not isinstance(time_created_heat_wave, str):
            raise TypeError("Expected argument 'time_created_heat_wave' to be a str")
        pulumi.set(__self__, "time_created_heat_wave", time_created_heat_wave)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> _builtins.str:
        """
        The type of the MySQL Database. Indicates whether the database is external or MDS.
        """
        return pulumi.get(self, "database_type")

    @_builtins.property
    @pulumi.getter(name="dbName")
    def db_name(self) -> _builtins.str:
        """
        The name of the MySQL Database.
        """
        return pulumi.get(self, "db_name")

    @_builtins.property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> _builtins.str:
        """
        The version of the MySQL Database.
        """
        return pulumi.get(self, "db_version")

    @_builtins.property
    @pulumi.getter(name="heatWaveClusterDisplayName")
    def heat_wave_cluster_display_name(self) -> _builtins.str:
        """
        The name of the HeatWave cluster.
        """
        return pulumi.get(self, "heat_wave_cluster_display_name")

    @_builtins.property
    @pulumi.getter(name="heatWaveManagementType")
    def heat_wave_management_type(self) -> _builtins.str:
        """
        The customer's selected type for HeatWave management.
        """
        return pulumi.get(self, "heat_wave_management_type")

    @_builtins.property
    @pulumi.getter(name="heatWaveMemorySize")
    def heat_wave_memory_size(self) -> _builtins.int:
        """
        The total memory belonging to the HeatWave cluster in GBs.
        """
        return pulumi.get(self, "heat_wave_memory_size")

    @_builtins.property
    @pulumi.getter(name="heatWaveNodeShape")
    def heat_wave_node_shape(self) -> _builtins.str:
        """
        The shape of the nodes in the HeatWave cluster.
        """
        return pulumi.get(self, "heat_wave_node_shape")

    @_builtins.property
    @pulumi.getter(name="heatWaveNodes")
    def heat_wave_nodes(self) -> Sequence['outputs.GetManagedMySqlDatabaseHeatWaveNodeResult']:
        """
        The information about individual HeatWave nodes in the cluster.
        """
        return pulumi.get(self, "heat_wave_nodes")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isHeatWaveActive")
    def is_heat_wave_active(self) -> _builtins.bool:
        """
        Indicates whether the HeatWave cluster is active or not.
        """
        return pulumi.get(self, "is_heat_wave_active")

    @_builtins.property
    @pulumi.getter(name="isHeatWaveEnabled")
    def is_heat_wave_enabled(self) -> _builtins.bool:
        """
        Indicates whether HeatWave is enabled for the MySQL Database System or not.
        """
        return pulumi.get(self, "is_heat_wave_enabled")

    @_builtins.property
    @pulumi.getter(name="isLakehouseEnabled")
    def is_lakehouse_enabled(self) -> _builtins.bool:
        """
        Indicates whether HeatWave Lakehouse is enabled for the MySQL Database System or not.
        """
        return pulumi.get(self, "is_lakehouse_enabled")

    @_builtins.property
    @pulumi.getter(name="managedMySqlDatabaseId")
    def managed_my_sql_database_id(self) -> _builtins.str:
        return pulumi.get(self, "managed_my_sql_database_id")

    @_builtins.property
    @pulumi.getter(name="managementState")
    def management_state(self) -> _builtins.str:
        """
        Indicates database management status.
        """
        return pulumi.get(self, "management_state")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Managed MySQL Database.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        Indicates lifecycle  state of the resource.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the HeatWave node was created.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeCreatedHeatWave")
    def time_created_heat_wave(self) -> _builtins.str:
        """
        The date and time the Managed MySQL Database was created.
        """
        return pulumi.get(self, "time_created_heat_wave")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The date and time the Managed MySQL Database was updated.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetManagedMySqlDatabaseResult(GetManagedMySqlDatabaseResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedMySqlDatabaseResult(
            compartment_id=self.compartment_id,
            database_type=self.database_type,
            db_name=self.db_name,
            db_version=self.db_version,
            heat_wave_cluster_display_name=self.heat_wave_cluster_display_name,
            heat_wave_management_type=self.heat_wave_management_type,
            heat_wave_memory_size=self.heat_wave_memory_size,
            heat_wave_node_shape=self.heat_wave_node_shape,
            heat_wave_nodes=self.heat_wave_nodes,
            id=self.id,
            is_heat_wave_active=self.is_heat_wave_active,
            is_heat_wave_enabled=self.is_heat_wave_enabled,
            is_lakehouse_enabled=self.is_lakehouse_enabled,
            managed_my_sql_database_id=self.managed_my_sql_database_id,
            management_state=self.management_state,
            name=self.name,
            state=self.state,
            time_created=self.time_created,
            time_created_heat_wave=self.time_created_heat_wave,
            time_updated=self.time_updated)


def get_managed_my_sql_database(managed_my_sql_database_id: Optional[_builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedMySqlDatabaseResult:
    """
    This data source provides details about a specific Managed My Sql Database resource in Oracle Cloud Infrastructure Database Management service.

    Retrieves General Information for given MySQL Instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_my_sql_database = oci.DatabaseManagement.get_managed_my_sql_database(managed_my_sql_database_id=test_managed_my_sql_database_oci_database_management_managed_my_sql_database["id"])
    ```


    :param _builtins.str managed_my_sql_database_id: The OCID of ManagedMySqlDatabase.
    """
    __args__ = dict()
    __args__['managedMySqlDatabaseId'] = managed_my_sql_database_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getManagedMySqlDatabase:getManagedMySqlDatabase', __args__, opts=opts, typ=GetManagedMySqlDatabaseResult).value

    return AwaitableGetManagedMySqlDatabaseResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        database_type=pulumi.get(__ret__, 'database_type'),
        db_name=pulumi.get(__ret__, 'db_name'),
        db_version=pulumi.get(__ret__, 'db_version'),
        heat_wave_cluster_display_name=pulumi.get(__ret__, 'heat_wave_cluster_display_name'),
        heat_wave_management_type=pulumi.get(__ret__, 'heat_wave_management_type'),
        heat_wave_memory_size=pulumi.get(__ret__, 'heat_wave_memory_size'),
        heat_wave_node_shape=pulumi.get(__ret__, 'heat_wave_node_shape'),
        heat_wave_nodes=pulumi.get(__ret__, 'heat_wave_nodes'),
        id=pulumi.get(__ret__, 'id'),
        is_heat_wave_active=pulumi.get(__ret__, 'is_heat_wave_active'),
        is_heat_wave_enabled=pulumi.get(__ret__, 'is_heat_wave_enabled'),
        is_lakehouse_enabled=pulumi.get(__ret__, 'is_lakehouse_enabled'),
        managed_my_sql_database_id=pulumi.get(__ret__, 'managed_my_sql_database_id'),
        management_state=pulumi.get(__ret__, 'management_state'),
        name=pulumi.get(__ret__, 'name'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_created_heat_wave=pulumi.get(__ret__, 'time_created_heat_wave'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_managed_my_sql_database_output(managed_my_sql_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetManagedMySqlDatabaseResult]:
    """
    This data source provides details about a specific Managed My Sql Database resource in Oracle Cloud Infrastructure Database Management service.

    Retrieves General Information for given MySQL Instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_my_sql_database = oci.DatabaseManagement.get_managed_my_sql_database(managed_my_sql_database_id=test_managed_my_sql_database_oci_database_management_managed_my_sql_database["id"])
    ```


    :param _builtins.str managed_my_sql_database_id: The OCID of ManagedMySqlDatabase.
    """
    __args__ = dict()
    __args__['managedMySqlDatabaseId'] = managed_my_sql_database_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DatabaseManagement/getManagedMySqlDatabase:getManagedMySqlDatabase', __args__, opts=opts, typ=GetManagedMySqlDatabaseResult)
    return __ret__.apply(lambda __response__: GetManagedMySqlDatabaseResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        database_type=pulumi.get(__response__, 'database_type'),
        db_name=pulumi.get(__response__, 'db_name'),
        db_version=pulumi.get(__response__, 'db_version'),
        heat_wave_cluster_display_name=pulumi.get(__response__, 'heat_wave_cluster_display_name'),
        heat_wave_management_type=pulumi.get(__response__, 'heat_wave_management_type'),
        heat_wave_memory_size=pulumi.get(__response__, 'heat_wave_memory_size'),
        heat_wave_node_shape=pulumi.get(__response__, 'heat_wave_node_shape'),
        heat_wave_nodes=pulumi.get(__response__, 'heat_wave_nodes'),
        id=pulumi.get(__response__, 'id'),
        is_heat_wave_active=pulumi.get(__response__, 'is_heat_wave_active'),
        is_heat_wave_enabled=pulumi.get(__response__, 'is_heat_wave_enabled'),
        is_lakehouse_enabled=pulumi.get(__response__, 'is_lakehouse_enabled'),
        managed_my_sql_database_id=pulumi.get(__response__, 'managed_my_sql_database_id'),
        management_state=pulumi.get(__response__, 'management_state'),
        name=pulumi.get(__response__, 'name'),
        state=pulumi.get(__response__, 'state'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_created_heat_wave=pulumi.get(__response__, 'time_created_heat_wave'),
        time_updated=pulumi.get(__response__, 'time_updated')))
