# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDynamicGroupsResult',
    'AwaitableGetDynamicGroupsResult',
    'get_dynamic_groups',
    'get_dynamic_groups_output',
]

@pulumi.output_type
class GetDynamicGroupsResult:
    """
    A collection of values returned by getDynamicGroups.
    """
    def __init__(__self__, compartment_id=None, dynamic_groups=None, filters=None, id=None, name=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if dynamic_groups and not isinstance(dynamic_groups, list):
            raise TypeError("Expected argument 'dynamic_groups' to be a list")
        pulumi.set(__self__, "dynamic_groups", dynamic_groups)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the tenancy containing the group.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="dynamicGroups")
    def dynamic_groups(self) -> Sequence['outputs.GetDynamicGroupsDynamicGroupResult']:
        """
        The list of dynamic_groups.
        """
        return pulumi.get(self, "dynamic_groups")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDynamicGroupsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name you assign to the group during creation. The name must be unique across all groups in the tenancy and cannot be changed.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The group's current state.
        """
        return pulumi.get(self, "state")


class AwaitableGetDynamicGroupsResult(GetDynamicGroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDynamicGroupsResult(
            compartment_id=self.compartment_id,
            dynamic_groups=self.dynamic_groups,
            filters=self.filters,
            id=self.id,
            name=self.name,
            state=self.state)


def get_dynamic_groups(compartment_id: Optional[_builtins.str] = None,
                       filters: Optional[Sequence[Union['GetDynamicGroupsFilterArgs', 'GetDynamicGroupsFilterArgsDict']]] = None,
                       name: Optional[_builtins.str] = None,
                       state: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDynamicGroupsResult:
    """
    This data source provides the list of Dynamic Groups in Oracle Cloud Infrastructure Identity service.

    Lists the dynamic groups in your tenancy. You must specify your tenancy's OCID as the value for
    the compartment ID (remember that the tenancy is simply the root compartment).
    See [Where to Get the Tenancy's OCID and User's OCID](https://docs.cloud.oracle.com/iaas/Content/API/Concepts/apisigningkey.htm#five).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_dynamic_groups = oci.Identity.get_dynamic_groups(compartment_id=tenancy_ocid,
        name=dynamic_group_name,
        state=dynamic_group_state)
    ```


    :param _builtins.str compartment_id: The OCID of the compartment (remember that the tenancy is simply the root compartment).
    :param _builtins.str name: A filter to only return resources that match the given name exactly.
    :param _builtins.str state: A filter to only return resources that match the given lifecycle state.  The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Identity/getDynamicGroups:getDynamicGroups', __args__, opts=opts, typ=GetDynamicGroupsResult).value

    return AwaitableGetDynamicGroupsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        dynamic_groups=pulumi.get(__ret__, 'dynamic_groups'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        state=pulumi.get(__ret__, 'state'))
def get_dynamic_groups_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                              filters: Optional[pulumi.Input[Optional[Sequence[Union['GetDynamicGroupsFilterArgs', 'GetDynamicGroupsFilterArgsDict']]]]] = None,
                              name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDynamicGroupsResult]:
    """
    This data source provides the list of Dynamic Groups in Oracle Cloud Infrastructure Identity service.

    Lists the dynamic groups in your tenancy. You must specify your tenancy's OCID as the value for
    the compartment ID (remember that the tenancy is simply the root compartment).
    See [Where to Get the Tenancy's OCID and User's OCID](https://docs.cloud.oracle.com/iaas/Content/API/Concepts/apisigningkey.htm#five).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_dynamic_groups = oci.Identity.get_dynamic_groups(compartment_id=tenancy_ocid,
        name=dynamic_group_name,
        state=dynamic_group_state)
    ```


    :param _builtins.str compartment_id: The OCID of the compartment (remember that the tenancy is simply the root compartment).
    :param _builtins.str name: A filter to only return resources that match the given name exactly.
    :param _builtins.str state: A filter to only return resources that match the given lifecycle state.  The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Identity/getDynamicGroups:getDynamicGroups', __args__, opts=opts, typ=GetDynamicGroupsResult)
    return __ret__.apply(lambda __response__: GetDynamicGroupsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        dynamic_groups=pulumi.get(__response__, 'dynamic_groups'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        state=pulumi.get(__response__, 'state')))
