# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetMysqlBackupResult',
    'AwaitableGetMysqlBackupResult',
    'get_mysql_backup',
    'get_mysql_backup_output',
]

@pulumi.output_type
class GetMysqlBackupResult:
    """
    A collection of values returned by getMysqlBackup.
    """
    def __init__(__self__, backup_id=None, backup_size_in_gbs=None, backup_type=None, compartment_id=None, creation_type=None, data_storage_size_in_gb=None, db_system_id=None, db_system_snapshot_summaries=None, db_system_snapshots=None, defined_tags=None, description=None, display_name=None, encrypt_datas=None, freeform_tags=None, id=None, immediate_source_backup_id=None, lifecycle_details=None, mysql_version=None, original_source_backup_id=None, retention_in_days=None, shape_name=None, soft_delete=None, source_details=None, state=None, system_tags=None, time_copy_created=None, time_created=None, time_updated=None):
        if backup_id and not isinstance(backup_id, str):
            raise TypeError("Expected argument 'backup_id' to be a str")
        pulumi.set(__self__, "backup_id", backup_id)
        if backup_size_in_gbs and not isinstance(backup_size_in_gbs, int):
            raise TypeError("Expected argument 'backup_size_in_gbs' to be a int")
        pulumi.set(__self__, "backup_size_in_gbs", backup_size_in_gbs)
        if backup_type and not isinstance(backup_type, str):
            raise TypeError("Expected argument 'backup_type' to be a str")
        pulumi.set(__self__, "backup_type", backup_type)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if creation_type and not isinstance(creation_type, str):
            raise TypeError("Expected argument 'creation_type' to be a str")
        pulumi.set(__self__, "creation_type", creation_type)
        if data_storage_size_in_gb and not isinstance(data_storage_size_in_gb, int):
            raise TypeError("Expected argument 'data_storage_size_in_gb' to be a int")
        pulumi.set(__self__, "data_storage_size_in_gb", data_storage_size_in_gb)
        if db_system_id and not isinstance(db_system_id, str):
            raise TypeError("Expected argument 'db_system_id' to be a str")
        pulumi.set(__self__, "db_system_id", db_system_id)
        if db_system_snapshot_summaries and not isinstance(db_system_snapshot_summaries, list):
            raise TypeError("Expected argument 'db_system_snapshot_summaries' to be a list")
        pulumi.set(__self__, "db_system_snapshot_summaries", db_system_snapshot_summaries)
        if db_system_snapshots and not isinstance(db_system_snapshots, list):
            raise TypeError("Expected argument 'db_system_snapshots' to be a list")
        pulumi.set(__self__, "db_system_snapshots", db_system_snapshots)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if encrypt_datas and not isinstance(encrypt_datas, list):
            raise TypeError("Expected argument 'encrypt_datas' to be a list")
        pulumi.set(__self__, "encrypt_datas", encrypt_datas)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if immediate_source_backup_id and not isinstance(immediate_source_backup_id, str):
            raise TypeError("Expected argument 'immediate_source_backup_id' to be a str")
        pulumi.set(__self__, "immediate_source_backup_id", immediate_source_backup_id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if mysql_version and not isinstance(mysql_version, str):
            raise TypeError("Expected argument 'mysql_version' to be a str")
        pulumi.set(__self__, "mysql_version", mysql_version)
        if original_source_backup_id and not isinstance(original_source_backup_id, str):
            raise TypeError("Expected argument 'original_source_backup_id' to be a str")
        pulumi.set(__self__, "original_source_backup_id", original_source_backup_id)
        if retention_in_days and not isinstance(retention_in_days, int):
            raise TypeError("Expected argument 'retention_in_days' to be a int")
        pulumi.set(__self__, "retention_in_days", retention_in_days)
        if shape_name and not isinstance(shape_name, str):
            raise TypeError("Expected argument 'shape_name' to be a str")
        pulumi.set(__self__, "shape_name", shape_name)
        if soft_delete and not isinstance(soft_delete, str):
            raise TypeError("Expected argument 'soft_delete' to be a str")
        pulumi.set(__self__, "soft_delete", soft_delete)
        if source_details and not isinstance(source_details, list):
            raise TypeError("Expected argument 'source_details' to be a list")
        pulumi.set(__self__, "source_details", source_details)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_copy_created and not isinstance(time_copy_created, str):
            raise TypeError("Expected argument 'time_copy_created' to be a str")
        pulumi.set(__self__, "time_copy_created", time_copy_created)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> _builtins.str:
        return pulumi.get(self, "backup_id")

    @_builtins.property
    @pulumi.getter(name="backupSizeInGbs")
    def backup_size_in_gbs(self) -> _builtins.int:
        """
        The size of the backup in base-2 (IEC) gibibytes. (GiB).
        """
        return pulumi.get(self, "backup_size_in_gbs")

    @_builtins.property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> _builtins.str:
        """
        The type of backup.
        """
        return pulumi.get(self, "backup_type")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment the DB System belongs in.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="creationType")
    def creation_type(self) -> _builtins.str:
        """
        Indicates how the backup was created: manually, automatic, or by an Operator.
        """
        return pulumi.get(self, "creation_type")

    @_builtins.property
    @pulumi.getter(name="dataStorageSizeInGb")
    def data_storage_size_in_gb(self) -> _builtins.int:
        """
        DEPRECATED: User specified size of the data volume. May be less than current allocatedStorageSizeInGBs. Replaced by dataStorage.dataStorageSizeInGBs.
        """
        return pulumi.get(self, "data_storage_size_in_gb")

    @_builtins.property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> _builtins.str:
        """
        The OCID of the DB System the backup is associated with.
        """
        return pulumi.get(self, "db_system_id")

    @_builtins.property
    @pulumi.getter(name="dbSystemSnapshotSummaries")
    def db_system_snapshot_summaries(self) -> Sequence['outputs.GetMysqlBackupDbSystemSnapshotSummaryResult']:
        return pulumi.get(self, "db_system_snapshot_summaries")

    @_builtins.property
    @pulumi.getter(name="dbSystemSnapshots")
    def db_system_snapshots(self) -> Sequence['outputs.GetMysqlBackupDbSystemSnapshotResult']:
        """
        Snapshot of the DbSystem details at the time of the backup
        """
        return pulumi.get(self, "db_system_snapshots")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        A user-supplied description for the backup.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A user-supplied display name for the backup.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="encryptDatas")
    def encrypt_datas(self) -> Sequence['outputs.GetMysqlBackupEncryptDataResult']:
        """
        Encrypt data details.
        """
        return pulumi.get(self, "encrypt_datas")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        OCID of the backup itself
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="immediateSourceBackupId")
    def immediate_source_backup_id(self) -> _builtins.str:
        """
        The OCID of the immediate source DB system backup from which this DB system backup was copied.
        """
        return pulumi.get(self, "immediate_source_backup_id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        Additional information about the current lifecycleState.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="mysqlVersion")
    def mysql_version(self) -> _builtins.str:
        """
        The MySQL server version of the DB System used for backup.
        """
        return pulumi.get(self, "mysql_version")

    @_builtins.property
    @pulumi.getter(name="originalSourceBackupId")
    def original_source_backup_id(self) -> _builtins.str:
        """
        The OCID of the original source DB system backup from which this DB system backup was copied.
        """
        return pulumi.get(self, "original_source_backup_id")

    @_builtins.property
    @pulumi.getter(name="retentionInDays")
    def retention_in_days(self) -> _builtins.int:
        """
        Number of days to retain this backup.
        """
        return pulumi.get(self, "retention_in_days")

    @_builtins.property
    @pulumi.getter(name="shapeName")
    def shape_name(self) -> _builtins.str:
        """
        The shape of the DB System instance used for backup.
        """
        return pulumi.get(self, "shape_name")

    @_builtins.property
    @pulumi.getter(name="softDelete")
    def soft_delete(self) -> _builtins.str:
        """
        Retains the backup to be deleted due to the retention policy in DELETE SCHEDULED state for 7 days before permanently deleting it.
        """
        return pulumi.get(self, "soft_delete")

    @_builtins.property
    @pulumi.getter(name="sourceDetails")
    def source_details(self) -> Sequence['outputs.GetMysqlBackupSourceDetailResult']:
        return pulumi.get(self, "source_details")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The state of the backup.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCopyCreated")
    def time_copy_created(self) -> _builtins.str:
        """
        The date and time the DB system backup copy was created, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_copy_created")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time the backup record was created.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time at which the backup was updated.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetMysqlBackupResult(GetMysqlBackupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMysqlBackupResult(
            backup_id=self.backup_id,
            backup_size_in_gbs=self.backup_size_in_gbs,
            backup_type=self.backup_type,
            compartment_id=self.compartment_id,
            creation_type=self.creation_type,
            data_storage_size_in_gb=self.data_storage_size_in_gb,
            db_system_id=self.db_system_id,
            db_system_snapshot_summaries=self.db_system_snapshot_summaries,
            db_system_snapshots=self.db_system_snapshots,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            encrypt_datas=self.encrypt_datas,
            freeform_tags=self.freeform_tags,
            id=self.id,
            immediate_source_backup_id=self.immediate_source_backup_id,
            lifecycle_details=self.lifecycle_details,
            mysql_version=self.mysql_version,
            original_source_backup_id=self.original_source_backup_id,
            retention_in_days=self.retention_in_days,
            shape_name=self.shape_name,
            soft_delete=self.soft_delete,
            source_details=self.source_details,
            state=self.state,
            system_tags=self.system_tags,
            time_copy_created=self.time_copy_created,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_mysql_backup(backup_id: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMysqlBackupResult:
    """
    This data source provides details about a specific Mysql Backup resource in Oracle Cloud Infrastructure MySQL Database service.

    Get information about the specified Backup

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_mysql_backup = oci.Mysql.get_mysql_backup(backup_id=test_backup["id"])
    ```


    :param _builtins.str backup_id: The OCID of the Backup
    """
    __args__ = dict()
    __args__['backupId'] = backup_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Mysql/getMysqlBackup:getMysqlBackup', __args__, opts=opts, typ=GetMysqlBackupResult).value

    return AwaitableGetMysqlBackupResult(
        backup_id=pulumi.get(__ret__, 'backup_id'),
        backup_size_in_gbs=pulumi.get(__ret__, 'backup_size_in_gbs'),
        backup_type=pulumi.get(__ret__, 'backup_type'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        creation_type=pulumi.get(__ret__, 'creation_type'),
        data_storage_size_in_gb=pulumi.get(__ret__, 'data_storage_size_in_gb'),
        db_system_id=pulumi.get(__ret__, 'db_system_id'),
        db_system_snapshot_summaries=pulumi.get(__ret__, 'db_system_snapshot_summaries'),
        db_system_snapshots=pulumi.get(__ret__, 'db_system_snapshots'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        encrypt_datas=pulumi.get(__ret__, 'encrypt_datas'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        immediate_source_backup_id=pulumi.get(__ret__, 'immediate_source_backup_id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        mysql_version=pulumi.get(__ret__, 'mysql_version'),
        original_source_backup_id=pulumi.get(__ret__, 'original_source_backup_id'),
        retention_in_days=pulumi.get(__ret__, 'retention_in_days'),
        shape_name=pulumi.get(__ret__, 'shape_name'),
        soft_delete=pulumi.get(__ret__, 'soft_delete'),
        source_details=pulumi.get(__ret__, 'source_details'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_copy_created=pulumi.get(__ret__, 'time_copy_created'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_mysql_backup_output(backup_id: Optional[pulumi.Input[_builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMysqlBackupResult]:
    """
    This data source provides details about a specific Mysql Backup resource in Oracle Cloud Infrastructure MySQL Database service.

    Get information about the specified Backup

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_mysql_backup = oci.Mysql.get_mysql_backup(backup_id=test_backup["id"])
    ```


    :param _builtins.str backup_id: The OCID of the Backup
    """
    __args__ = dict()
    __args__['backupId'] = backup_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Mysql/getMysqlBackup:getMysqlBackup', __args__, opts=opts, typ=GetMysqlBackupResult)
    return __ret__.apply(lambda __response__: GetMysqlBackupResult(
        backup_id=pulumi.get(__response__, 'backup_id'),
        backup_size_in_gbs=pulumi.get(__response__, 'backup_size_in_gbs'),
        backup_type=pulumi.get(__response__, 'backup_type'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        creation_type=pulumi.get(__response__, 'creation_type'),
        data_storage_size_in_gb=pulumi.get(__response__, 'data_storage_size_in_gb'),
        db_system_id=pulumi.get(__response__, 'db_system_id'),
        db_system_snapshot_summaries=pulumi.get(__response__, 'db_system_snapshot_summaries'),
        db_system_snapshots=pulumi.get(__response__, 'db_system_snapshots'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        encrypt_datas=pulumi.get(__response__, 'encrypt_datas'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        immediate_source_backup_id=pulumi.get(__response__, 'immediate_source_backup_id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        mysql_version=pulumi.get(__response__, 'mysql_version'),
        original_source_backup_id=pulumi.get(__response__, 'original_source_backup_id'),
        retention_in_days=pulumi.get(__response__, 'retention_in_days'),
        shape_name=pulumi.get(__response__, 'shape_name'),
        soft_delete=pulumi.get(__response__, 'soft_delete'),
        source_details=pulumi.get(__response__, 'source_details'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_copy_created=pulumi.get(__response__, 'time_copy_created'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
