# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDbmulticloudOracleDbAzureVaultsResult',
    'AwaitableGetDbmulticloudOracleDbAzureVaultsResult',
    'get_dbmulticloud_oracle_db_azure_vaults',
    'get_dbmulticloud_oracle_db_azure_vaults_output',
]

@pulumi.output_type
class GetDbmulticloudOracleDbAzureVaultsResult:
    """
    A collection of values returned by getDbmulticloudOracleDbAzureVaults.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, oracle_db_azure_connector_id=None, oracle_db_azure_resource_group=None, oracle_db_azure_vault_id=None, oracle_db_azure_vault_summary_collections=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if oracle_db_azure_connector_id and not isinstance(oracle_db_azure_connector_id, str):
            raise TypeError("Expected argument 'oracle_db_azure_connector_id' to be a str")
        pulumi.set(__self__, "oracle_db_azure_connector_id", oracle_db_azure_connector_id)
        if oracle_db_azure_resource_group and not isinstance(oracle_db_azure_resource_group, str):
            raise TypeError("Expected argument 'oracle_db_azure_resource_group' to be a str")
        pulumi.set(__self__, "oracle_db_azure_resource_group", oracle_db_azure_resource_group)
        if oracle_db_azure_vault_id and not isinstance(oracle_db_azure_vault_id, str):
            raise TypeError("Expected argument 'oracle_db_azure_vault_id' to be a str")
        pulumi.set(__self__, "oracle_db_azure_vault_id", oracle_db_azure_vault_id)
        if oracle_db_azure_vault_summary_collections and not isinstance(oracle_db_azure_vault_summary_collections, list):
            raise TypeError("Expected argument 'oracle_db_azure_vault_summary_collections' to be a list")
        pulumi.set(__self__, "oracle_db_azure_vault_summary_collections", oracle_db_azure_vault_summary_collections)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The Compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that has this DB Azure Vault Resource.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        Display name of DB Azure Vault.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDbmulticloudOracleDbAzureVaultsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="oracleDbAzureConnectorId")
    def oracle_db_azure_connector_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "oracle_db_azure_connector_id")

    @_builtins.property
    @pulumi.getter(name="oracleDbAzureResourceGroup")
    def oracle_db_azure_resource_group(self) -> Optional[_builtins.str]:
        """
        Display name of Azure Resource Group.
        """
        return pulumi.get(self, "oracle_db_azure_resource_group")

    @_builtins.property
    @pulumi.getter(name="oracleDbAzureVaultId")
    def oracle_db_azure_vault_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "oracle_db_azure_vault_id")

    @_builtins.property
    @pulumi.getter(name="oracleDbAzureVaultSummaryCollections")
    def oracle_db_azure_vault_summary_collections(self) -> Sequence['outputs.GetDbmulticloudOracleDbAzureVaultsOracleDbAzureVaultSummaryCollectionResult']:
        """
        The list of oracle_db_azure_vault_summary_collection.
        """
        return pulumi.get(self, "oracle_db_azure_vault_summary_collections")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The lifecycle state of the DB Azure Vault Resource.
        """
        return pulumi.get(self, "state")


class AwaitableGetDbmulticloudOracleDbAzureVaultsResult(GetDbmulticloudOracleDbAzureVaultsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDbmulticloudOracleDbAzureVaultsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            oracle_db_azure_connector_id=self.oracle_db_azure_connector_id,
            oracle_db_azure_resource_group=self.oracle_db_azure_resource_group,
            oracle_db_azure_vault_id=self.oracle_db_azure_vault_id,
            oracle_db_azure_vault_summary_collections=self.oracle_db_azure_vault_summary_collections,
            state=self.state)


def get_dbmulticloud_oracle_db_azure_vaults(compartment_id: Optional[_builtins.str] = None,
                                            display_name: Optional[_builtins.str] = None,
                                            filters: Optional[Sequence[Union['GetDbmulticloudOracleDbAzureVaultsFilterArgs', 'GetDbmulticloudOracleDbAzureVaultsFilterArgsDict']]] = None,
                                            oracle_db_azure_connector_id: Optional[_builtins.str] = None,
                                            oracle_db_azure_resource_group: Optional[_builtins.str] = None,
                                            oracle_db_azure_vault_id: Optional[_builtins.str] = None,
                                            state: Optional[_builtins.str] = None,
                                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDbmulticloudOracleDbAzureVaultsResult:
    """
    This data source provides the list of Oracle Db Azure Vaults in Oracle Cloud Infrastructure Dbmulticloud service.

    Lists the all DB Azure Vaults based on filters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_oracle_db_azure_vaults = oci.oci.get_dbmulticloud_oracle_db_azure_vaults(compartment_id=compartment_id,
        display_name=oracle_db_azure_vault_display_name,
        oracle_db_azure_connector_id=test_oracle_db_azure_connector["id"],
        oracle_db_azure_resource_group=oracle_db_azure_vault_oracle_db_azure_resource_group,
        oracle_db_azure_vault_id=test_oracle_db_azure_vault["id"],
        state=oracle_db_azure_vault_state)
    ```


    :param _builtins.str compartment_id: The [ID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param _builtins.str display_name: A filter to return Azure Vaults.
    :param _builtins.str oracle_db_azure_connector_id: A filter to return Oracle DB Azure Blob Mount Resources.
    :param _builtins.str oracle_db_azure_resource_group: A filter to return Azure Vaults.
    :param _builtins.str oracle_db_azure_vault_id: A filter to return Oracle DB Azure Vault Resources.
    :param _builtins.str state: A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['oracleDbAzureConnectorId'] = oracle_db_azure_connector_id
    __args__['oracleDbAzureResourceGroup'] = oracle_db_azure_resource_group
    __args__['oracleDbAzureVaultId'] = oracle_db_azure_vault_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:oci/getDbmulticloudOracleDbAzureVaults:getDbmulticloudOracleDbAzureVaults', __args__, opts=opts, typ=GetDbmulticloudOracleDbAzureVaultsResult).value

    return AwaitableGetDbmulticloudOracleDbAzureVaultsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        oracle_db_azure_connector_id=pulumi.get(__ret__, 'oracle_db_azure_connector_id'),
        oracle_db_azure_resource_group=pulumi.get(__ret__, 'oracle_db_azure_resource_group'),
        oracle_db_azure_vault_id=pulumi.get(__ret__, 'oracle_db_azure_vault_id'),
        oracle_db_azure_vault_summary_collections=pulumi.get(__ret__, 'oracle_db_azure_vault_summary_collections'),
        state=pulumi.get(__ret__, 'state'))
def get_dbmulticloud_oracle_db_azure_vaults_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                   display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                   filters: Optional[pulumi.Input[Optional[Sequence[Union['GetDbmulticloudOracleDbAzureVaultsFilterArgs', 'GetDbmulticloudOracleDbAzureVaultsFilterArgsDict']]]]] = None,
                                                   oracle_db_azure_connector_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                   oracle_db_azure_resource_group: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                   oracle_db_azure_vault_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                   state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDbmulticloudOracleDbAzureVaultsResult]:
    """
    This data source provides the list of Oracle Db Azure Vaults in Oracle Cloud Infrastructure Dbmulticloud service.

    Lists the all DB Azure Vaults based on filters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_oracle_db_azure_vaults = oci.oci.get_dbmulticloud_oracle_db_azure_vaults(compartment_id=compartment_id,
        display_name=oracle_db_azure_vault_display_name,
        oracle_db_azure_connector_id=test_oracle_db_azure_connector["id"],
        oracle_db_azure_resource_group=oracle_db_azure_vault_oracle_db_azure_resource_group,
        oracle_db_azure_vault_id=test_oracle_db_azure_vault["id"],
        state=oracle_db_azure_vault_state)
    ```


    :param _builtins.str compartment_id: The [ID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param _builtins.str display_name: A filter to return Azure Vaults.
    :param _builtins.str oracle_db_azure_connector_id: A filter to return Oracle DB Azure Blob Mount Resources.
    :param _builtins.str oracle_db_azure_resource_group: A filter to return Azure Vaults.
    :param _builtins.str oracle_db_azure_vault_id: A filter to return Oracle DB Azure Vault Resources.
    :param _builtins.str state: A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['oracleDbAzureConnectorId'] = oracle_db_azure_connector_id
    __args__['oracleDbAzureResourceGroup'] = oracle_db_azure_resource_group
    __args__['oracleDbAzureVaultId'] = oracle_db_azure_vault_id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:oci/getDbmulticloudOracleDbAzureVaults:getDbmulticloudOracleDbAzureVaults', __args__, opts=opts, typ=GetDbmulticloudOracleDbAzureVaultsResult)
    return __ret__.apply(lambda __response__: GetDbmulticloudOracleDbAzureVaultsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        oracle_db_azure_connector_id=pulumi.get(__response__, 'oracle_db_azure_connector_id'),
        oracle_db_azure_resource_group=pulumi.get(__response__, 'oracle_db_azure_resource_group'),
        oracle_db_azure_vault_id=pulumi.get(__response__, 'oracle_db_azure_vault_id'),
        oracle_db_azure_vault_summary_collections=pulumi.get(__response__, 'oracle_db_azure_vault_summary_collections'),
        state=pulumi.get(__response__, 'state')))
