# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSubscriptionsResult',
    'AwaitableGetSubscriptionsResult',
    'get_subscriptions',
    'get_subscriptions_output',
]

@pulumi.output_type
class GetSubscriptionsResult:
    """
    A collection of values returned by getSubscriptions.
    """
    def __init__(__self__, buyer_email=None, compartment_id=None, filters=None, id=None, is_commit_info_required=None, plan_number=None, subscription_id=None, subscriptions=None):
        if buyer_email and not isinstance(buyer_email, str):
            raise TypeError("Expected argument 'buyer_email' to be a str")
        pulumi.set(__self__, "buyer_email", buyer_email)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_commit_info_required and not isinstance(is_commit_info_required, bool):
            raise TypeError("Expected argument 'is_commit_info_required' to be a bool")
        pulumi.set(__self__, "is_commit_info_required", is_commit_info_required)
        if plan_number and not isinstance(plan_number, str):
            raise TypeError("Expected argument 'plan_number' to be a str")
        pulumi.set(__self__, "plan_number", plan_number)
        if subscription_id and not isinstance(subscription_id, str):
            raise TypeError("Expected argument 'subscription_id' to be a str")
        pulumi.set(__self__, "subscription_id", subscription_id)
        if subscriptions and not isinstance(subscriptions, list):
            raise TypeError("Expected argument 'subscriptions' to be a list")
        pulumi.set(__self__, "subscriptions", subscriptions)

    @_builtins.property
    @pulumi.getter(name="buyerEmail")
    def buyer_email(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "buyer_email")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSubscriptionsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isCommitInfoRequired")
    def is_commit_info_required(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "is_commit_info_required")

    @_builtins.property
    @pulumi.getter(name="planNumber")
    def plan_number(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "plan_number")

    @_builtins.property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "subscription_id")

    @_builtins.property
    @pulumi.getter
    def subscriptions(self) -> Sequence['outputs.GetSubscriptionsSubscriptionResult']:
        """
        The list of subscriptions.
        """
        return pulumi.get(self, "subscriptions")


class AwaitableGetSubscriptionsResult(GetSubscriptionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSubscriptionsResult(
            buyer_email=self.buyer_email,
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            is_commit_info_required=self.is_commit_info_required,
            plan_number=self.plan_number,
            subscription_id=self.subscription_id,
            subscriptions=self.subscriptions)


def get_subscriptions(buyer_email: Optional[_builtins.str] = None,
                      compartment_id: Optional[_builtins.str] = None,
                      filters: Optional[Sequence[Union['GetSubscriptionsFilterArgs', 'GetSubscriptionsFilterArgsDict']]] = None,
                      is_commit_info_required: Optional[_builtins.bool] = None,
                      plan_number: Optional[_builtins.str] = None,
                      subscription_id: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSubscriptionsResult:
    """
    This data source provides the list of Subscriptions in Oracle Cloud Infrastructure Onesubscription service.

    This list API returns all subscriptions for a given plan number or subscription id or buyer email
    and provides additional parameters to include ratecard and commitment details.
    This API expects exactly one of the above mentioned parameters as input. If more than one parameters are provided the API will throw
    a 400 - invalid parameters exception and if no parameters are provided it will throw a 400 - missing parameter exception

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_subscriptions = oci.OneSubsription.get_subscriptions(compartment_id=compartment_id,
        buyer_email=subscription_buyer_email,
        is_commit_info_required=subscription_is_commit_info_required,
        plan_number=subscription_plan_number,
        subscription_id=test_subscription["id"])
    ```


    :param _builtins.str buyer_email: Buyer Email Id
    :param _builtins.str compartment_id: The OCID of the root compartment.
    :param _builtins.bool is_commit_info_required: Boolean value to decide whether commitment services will be shown
    :param _builtins.str plan_number: The Plan Number
    :param _builtins.str subscription_id: Line level Subscription Id
    """
    __args__ = dict()
    __args__['buyerEmail'] = buyer_email
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['isCommitInfoRequired'] = is_commit_info_required
    __args__['planNumber'] = plan_number
    __args__['subscriptionId'] = subscription_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OneSubsription/getSubscriptions:getSubscriptions', __args__, opts=opts, typ=GetSubscriptionsResult).value

    return AwaitableGetSubscriptionsResult(
        buyer_email=pulumi.get(__ret__, 'buyer_email'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        is_commit_info_required=pulumi.get(__ret__, 'is_commit_info_required'),
        plan_number=pulumi.get(__ret__, 'plan_number'),
        subscription_id=pulumi.get(__ret__, 'subscription_id'),
        subscriptions=pulumi.get(__ret__, 'subscriptions'))
def get_subscriptions_output(buyer_email: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                             filters: Optional[pulumi.Input[Optional[Sequence[Union['GetSubscriptionsFilterArgs', 'GetSubscriptionsFilterArgsDict']]]]] = None,
                             is_commit_info_required: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                             plan_number: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             subscription_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSubscriptionsResult]:
    """
    This data source provides the list of Subscriptions in Oracle Cloud Infrastructure Onesubscription service.

    This list API returns all subscriptions for a given plan number or subscription id or buyer email
    and provides additional parameters to include ratecard and commitment details.
    This API expects exactly one of the above mentioned parameters as input. If more than one parameters are provided the API will throw
    a 400 - invalid parameters exception and if no parameters are provided it will throw a 400 - missing parameter exception

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_subscriptions = oci.OneSubsription.get_subscriptions(compartment_id=compartment_id,
        buyer_email=subscription_buyer_email,
        is_commit_info_required=subscription_is_commit_info_required,
        plan_number=subscription_plan_number,
        subscription_id=test_subscription["id"])
    ```


    :param _builtins.str buyer_email: Buyer Email Id
    :param _builtins.str compartment_id: The OCID of the root compartment.
    :param _builtins.bool is_commit_info_required: Boolean value to decide whether commitment services will be shown
    :param _builtins.str plan_number: The Plan Number
    :param _builtins.str subscription_id: Line level Subscription Id
    """
    __args__ = dict()
    __args__['buyerEmail'] = buyer_email
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['isCommitInfoRequired'] = is_commit_info_required
    __args__['planNumber'] = plan_number
    __args__['subscriptionId'] = subscription_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:OneSubsription/getSubscriptions:getSubscriptions', __args__, opts=opts, typ=GetSubscriptionsResult)
    return __ret__.apply(lambda __response__: GetSubscriptionsResult(
        buyer_email=pulumi.get(__response__, 'buyer_email'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        is_commit_info_required=pulumi.get(__response__, 'is_commit_info_required'),
        plan_number=pulumi.get(__response__, 'plan_number'),
        subscription_id=pulumi.get(__response__, 'subscription_id'),
        subscriptions=pulumi.get(__response__, 'subscriptions')))
