# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetHistoriesResult',
    'AwaitableGetHistoriesResult',
    'get_histories',
    'get_histories_output',
]

@pulumi.output_type
class GetHistoriesResult:
    """
    A collection of values returned by getHistories.
    """
    def __init__(__self__, compartment_id=None, compartment_id_in_subtree=None, filters=None, history_collections=None, id=None, include_resource_metadata=None, name=None, recommendation_id=None, recommendation_name=None, resource_type=None, state=None, status=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if history_collections and not isinstance(history_collections, list):
            raise TypeError("Expected argument 'history_collections' to be a list")
        pulumi.set(__self__, "history_collections", history_collections)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if include_resource_metadata and not isinstance(include_resource_metadata, bool):
            raise TypeError("Expected argument 'include_resource_metadata' to be a bool")
        pulumi.set(__self__, "include_resource_metadata", include_resource_metadata)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if recommendation_id and not isinstance(recommendation_id, str):
            raise TypeError("Expected argument 'recommendation_id' to be a str")
        pulumi.set(__self__, "recommendation_id", recommendation_id)
        if recommendation_name and not isinstance(recommendation_name, str):
            raise TypeError("Expected argument 'recommendation_name' to be a str")
        pulumi.set(__self__, "recommendation_name", recommendation_name)
        if resource_type and not isinstance(resource_type, str):
            raise TypeError("Expected argument 'resource_type' to be a str")
        pulumi.set(__self__, "resource_type", resource_type)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> _builtins.bool:
        return pulumi.get(self, "compartment_id_in_subtree")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetHistoriesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter(name="historyCollections")
    def history_collections(self) -> Sequence['outputs.GetHistoriesHistoryCollectionResult']:
        """
        The list of history_collection.
        """
        return pulumi.get(self, "history_collections")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="includeResourceMetadata")
    def include_resource_metadata(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "include_resource_metadata")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name assigned to the resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="recommendationId")
    def recommendation_id(self) -> Optional[_builtins.str]:
        """
        The unique OCID associated with the recommendation.
        """
        return pulumi.get(self, "recommendation_id")

    @_builtins.property
    @pulumi.getter(name="recommendationName")
    def recommendation_name(self) -> Optional[_builtins.str]:
        """
        The name assigned to the recommendation.
        """
        return pulumi.get(self, "recommendation_name")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[_builtins.str]:
        """
        The kind of resource.
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The recommendation history's current state.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The current status of the resource action.
        """
        return pulumi.get(self, "status")


class AwaitableGetHistoriesResult(GetHistoriesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetHistoriesResult(
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            filters=self.filters,
            history_collections=self.history_collections,
            id=self.id,
            include_resource_metadata=self.include_resource_metadata,
            name=self.name,
            recommendation_id=self.recommendation_id,
            recommendation_name=self.recommendation_name,
            resource_type=self.resource_type,
            state=self.state,
            status=self.status)


def get_histories(compartment_id: Optional[_builtins.str] = None,
                  compartment_id_in_subtree: Optional[_builtins.bool] = None,
                  filters: Optional[Sequence[Union['GetHistoriesFilterArgs', 'GetHistoriesFilterArgsDict']]] = None,
                  include_resource_metadata: Optional[_builtins.bool] = None,
                  name: Optional[_builtins.str] = None,
                  recommendation_id: Optional[_builtins.str] = None,
                  recommendation_name: Optional[_builtins.str] = None,
                  resource_type: Optional[_builtins.str] = None,
                  state: Optional[_builtins.str] = None,
                  status: Optional[_builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetHistoriesResult:
    """
    This data source provides the list of Histories in Oracle Cloud Infrastructure Optimizer service.

    Lists changes to the recommendations based on user activity.
    For example, lists when recommendations have been implemented, dismissed, postponed, or reactivated.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_histories = oci.Optimizer.get_histories(compartment_id=compartment_id,
        compartment_id_in_subtree=history_compartment_id_in_subtree,
        include_resource_metadata=history_include_resource_metadata,
        name=history_name,
        recommendation_id=test_recommendation["id"],
        recommendation_name=test_recommendation["name"],
        resource_type=history_resource_type,
        state=history_state,
        status=history_status)
    ```


    :param _builtins.str compartment_id: The OCID of the compartment.
    :param _builtins.bool compartment_id_in_subtree: When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned depending on the the setting of `accessLevel`.
           
           Can only be set to true when performing ListCompartments on the tenancy (root compartment).
    :param _builtins.bool include_resource_metadata: Supplement additional resource information in extended metadata response.
    :param _builtins.str name: Optional. A filter that returns results that match the name specified.
    :param _builtins.str recommendation_id: The unique OCID associated with the recommendation.
    :param _builtins.str recommendation_name: Optional. A filter that returns results that match the recommendation name specified.
    :param _builtins.str resource_type: Optional. A filter that returns results that match the resource type specified.
    :param _builtins.str state: A filter that returns results that match the lifecycle state specified.
    :param _builtins.str status: A filter that returns recommendations that match the status specified.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['filters'] = filters
    __args__['includeResourceMetadata'] = include_resource_metadata
    __args__['name'] = name
    __args__['recommendationId'] = recommendation_id
    __args__['recommendationName'] = recommendation_name
    __args__['resourceType'] = resource_type
    __args__['state'] = state
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Optimizer/getHistories:getHistories', __args__, opts=opts, typ=GetHistoriesResult).value

    return AwaitableGetHistoriesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        filters=pulumi.get(__ret__, 'filters'),
        history_collections=pulumi.get(__ret__, 'history_collections'),
        id=pulumi.get(__ret__, 'id'),
        include_resource_metadata=pulumi.get(__ret__, 'include_resource_metadata'),
        name=pulumi.get(__ret__, 'name'),
        recommendation_id=pulumi.get(__ret__, 'recommendation_id'),
        recommendation_name=pulumi.get(__ret__, 'recommendation_name'),
        resource_type=pulumi.get(__ret__, 'resource_type'),
        state=pulumi.get(__ret__, 'state'),
        status=pulumi.get(__ret__, 'status'))
def get_histories_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                         compartment_id_in_subtree: Optional[pulumi.Input[_builtins.bool]] = None,
                         filters: Optional[pulumi.Input[Optional[Sequence[Union['GetHistoriesFilterArgs', 'GetHistoriesFilterArgsDict']]]]] = None,
                         include_resource_metadata: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                         name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         recommendation_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         recommendation_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         resource_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetHistoriesResult]:
    """
    This data source provides the list of Histories in Oracle Cloud Infrastructure Optimizer service.

    Lists changes to the recommendations based on user activity.
    For example, lists when recommendations have been implemented, dismissed, postponed, or reactivated.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_histories = oci.Optimizer.get_histories(compartment_id=compartment_id,
        compartment_id_in_subtree=history_compartment_id_in_subtree,
        include_resource_metadata=history_include_resource_metadata,
        name=history_name,
        recommendation_id=test_recommendation["id"],
        recommendation_name=test_recommendation["name"],
        resource_type=history_resource_type,
        state=history_state,
        status=history_status)
    ```


    :param _builtins.str compartment_id: The OCID of the compartment.
    :param _builtins.bool compartment_id_in_subtree: When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned depending on the the setting of `accessLevel`.
           
           Can only be set to true when performing ListCompartments on the tenancy (root compartment).
    :param _builtins.bool include_resource_metadata: Supplement additional resource information in extended metadata response.
    :param _builtins.str name: Optional. A filter that returns results that match the name specified.
    :param _builtins.str recommendation_id: The unique OCID associated with the recommendation.
    :param _builtins.str recommendation_name: Optional. A filter that returns results that match the recommendation name specified.
    :param _builtins.str resource_type: Optional. A filter that returns results that match the resource type specified.
    :param _builtins.str state: A filter that returns results that match the lifecycle state specified.
    :param _builtins.str status: A filter that returns recommendations that match the status specified.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['filters'] = filters
    __args__['includeResourceMetadata'] = include_resource_metadata
    __args__['name'] = name
    __args__['recommendationId'] = recommendation_id
    __args__['recommendationName'] = recommendation_name
    __args__['resourceType'] = resource_type
    __args__['state'] = state
    __args__['status'] = status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Optimizer/getHistories:getHistories', __args__, opts=opts, typ=GetHistoriesResult)
    return __ret__.apply(lambda __response__: GetHistoriesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__response__, 'compartment_id_in_subtree'),
        filters=pulumi.get(__response__, 'filters'),
        history_collections=pulumi.get(__response__, 'history_collections'),
        id=pulumi.get(__response__, 'id'),
        include_resource_metadata=pulumi.get(__response__, 'include_resource_metadata'),
        name=pulumi.get(__response__, 'name'),
        recommendation_id=pulumi.get(__response__, 'recommendation_id'),
        recommendation_name=pulumi.get(__response__, 'recommendation_name'),
        resource_type=pulumi.get(__response__, 'resource_type'),
        state=pulumi.get(__response__, 'state'),
        status=pulumi.get(__response__, 'status')))
