# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['EnvironmentVersionTagArgs', 'EnvironmentVersionTag']

@pulumi.input_type
class EnvironmentVersionTagArgs:
    def __init__(__self__, *,
                 environment: pulumi.Input[str],
                 organization: pulumi.Input[str],
                 revision: pulumi.Input[int],
                 tag_name: pulumi.Input[str],
                 project: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a EnvironmentVersionTag resource.
        :param pulumi.Input[str] environment: Environment name.
        :param pulumi.Input[str] organization: Organization name.
        :param pulumi.Input[int] revision: Revision number.
        :param pulumi.Input[str] tag_name: Tag name.
        :param pulumi.Input[str] project: Project name.
        """
        pulumi.set(__self__, "environment", environment)
        pulumi.set(__self__, "organization", organization)
        pulumi.set(__self__, "revision", revision)
        pulumi.set(__self__, "tag_name", tag_name)
        if project is None:
            project = 'default'
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def environment(self) -> pulumi.Input[str]:
        """
        Environment name.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: pulumi.Input[str]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter
    def organization(self) -> pulumi.Input[str]:
        """
        Organization name.
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: pulumi.Input[str]):
        pulumi.set(self, "organization", value)

    @property
    @pulumi.getter
    def revision(self) -> pulumi.Input[int]:
        """
        Revision number.
        """
        return pulumi.get(self, "revision")

    @revision.setter
    def revision(self, value: pulumi.Input[int]):
        pulumi.set(self, "revision", value)

    @property
    @pulumi.getter(name="tagName")
    def tag_name(self) -> pulumi.Input[str]:
        """
        Tag name.
        """
        return pulumi.get(self, "tag_name")

    @tag_name.setter
    def tag_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "tag_name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        Project name.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


class EnvironmentVersionTag(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 environment: Optional[pulumi.Input[str]] = None,
                 organization: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 revision: Optional[pulumi.Input[int]] = None,
                 tag_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        A tag on a specific revision of an environment.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] environment: Environment name.
        :param pulumi.Input[str] organization: Organization name.
        :param pulumi.Input[str] project: Project name.
        :param pulumi.Input[int] revision: Revision number.
        :param pulumi.Input[str] tag_name: Tag name.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EnvironmentVersionTagArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A tag on a specific revision of an environment.

        :param str resource_name: The name of the resource.
        :param EnvironmentVersionTagArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnvironmentVersionTagArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 environment: Optional[pulumi.Input[str]] = None,
                 organization: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 revision: Optional[pulumi.Input[int]] = None,
                 tag_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnvironmentVersionTagArgs.__new__(EnvironmentVersionTagArgs)

            if environment is None and not opts.urn:
                raise TypeError("Missing required property 'environment'")
            __props__.__dict__["environment"] = environment
            if organization is None and not opts.urn:
                raise TypeError("Missing required property 'organization'")
            __props__.__dict__["organization"] = organization
            if project is None:
                project = 'default'
            __props__.__dict__["project"] = project
            if revision is None and not opts.urn:
                raise TypeError("Missing required property 'revision'")
            __props__.__dict__["revision"] = revision
            if tag_name is None and not opts.urn:
                raise TypeError("Missing required property 'tag_name'")
            __props__.__dict__["tag_name"] = tag_name
        super(EnvironmentVersionTag, __self__).__init__(
            'pulumiservice:index:EnvironmentVersionTag',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'EnvironmentVersionTag':
        """
        Get an existing EnvironmentVersionTag resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = EnvironmentVersionTagArgs.__new__(EnvironmentVersionTagArgs)

        __props__.__dict__["environment"] = None
        __props__.__dict__["organization"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["revision"] = None
        __props__.__dict__["tag_name"] = None
        return EnvironmentVersionTag(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def environment(self) -> pulumi.Output[str]:
        """
        Environment name.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter
    def organization(self) -> pulumi.Output[str]:
        """
        Organization name.
        """
        return pulumi.get(self, "organization")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        Project name.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def revision(self) -> pulumi.Output[int]:
        """
        Revision number.
        """
        return pulumi.get(self, "revision")

    @property
    @pulumi.getter(name="tagName")
    def tag_name(self) -> pulumi.Output[str]:
        """
        Tag name.
        """
        return pulumi.get(self, "tag_name")

