# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AWSOIDCConfiguration',
    'AzureOIDCConfiguration',
    'DeploymentSettingsExecutorContext',
    'DeploymentSettingsGitAuthBasicAuth',
    'DeploymentSettingsGitAuthSSHAuth',
    'DeploymentSettingsGitSource',
    'DeploymentSettingsGitSourceGitAuth',
    'DeploymentSettingsGithub',
    'DeploymentSettingsOperationContext',
    'DeploymentSettingsSourceContext',
    'GCPOIDCConfiguration',
    'OperationContextOIDC',
    'OperationContextOptions',
    'TemplateSourceDestination',
]

@pulumi.output_type
class AWSOIDCConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleARN":
            suggest = "role_arn"
        elif key == "sessionName":
            suggest = "session_name"
        elif key == "policyARNs":
            suggest = "policy_arns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AWSOIDCConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AWSOIDCConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AWSOIDCConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 role_arn: str,
                 session_name: str,
                 duration: Optional[str] = None,
                 policy_arns: Optional[Sequence[str]] = None):
        """
        :param str role_arn: The ARN of the role to assume using the OIDC token.
        :param str session_name: The name of the assume-role session.
        :param str duration: Duration of the assume-role session in “XhYmZs” format
        :param Sequence[str] policy_arns: Optional set of IAM policy ARNs that further restrict the assume-role session
        """
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "session_name", session_name)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if policy_arns is not None:
            pulumi.set(__self__, "policy_arns", policy_arns)

    @property
    @pulumi.getter(name="roleARN")
    def role_arn(self) -> str:
        """
        The ARN of the role to assume using the OIDC token.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="sessionName")
    def session_name(self) -> str:
        """
        The name of the assume-role session.
        """
        return pulumi.get(self, "session_name")

    @property
    @pulumi.getter
    def duration(self) -> Optional[str]:
        """
        Duration of the assume-role session in “XhYmZs” format
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="policyARNs")
    def policy_arns(self) -> Optional[Sequence[str]]:
        """
        Optional set of IAM policy ARNs that further restrict the assume-role session
        """
        return pulumi.get(self, "policy_arns")


@pulumi.output_type
class AzureOIDCConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "subscriptionId":
            suggest = "subscription_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureOIDCConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureOIDCConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureOIDCConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 subscription_id: str,
                 tenant_id: str):
        """
        :param str client_id: The client ID of the federated workload identity.
        :param str subscription_id: The subscription ID of the federated workload identity.
        :param str tenant_id: The tenant ID of the federated workload identity.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "subscription_id", subscription_id)
        pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        The client ID of the federated workload identity.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> str:
        """
        The subscription ID of the federated workload identity.
        """
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant ID of the federated workload identity.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class DeploymentSettingsExecutorContext(dict):
    """
    The executor context defines information about the executor where the deployment is executed. If unspecified, the default 'pulumi/pulumi' image is used.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executorImage":
            suggest = "executor_image"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentSettingsExecutorContext. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentSettingsExecutorContext.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentSettingsExecutorContext.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 executor_image: str):
        """
        The executor context defines information about the executor where the deployment is executed. If unspecified, the default 'pulumi/pulumi' image is used.
        :param str executor_image: Allows overriding the default executor image with a custom image. E.g. 'pulumi/pulumi-nodejs:latest'
        """
        pulumi.set(__self__, "executor_image", executor_image)

    @property
    @pulumi.getter(name="executorImage")
    def executor_image(self) -> str:
        """
        Allows overriding the default executor image with a custom image. E.g. 'pulumi/pulumi-nodejs:latest'
        """
        return pulumi.get(self, "executor_image")


@pulumi.output_type
class DeploymentSettingsGitAuthBasicAuth(dict):
    """
    Git source settings for a deployment.
    """
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        Git source settings for a deployment.
        :param str password: Password for git basic authentication.
        :param str username: User name for git basic authentication.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        Password for git basic authentication.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        User name for git basic authentication.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class DeploymentSettingsGitAuthSSHAuth(dict):
    """
    Git source settings for a deployment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sshPrivateKey":
            suggest = "ssh_private_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentSettingsGitAuthSSHAuth. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentSettingsGitAuthSSHAuth.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentSettingsGitAuthSSHAuth.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ssh_private_key: str,
                 password: Optional[str] = None):
        """
        Git source settings for a deployment.
        :param str ssh_private_key: SSH private key.
        :param str password: Optional password for SSH authentication.
        """
        pulumi.set(__self__, "ssh_private_key", ssh_private_key)
        if password is not None:
            pulumi.set(__self__, "password", password)

    @property
    @pulumi.getter(name="sshPrivateKey")
    def ssh_private_key(self) -> str:
        """
        SSH private key.
        """
        return pulumi.get(self, "ssh_private_key")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Optional password for SSH authentication.
        """
        return pulumi.get(self, "password")


@pulumi.output_type
class DeploymentSettingsGitSource(dict):
    """
    Git source settings for a deployment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gitAuth":
            suggest = "git_auth"
        elif key == "repoDir":
            suggest = "repo_dir"
        elif key == "repoUrl":
            suggest = "repo_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentSettingsGitSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentSettingsGitSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentSettingsGitSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 commit: Optional[str] = None,
                 git_auth: Optional['outputs.DeploymentSettingsGitSourceGitAuth'] = None,
                 repo_dir: Optional[str] = None,
                 repo_url: Optional[str] = None):
        """
        Git source settings for a deployment.
        :param str branch: The branch to deploy. One of either `branch` or `commit` must be specified.
        :param str commit: The commit to deploy. One of either `branch` or `commit` must be specified.
        :param 'DeploymentSettingsGitSourceGitAuth' git_auth: Git authentication configuration for this deployment. Should not be specified if there are `gitHub` settings for this deployment.
        :param str repo_dir: The directory within the repository where the Pulumi.yaml is located.
        :param str repo_url: The repository URL to use for git settings. Should not be specified if there are `gitHub` settings for this deployment.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if commit is not None:
            pulumi.set(__self__, "commit", commit)
        if git_auth is not None:
            pulumi.set(__self__, "git_auth", git_auth)
        if repo_dir is not None:
            pulumi.set(__self__, "repo_dir", repo_dir)
        if repo_url is not None:
            pulumi.set(__self__, "repo_url", repo_url)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The branch to deploy. One of either `branch` or `commit` must be specified.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter
    def commit(self) -> Optional[str]:
        """
        The commit to deploy. One of either `branch` or `commit` must be specified.
        """
        return pulumi.get(self, "commit")

    @property
    @pulumi.getter(name="gitAuth")
    def git_auth(self) -> Optional['outputs.DeploymentSettingsGitSourceGitAuth']:
        """
        Git authentication configuration for this deployment. Should not be specified if there are `gitHub` settings for this deployment.
        """
        return pulumi.get(self, "git_auth")

    @property
    @pulumi.getter(name="repoDir")
    def repo_dir(self) -> Optional[str]:
        """
        The directory within the repository where the Pulumi.yaml is located.
        """
        return pulumi.get(self, "repo_dir")

    @property
    @pulumi.getter(name="repoUrl")
    def repo_url(self) -> Optional[str]:
        """
        The repository URL to use for git settings. Should not be specified if there are `gitHub` settings for this deployment.
        """
        return pulumi.get(self, "repo_url")


@pulumi.output_type
class DeploymentSettingsGitSourceGitAuth(dict):
    """
    Git source settings for a deployment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "basicAuth":
            suggest = "basic_auth"
        elif key == "sshAuth":
            suggest = "ssh_auth"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentSettingsGitSourceGitAuth. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentSettingsGitSourceGitAuth.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentSettingsGitSourceGitAuth.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 basic_auth: Optional['outputs.DeploymentSettingsGitAuthBasicAuth'] = None,
                 ssh_auth: Optional['outputs.DeploymentSettingsGitAuthSSHAuth'] = None):
        """
        Git source settings for a deployment.
        :param 'DeploymentSettingsGitAuthBasicAuth' basic_auth: Basic auth for git authentication. Only one of `personalAccessToken`, `sshAuth`, or `basicAuth` must be defined.
        :param 'DeploymentSettingsGitAuthSSHAuth' ssh_auth: SSH auth for git authentication. Only one of `personalAccessToken`, `sshAuth`, or `basicAuth` must be defined.
        """
        if basic_auth is not None:
            pulumi.set(__self__, "basic_auth", basic_auth)
        if ssh_auth is not None:
            pulumi.set(__self__, "ssh_auth", ssh_auth)

    @property
    @pulumi.getter(name="basicAuth")
    def basic_auth(self) -> Optional['outputs.DeploymentSettingsGitAuthBasicAuth']:
        """
        Basic auth for git authentication. Only one of `personalAccessToken`, `sshAuth`, or `basicAuth` must be defined.
        """
        return pulumi.get(self, "basic_auth")

    @property
    @pulumi.getter(name="sshAuth")
    def ssh_auth(self) -> Optional['outputs.DeploymentSettingsGitAuthSSHAuth']:
        """
        SSH auth for git authentication. Only one of `personalAccessToken`, `sshAuth`, or `basicAuth` must be defined.
        """
        return pulumi.get(self, "ssh_auth")


@pulumi.output_type
class DeploymentSettingsGithub(dict):
    """
    GitHub settings for the deployment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deployCommits":
            suggest = "deploy_commits"
        elif key == "previewPullRequests":
            suggest = "preview_pull_requests"
        elif key == "pullRequestTemplate":
            suggest = "pull_request_template"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentSettingsGithub. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentSettingsGithub.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentSettingsGithub.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 deploy_commits: Optional[bool] = None,
                 paths: Optional[Sequence[str]] = None,
                 preview_pull_requests: Optional[bool] = None,
                 pull_request_template: Optional[bool] = None,
                 repository: Optional[str] = None):
        """
        GitHub settings for the deployment.
        :param bool deploy_commits: Trigger a deployment running `pulumi up` on commit.
        :param Sequence[str] paths: The paths within the repo that deployments should be filtered to.
        :param bool preview_pull_requests: Trigger a deployment running `pulumi preview` when a PR is opened.
        :param bool pull_request_template: Use this stack as a template for pull request review stacks.
        :param str repository: The GitHub repository in the format org/repo.
        """
        if deploy_commits is None:
            deploy_commits = True
        if deploy_commits is not None:
            pulumi.set(__self__, "deploy_commits", deploy_commits)
        if paths is not None:
            pulumi.set(__self__, "paths", paths)
        if preview_pull_requests is None:
            preview_pull_requests = True
        if preview_pull_requests is not None:
            pulumi.set(__self__, "preview_pull_requests", preview_pull_requests)
        if pull_request_template is None:
            pull_request_template = False
        if pull_request_template is not None:
            pulumi.set(__self__, "pull_request_template", pull_request_template)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)

    @property
    @pulumi.getter(name="deployCommits")
    def deploy_commits(self) -> Optional[bool]:
        """
        Trigger a deployment running `pulumi up` on commit.
        """
        return pulumi.get(self, "deploy_commits")

    @property
    @pulumi.getter
    def paths(self) -> Optional[Sequence[str]]:
        """
        The paths within the repo that deployments should be filtered to.
        """
        return pulumi.get(self, "paths")

    @property
    @pulumi.getter(name="previewPullRequests")
    def preview_pull_requests(self) -> Optional[bool]:
        """
        Trigger a deployment running `pulumi preview` when a PR is opened.
        """
        return pulumi.get(self, "preview_pull_requests")

    @property
    @pulumi.getter(name="pullRequestTemplate")
    def pull_request_template(self) -> Optional[bool]:
        """
        Use this stack as a template for pull request review stacks.
        """
        return pulumi.get(self, "pull_request_template")

    @property
    @pulumi.getter
    def repository(self) -> Optional[str]:
        """
        The GitHub repository in the format org/repo.
        """
        return pulumi.get(self, "repository")


@pulumi.output_type
class DeploymentSettingsOperationContext(dict):
    """
    Settings related to the Pulumi operation environment during the deployment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "environmentVariables":
            suggest = "environment_variables"
        elif key == "preRunCommands":
            suggest = "pre_run_commands"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentSettingsOperationContext. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentSettingsOperationContext.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentSettingsOperationContext.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 environment_variables: Optional[Mapping[str, str]] = None,
                 oidc: Optional['outputs.OperationContextOIDC'] = None,
                 options: Optional['outputs.OperationContextOptions'] = None,
                 pre_run_commands: Optional[Sequence[str]] = None):
        """
        Settings related to the Pulumi operation environment during the deployment.
        :param Mapping[str, str] environment_variables: Environment variables to set for the deployment.
        :param 'OperationContextOIDC' oidc: OIDC configuration to use during the deployment.
        :param 'OperationContextOptions' options: Options to override default behavior during the deployment.
        :param Sequence[str] pre_run_commands: Shell commands to run before the Pulumi operation executes.
        """
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if oidc is not None:
            pulumi.set(__self__, "oidc", oidc)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if pre_run_commands is not None:
            pulumi.set(__self__, "pre_run_commands", pre_run_commands)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[Mapping[str, str]]:
        """
        Environment variables to set for the deployment.
        """
        return pulumi.get(self, "environment_variables")

    @property
    @pulumi.getter
    def oidc(self) -> Optional['outputs.OperationContextOIDC']:
        """
        OIDC configuration to use during the deployment.
        """
        return pulumi.get(self, "oidc")

    @property
    @pulumi.getter
    def options(self) -> Optional['outputs.OperationContextOptions']:
        """
        Options to override default behavior during the deployment.
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter(name="preRunCommands")
    def pre_run_commands(self) -> Optional[Sequence[str]]:
        """
        Shell commands to run before the Pulumi operation executes.
        """
        return pulumi.get(self, "pre_run_commands")


@pulumi.output_type
class DeploymentSettingsSourceContext(dict):
    """
    Settings related to the source of the deployment.
    """
    def __init__(__self__, *,
                 git: Optional['outputs.DeploymentSettingsGitSource'] = None):
        """
        Settings related to the source of the deployment.
        :param 'DeploymentSettingsGitSource' git: Git source settings for a deployment.
        """
        if git is not None:
            pulumi.set(__self__, "git", git)

    @property
    @pulumi.getter
    def git(self) -> Optional['outputs.DeploymentSettingsGitSource']:
        """
        Git source settings for a deployment.
        """
        return pulumi.get(self, "git")


@pulumi.output_type
class GCPOIDCConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectId":
            suggest = "project_id"
        elif key == "providerId":
            suggest = "provider_id"
        elif key == "serviceAccount":
            suggest = "service_account"
        elif key == "workloadPoolId":
            suggest = "workload_pool_id"
        elif key == "tokenLifetime":
            suggest = "token_lifetime"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GCPOIDCConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GCPOIDCConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GCPOIDCConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 project_id: str,
                 provider_id: str,
                 service_account: str,
                 workload_pool_id: str,
                 region: Optional[str] = None,
                 token_lifetime: Optional[str] = None):
        """
        :param str project_id: The numerical ID of the GCP project.
        :param str provider_id: The ID of the identity provider associated with the workload pool.
        :param str service_account: The email address of the service account to use.
        :param str workload_pool_id: The ID of the workload pool to use.
        :param str region: The region of the GCP project.
        :param str token_lifetime: The lifetime of the temporary credentials in “XhYmZs” format.
        """
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "provider_id", provider_id)
        pulumi.set(__self__, "service_account", service_account)
        pulumi.set(__self__, "workload_pool_id", workload_pool_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if token_lifetime is not None:
            pulumi.set(__self__, "token_lifetime", token_lifetime)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The numerical ID of the GCP project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="providerId")
    def provider_id(self) -> str:
        """
        The ID of the identity provider associated with the workload pool.
        """
        return pulumi.get(self, "provider_id")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> str:
        """
        The email address of the service account to use.
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter(name="workloadPoolId")
    def workload_pool_id(self) -> str:
        """
        The ID of the workload pool to use.
        """
        return pulumi.get(self, "workload_pool_id")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        The region of the GCP project.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="tokenLifetime")
    def token_lifetime(self) -> Optional[str]:
        """
        The lifetime of the temporary credentials in “XhYmZs” format.
        """
        return pulumi.get(self, "token_lifetime")


@pulumi.output_type
class OperationContextOIDC(dict):
    def __init__(__self__, *,
                 aws: Optional['outputs.AWSOIDCConfiguration'] = None,
                 azure: Optional['outputs.AzureOIDCConfiguration'] = None,
                 gcp: Optional['outputs.GCPOIDCConfiguration'] = None):
        """
        :param 'AWSOIDCConfiguration' aws: AWS-specific OIDC configuration.
        :param 'AzureOIDCConfiguration' azure: Azure-specific OIDC configuration.
        :param 'GCPOIDCConfiguration' gcp: GCP-specific OIDC configuration.
        """
        if aws is not None:
            pulumi.set(__self__, "aws", aws)
        if azure is not None:
            pulumi.set(__self__, "azure", azure)
        if gcp is not None:
            pulumi.set(__self__, "gcp", gcp)

    @property
    @pulumi.getter
    def aws(self) -> Optional['outputs.AWSOIDCConfiguration']:
        """
        AWS-specific OIDC configuration.
        """
        return pulumi.get(self, "aws")

    @property
    @pulumi.getter
    def azure(self) -> Optional['outputs.AzureOIDCConfiguration']:
        """
        Azure-specific OIDC configuration.
        """
        return pulumi.get(self, "azure")

    @property
    @pulumi.getter
    def gcp(self) -> Optional['outputs.GCPOIDCConfiguration']:
        """
        GCP-specific OIDC configuration.
        """
        return pulumi.get(self, "gcp")


@pulumi.output_type
class OperationContextOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deleteAfterDestroy":
            suggest = "delete_after_destroy"
        elif key == "skipInstallDependencies":
            suggest = "skip_install_dependencies"
        elif key == "skipIntermediateDeployments":
            suggest = "skip_intermediate_deployments"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OperationContextOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OperationContextOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OperationContextOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delete_after_destroy: Optional[bool] = None,
                 shell: Optional[str] = None,
                 skip_install_dependencies: Optional[bool] = None,
                 skip_intermediate_deployments: Optional[bool] = None):
        """
        :param bool delete_after_destroy: Whether the stack should be deleted after it is destroyed.
        :param str shell: The shell to use to run commands during the deployment. Defaults to 'bash'.
        :param bool skip_install_dependencies: Skip the default dependency installation step - use this to customize the dependency installation (e.g. if using yarn or poetry)
        :param bool skip_intermediate_deployments: Skip intermediate deployments (Consolidate multiple deployments of the same type into one deployment)
        """
        if delete_after_destroy is not None:
            pulumi.set(__self__, "delete_after_destroy", delete_after_destroy)
        if shell is not None:
            pulumi.set(__self__, "shell", shell)
        if skip_install_dependencies is not None:
            pulumi.set(__self__, "skip_install_dependencies", skip_install_dependencies)
        if skip_intermediate_deployments is not None:
            pulumi.set(__self__, "skip_intermediate_deployments", skip_intermediate_deployments)

    @property
    @pulumi.getter(name="deleteAfterDestroy")
    def delete_after_destroy(self) -> Optional[bool]:
        """
        Whether the stack should be deleted after it is destroyed.
        """
        return pulumi.get(self, "delete_after_destroy")

    @property
    @pulumi.getter
    def shell(self) -> Optional[str]:
        """
        The shell to use to run commands during the deployment. Defaults to 'bash'.
        """
        return pulumi.get(self, "shell")

    @property
    @pulumi.getter(name="skipInstallDependencies")
    def skip_install_dependencies(self) -> Optional[bool]:
        """
        Skip the default dependency installation step - use this to customize the dependency installation (e.g. if using yarn or poetry)
        """
        return pulumi.get(self, "skip_install_dependencies")

    @property
    @pulumi.getter(name="skipIntermediateDeployments")
    def skip_intermediate_deployments(self) -> Optional[bool]:
        """
        Skip intermediate deployments (Consolidate multiple deployments of the same type into one deployment)
        """
        return pulumi.get(self, "skip_intermediate_deployments")


@pulumi.output_type
class TemplateSourceDestination(dict):
    def __init__(__self__, *,
                 url: Optional[str] = None):
        """
        :param str url: Destination URL that gets filled in on new project creation.
        """
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        Destination URL that gets filled in on new project creation.
        """
        return pulumi.get(self, "url")


