# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['StackArgs', 'Stack']

@pulumi.input_type
class StackArgs:
    def __init__(__self__, *,
                 organization_name: pulumi.Input[str],
                 project_name: pulumi.Input[str],
                 stack_name: pulumi.Input[str],
                 force_destroy: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a Stack resource.
        :param pulumi.Input[str] organization_name: The name of the organization.
        :param pulumi.Input[str] project_name: The name of the project.
        :param pulumi.Input[str] stack_name: The name of the stack.
        :param pulumi.Input[bool] force_destroy: Optional. Flag indicating whether to delete the stack even if it still contains resources.
        """
        pulumi.set(__self__, "organization_name", organization_name)
        pulumi.set(__self__, "project_name", project_name)
        pulumi.set(__self__, "stack_name", stack_name)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)

    @property
    @pulumi.getter(name="organizationName")
    def organization_name(self) -> pulumi.Input[str]:
        """
        The name of the organization.
        """
        return pulumi.get(self, "organization_name")

    @organization_name.setter
    def organization_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "organization_name", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Input[str]:
        """
        The name of the project.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_name", value)

    @property
    @pulumi.getter(name="stackName")
    def stack_name(self) -> pulumi.Input[str]:
        """
        The name of the stack.
        """
        return pulumi.get(self, "stack_name")

    @stack_name.setter
    def stack_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "stack_name", value)

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Flag indicating whether to delete the stack even if it still contains resources.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_destroy", value)


class Stack(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 force_destroy: Optional[pulumi.Input[bool]] = None,
                 organization_name: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 stack_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        A stack is a collection of resources that share a common lifecycle. Stacks are uniquely identified by their name and the project they belong to.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] force_destroy: Optional. Flag indicating whether to delete the stack even if it still contains resources.
        :param pulumi.Input[str] organization_name: The name of the organization.
        :param pulumi.Input[str] project_name: The name of the project.
        :param pulumi.Input[str] stack_name: The name of the stack.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StackArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A stack is a collection of resources that share a common lifecycle. Stacks are uniquely identified by their name and the project they belong to.

        :param str resource_name: The name of the resource.
        :param StackArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StackArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 force_destroy: Optional[pulumi.Input[bool]] = None,
                 organization_name: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 stack_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StackArgs.__new__(StackArgs)

            __props__.__dict__["force_destroy"] = force_destroy
            if organization_name is None and not opts.urn:
                raise TypeError("Missing required property 'organization_name'")
            __props__.__dict__["organization_name"] = organization_name
            if project_name is None and not opts.urn:
                raise TypeError("Missing required property 'project_name'")
            __props__.__dict__["project_name"] = project_name
            if stack_name is None and not opts.urn:
                raise TypeError("Missing required property 'stack_name'")
            __props__.__dict__["stack_name"] = stack_name
        super(Stack, __self__).__init__(
            'pulumiservice:index:Stack',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Stack':
        """
        Get an existing Stack resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = StackArgs.__new__(StackArgs)

        __props__.__dict__["force_destroy"] = None
        __props__.__dict__["organization_name"] = None
        __props__.__dict__["project_name"] = None
        __props__.__dict__["stack_name"] = None
        return Stack(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> pulumi.Output[Optional[bool]]:
        """
        Optional. Flag indicating whether to delete the stack even if it still contains resources.
        """
        return pulumi.get(self, "force_destroy")

    @property
    @pulumi.getter(name="organizationName")
    def organization_name(self) -> pulumi.Output[str]:
        """
        The name of the organization.
        """
        return pulumi.get(self, "organization_name")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Output[str]:
        """
        The name of the project.
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter(name="stackName")
    def stack_name(self) -> pulumi.Output[str]:
        """
        The name of the stack.
        """
        return pulumi.get(self, "stack_name")

