/*
 * Decompiled with CFR 0.152.
 */
package io.ray.serve.router;

import io.ray.api.BaseActorHandle;
import io.ray.api.ObjectRef;
import io.ray.runtime.metric.Count;
import io.ray.runtime.metric.Gauge;
import io.ray.runtime.metric.Metrics;
import io.ray.serve.deployment.DeploymentId;
import io.ray.serve.generated.RequestMetadata;
import io.ray.serve.metrics.RayServeMetrics;
import io.ray.serve.poll.KeyListener;
import io.ray.serve.poll.KeyType;
import io.ray.serve.poll.LongPollClient;
import io.ray.serve.poll.LongPollNamespace;
import io.ray.serve.router.Query;
import io.ray.serve.router.ReplicaSet;
import io.ray.shaded.com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class Router {
    private ReplicaSet replicaSet;
    private LongPollClient longPollClient;
    private Count numRouterRequests;
    private AtomicInteger numQueuedQueries = new AtomicInteger();
    private Gauge numQueuedQueriesGauge;

    public Router(BaseActorHandle controllerHandle, DeploymentId deploymentId) {
        this.replicaSet = new ReplicaSet(deploymentId.getName());
        RayServeMetrics.execute(() -> {
            this.numRouterRequests = (Count)((Metrics.CountBuilder)((Metrics.CountBuilder)((Metrics.CountBuilder)((Metrics.CountBuilder)Metrics.count().name(RayServeMetrics.SERVE_NUM_ROUTER_REQUESTS.getName())).description(RayServeMetrics.SERVE_NUM_ROUTER_REQUESTS.getDescription())).unit("")).tags(ImmutableMap.of("deployment", deploymentId.getName(), "application", deploymentId.getApp()))).register();
        });
        RayServeMetrics.execute(() -> {
            this.numQueuedQueriesGauge = (Gauge)((Metrics.GaugeBuilder)((Metrics.GaugeBuilder)((Metrics.GaugeBuilder)((Metrics.GaugeBuilder)Metrics.gauge().name(RayServeMetrics.SERVE_DEPLOYMENT_QUEUED_QUERIES.getName())).description(RayServeMetrics.SERVE_DEPLOYMENT_QUEUED_QUERIES.getDescription())).unit("")).tags(ImmutableMap.of("deployment", deploymentId.getName(), "application", deploymentId.getApp()))).register();
        });
        HashMap<KeyType, KeyListener> keyListeners = new HashMap<KeyType, KeyListener>();
        keyListeners.put(new KeyType(LongPollNamespace.RUNNING_REPLICAS, deploymentId.getName()), workerReplicas -> this.replicaSet.updateWorkerReplicas(workerReplicas));
        this.longPollClient = new LongPollClient(controllerHandle, keyListeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectRef<Object> assignRequest(RequestMetadata requestMetadata, Object[] requestArgs) {
        RayServeMetrics.execute(() -> this.numRouterRequests.inc(1.0));
        this.numQueuedQueries.incrementAndGet();
        RayServeMetrics.execute(() -> this.numQueuedQueriesGauge.update(this.numQueuedQueries.get()));
        try {
            ObjectRef<Object> objectRef = this.replicaSet.assignReplica(new Query(requestMetadata, requestArgs));
            return objectRef;
        }
        finally {
            this.numQueuedQueries.decrementAndGet();
            RayServeMetrics.execute(() -> this.numQueuedQueriesGauge.update(this.numQueuedQueries.get()));
        }
    }

    public ReplicaSet getReplicaSet() {
        return this.replicaSet;
    }

    public LongPollClient getLongPollClient() {
        return this.longPollClient;
    }
}

