"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DenoVersion = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// https://semver.org/#is-there-a-suggested-regular-expression-regex-to-check-a-semver-string
const regex = /^(0|[1-9]\d*)\.(0|[1-9]\d*)\.(0|[1-9]\d*)(?:-((?:0|[1-9]\d*|\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\.(?:0|[1-9]\d*|\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\+([0-9a-zA-Z-]+(?:\.[0-9a-zA-Z-]+)*))?$/g;
class DenoVersion {
    constructor(version) {
        this.version = version;
    }
    /**
     * Specify a custom version.
     * Use this if the version you need is not available in one of the predefined versions.
     *
     * @param version The semantic version number without prefix 'v'.
     */
    static of(version) {
        if (!regex.test(version)) {
            throw new Error(`'${version}' is not a valid semantic version`);
        }
        return new DenoVersion(version);
    }
}
exports.DenoVersion = DenoVersion;
_a = JSII_RTTI_SYMBOL_1;
DenoVersion[_a] = { fqn: "@pepperize/cdk-lambda-deno.DenoVersion", version: "0.0.3" };
/**
 * 1.23.3
 */
DenoVersion.V1_23_3 = new DenoVersion("1.23.3");
//# sourceMappingURL=data:application/json;base64,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