"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from mollie import models, utils
from mollie._hooks import HookContext
from mollie.types import OptionalNullable, UNSET
from mollie.utils import get_security_from_env
from typing import Any, Mapping, Optional, Union


class Methods(BaseSDK):
    def list(
        self,
        *,
        sequence_type: Optional[str] = None,
        locale: Optional[str] = None,
        amount: Optional[
            Union[models.QueryParamAmount, models.QueryParamAmountTypedDict]
        ] = None,
        resource: Optional[str] = None,
        billing_country: Optional[str] = None,
        include_wallets: Optional[str] = None,
        order_line_categories: Optional[str] = None,
        profile_id: Optional[str] = None,
        include: OptionalNullable[str] = UNSET,
        testmode: OptionalNullable[bool] = False,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ListMethodsResponseBody:
        r"""List payment methods

        Retrieve all enabled payment methods. The results of this endpoint are **not** paginated — unlike most other list endpoints in our API.

        For test mode, all pending and enabled payment methods are returned. If no payment methods are requested yet, the most popular payment methods are returned in the test mode. For live mode, only fully enabled payment methods are returned.

        Payment methods can be requested and enabled via the Mollie Dashboard, or via the [Enable payment method endpoint](enable-method) of the Profiles API.

        The list can optionally be filtered using a number of parameters described below.

        By default, only payment methods for the Euro currency are returned. If you wish to retrieve payment methods which exclusively support other currencies (e.g. Twint), you need to use the `amount` parameters.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **payments.read**](/reference/authentication)

        :param sequence_type: Set this parameter to `first` to only return the enabled methods that can be used for the first payment of a recurring sequence.  Set it to `recurring` to only return enabled methods that can be used for recurring payments or subscriptions.  Possible values: `oneoff` `first` `recurring` (default: `oneoff`)
        :param locale: Passing a locale will sort the payment methods in the preferred order for the country, and translate the payment method names in the corresponding language.  Possible values: `en_US` `en_GB` `nl_NL` `nl_BE` `de_DE` `de_AT` `de_CH` `fr_FR` `fr_BE` `es_ES` `ca_ES` `pt_PT` `it_IT` `nb_NO` `sv_SE` `fi_FI` `da_DK` `is_IS` `hu_HU` `pl_PL` `lv_LV` `lt_LT`
        :param amount: If supplied, only payment methods that support the amount and currency are returned.  Example: `/v2/methods?amount[value]=100.00&amount[currency]=USD`
        :param resource: Indicate if you will use the result for the [Create order](create-order) or the [Create payment](create-payment) endpoint.  When passing the value `orders`, the result will include payment methods that are only available for payments created via the Orders API.  Possible values: `payments` `orders` (default: `payments`)
        :param billing_country: The country taken from your customer's billing address in ISO 3166-1 alpha-2 format. This parameter can be used to check whether your customer is eligible for certain payment methods, for example for Klarna.  Example: `/v2/methods?resource=orders&billingCountry=DE`
        :param include_wallets: A comma-separated list of the wallets you support in your checkout. Wallets often require wallet specific code to check if they are available on the shoppers device, hence the need to indicate your support.  Possible values: `applepay`
        :param order_line_categories: A comma-separated list of the order line categories you support in your checkout. The available categories can be found in the [Create order endpoint](create-order) documentation.  Example: `/v2/methods?resource=orders&orderLineCategories=eco,meal`
        :param profile_id: The identifier referring to the [profile](get-profile) you wish to retrieve the payment methods for.  Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted. For organization-level credentials such as OAuth access tokens however, the `profileId` parameter is required.
        :param include: This endpoint allows you to include additional information via the `include` query string parameter.  * `issuers`: Include issuer details such as which iDEAL or gift card issuers are available. * `pricing`: **⚠️ Deprecated: for up-to-date pricing data, use [List all methods](list-all-methods).⚠️** <br /> Include pricing information for each payment method, based on a snapshot of data last updated in November 2023.
        :param testmode: Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.  Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ListMethodsRequest(
            sequence_type=sequence_type,
            locale=locale,
            amount=utils.get_pydantic_model(amount, Optional[models.QueryParamAmount]),
            resource=resource,
            billing_country=billing_country,
            include_wallets=include_wallets,
            order_line_categories=order_line_categories,
            profile_id=profile_id,
            include=include,
            testmode=testmode,
        )

        req = self._build_request(
            method="GET",
            path="/methods",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="list-methods",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/hal+json"):
            return utils.unmarshal_json(http_res.text, models.ListMethodsResponseBody)
        if utils.match_response(http_res, "400", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.ListMethodsMethodsResponseBodyData
            )
            raise models.ListMethodsMethodsResponseBody(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def list_async(
        self,
        *,
        sequence_type: Optional[str] = None,
        locale: Optional[str] = None,
        amount: Optional[
            Union[models.QueryParamAmount, models.QueryParamAmountTypedDict]
        ] = None,
        resource: Optional[str] = None,
        billing_country: Optional[str] = None,
        include_wallets: Optional[str] = None,
        order_line_categories: Optional[str] = None,
        profile_id: Optional[str] = None,
        include: OptionalNullable[str] = UNSET,
        testmode: OptionalNullable[bool] = False,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ListMethodsResponseBody:
        r"""List payment methods

        Retrieve all enabled payment methods. The results of this endpoint are **not** paginated — unlike most other list endpoints in our API.

        For test mode, all pending and enabled payment methods are returned. If no payment methods are requested yet, the most popular payment methods are returned in the test mode. For live mode, only fully enabled payment methods are returned.

        Payment methods can be requested and enabled via the Mollie Dashboard, or via the [Enable payment method endpoint](enable-method) of the Profiles API.

        The list can optionally be filtered using a number of parameters described below.

        By default, only payment methods for the Euro currency are returned. If you wish to retrieve payment methods which exclusively support other currencies (e.g. Twint), you need to use the `amount` parameters.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **payments.read**](/reference/authentication)

        :param sequence_type: Set this parameter to `first` to only return the enabled methods that can be used for the first payment of a recurring sequence.  Set it to `recurring` to only return enabled methods that can be used for recurring payments or subscriptions.  Possible values: `oneoff` `first` `recurring` (default: `oneoff`)
        :param locale: Passing a locale will sort the payment methods in the preferred order for the country, and translate the payment method names in the corresponding language.  Possible values: `en_US` `en_GB` `nl_NL` `nl_BE` `de_DE` `de_AT` `de_CH` `fr_FR` `fr_BE` `es_ES` `ca_ES` `pt_PT` `it_IT` `nb_NO` `sv_SE` `fi_FI` `da_DK` `is_IS` `hu_HU` `pl_PL` `lv_LV` `lt_LT`
        :param amount: If supplied, only payment methods that support the amount and currency are returned.  Example: `/v2/methods?amount[value]=100.00&amount[currency]=USD`
        :param resource: Indicate if you will use the result for the [Create order](create-order) or the [Create payment](create-payment) endpoint.  When passing the value `orders`, the result will include payment methods that are only available for payments created via the Orders API.  Possible values: `payments` `orders` (default: `payments`)
        :param billing_country: The country taken from your customer's billing address in ISO 3166-1 alpha-2 format. This parameter can be used to check whether your customer is eligible for certain payment methods, for example for Klarna.  Example: `/v2/methods?resource=orders&billingCountry=DE`
        :param include_wallets: A comma-separated list of the wallets you support in your checkout. Wallets often require wallet specific code to check if they are available on the shoppers device, hence the need to indicate your support.  Possible values: `applepay`
        :param order_line_categories: A comma-separated list of the order line categories you support in your checkout. The available categories can be found in the [Create order endpoint](create-order) documentation.  Example: `/v2/methods?resource=orders&orderLineCategories=eco,meal`
        :param profile_id: The identifier referring to the [profile](get-profile) you wish to retrieve the payment methods for.  Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted. For organization-level credentials such as OAuth access tokens however, the `profileId` parameter is required.
        :param include: This endpoint allows you to include additional information via the `include` query string parameter.  * `issuers`: Include issuer details such as which iDEAL or gift card issuers are available. * `pricing`: **⚠️ Deprecated: for up-to-date pricing data, use [List all methods](list-all-methods).⚠️** <br /> Include pricing information for each payment method, based on a snapshot of data last updated in November 2023.
        :param testmode: Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.  Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ListMethodsRequest(
            sequence_type=sequence_type,
            locale=locale,
            amount=utils.get_pydantic_model(amount, Optional[models.QueryParamAmount]),
            resource=resource,
            billing_country=billing_country,
            include_wallets=include_wallets,
            order_line_categories=order_line_categories,
            profile_id=profile_id,
            include=include,
            testmode=testmode,
        )

        req = self._build_request_async(
            method="GET",
            path="/methods",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="list-methods",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/hal+json"):
            return utils.unmarshal_json(http_res.text, models.ListMethodsResponseBody)
        if utils.match_response(http_res, "400", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.ListMethodsMethodsResponseBodyData
            )
            raise models.ListMethodsMethodsResponseBody(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    def list_all(
        self,
        *,
        locale: Optional[str] = None,
        amount: Optional[
            Union[
                models.ListAllMethodsQueryParamAmount,
                models.ListAllMethodsQueryParamAmountTypedDict,
            ]
        ] = None,
        include: OptionalNullable[str] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ListAllMethodsResponseBody:
        r"""List all payment methods

        Retrieve all payment methods that Mollie offers, regardless of the eligibility of the organization for the specific method. The results of this endpoint are **not** paginated — unlike most other list endpoints in our API.

        The list can optionally be filtered using a number of parameters described below.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **payments.read**](/reference/authentication)

        :param locale: Passing a locale will sort the payment methods in the preferred order for the country, and translate the payment method names in the corresponding language.  Possible values: `en_US` `en_GB` `nl_NL` `nl_BE` `de_DE` `de_AT` `de_CH` `fr_FR` `fr_BE` `es_ES` `ca_ES` `pt_PT` `it_IT` `nb_NO` `sv_SE` `fi_FI` `da_DK` `is_IS` `hu_HU` `pl_PL` `lv_LV` `lt_LT`
        :param amount: If supplied, only payment methods that support the amount and currency are returned.  Example: `/v2/methods/all?amount[value]=100.00&amount[currency]=USD`
        :param include: This endpoint allows you to include additional information via the `include` query string parameter.  * `issuers`: Include issuer details such as which iDEAL or gift card issuers are available. * `pricing`: Include pricing for each payment method.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ListAllMethodsRequest(
            locale=locale,
            amount=utils.get_pydantic_model(
                amount, Optional[models.ListAllMethodsQueryParamAmount]
            ),
            include=include,
        )

        req = self._build_request(
            method="GET",
            path="/methods/all",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="list-all-methods",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/hal+json"):
            return utils.unmarshal_json(
                http_res.text, models.ListAllMethodsResponseBody
            )
        if utils.match_response(http_res, "400", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.ListAllMethodsMethodsResponseBodyData
            )
            raise models.ListAllMethodsMethodsResponseBody(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def list_all_async(
        self,
        *,
        locale: Optional[str] = None,
        amount: Optional[
            Union[
                models.ListAllMethodsQueryParamAmount,
                models.ListAllMethodsQueryParamAmountTypedDict,
            ]
        ] = None,
        include: OptionalNullable[str] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ListAllMethodsResponseBody:
        r"""List all payment methods

        Retrieve all payment methods that Mollie offers, regardless of the eligibility of the organization for the specific method. The results of this endpoint are **not** paginated — unlike most other list endpoints in our API.

        The list can optionally be filtered using a number of parameters described below.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **payments.read**](/reference/authentication)

        :param locale: Passing a locale will sort the payment methods in the preferred order for the country, and translate the payment method names in the corresponding language.  Possible values: `en_US` `en_GB` `nl_NL` `nl_BE` `de_DE` `de_AT` `de_CH` `fr_FR` `fr_BE` `es_ES` `ca_ES` `pt_PT` `it_IT` `nb_NO` `sv_SE` `fi_FI` `da_DK` `is_IS` `hu_HU` `pl_PL` `lv_LV` `lt_LT`
        :param amount: If supplied, only payment methods that support the amount and currency are returned.  Example: `/v2/methods/all?amount[value]=100.00&amount[currency]=USD`
        :param include: This endpoint allows you to include additional information via the `include` query string parameter.  * `issuers`: Include issuer details such as which iDEAL or gift card issuers are available. * `pricing`: Include pricing for each payment method.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ListAllMethodsRequest(
            locale=locale,
            amount=utils.get_pydantic_model(
                amount, Optional[models.ListAllMethodsQueryParamAmount]
            ),
            include=include,
        )

        req = self._build_request_async(
            method="GET",
            path="/methods/all",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="list-all-methods",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/hal+json"):
            return utils.unmarshal_json(
                http_res.text, models.ListAllMethodsResponseBody
            )
        if utils.match_response(http_res, "400", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.ListAllMethodsMethodsResponseBodyData
            )
            raise models.ListAllMethodsMethodsResponseBody(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    def get(
        self,
        *,
        id: str,
        locale: Optional[str] = None,
        currency: Optional[str] = None,
        profile_id: Optional[str] = None,
        include: OptionalNullable[str] = UNSET,
        testmode: OptionalNullable[bool] = False,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.GetMethodResponseBody:
        r"""Get payment method

        Retrieve a single payment method by its ID.

        If a method is not available on this profile, a `404 Not Found` response is returned. If the method is available but not enabled yet, a status `403 Forbidden` is returned. You can enable payments methods via the [Enable payment method endpoint](enable-method) of the Profiles API, or via the Mollie Dashboard.

        If you do not know the method's ID, you can use the [methods list endpoint](list-methods) to retrieve all payment methods that are available.

        Additionally, it is possible to check if wallet methods such as Apple Pay are enabled by passing the wallet ID (`applepay`) as the method ID.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **payments.read**](/reference/authentication)

        :param id: Provide the ID of the item you want to perform this operation on.
        :param locale: Passing a locale will translate the payment method name in the corresponding language.  Possible values: `en_US` `en_GB` `nl_NL` `nl_BE` `de_DE` `de_AT` `de_CH` `fr_FR` `fr_BE` `es_ES` `ca_ES` `pt_PT` `it_IT` `nb_NO` `sv_SE` `fi_FI` `da_DK` `is_IS` `hu_HU` `pl_PL` `lv_LV` `lt_LT`
        :param currency: If provided, the `minimumAmount` and `maximumAmount` will be converted to the given currency. An error is returned if the currency is not supported by the payment method.
        :param profile_id: The identifier referring to the [profile](get-profile) you wish to retrieve the payment method for.  Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted. For organization-level credentials such as OAuth access tokens however, the `profileId` parameter is required.
        :param include: This endpoint allows you to include additional information via the `include` query string parameter.  * `issuers`: Include issuer details such as which iDEAL or gift card issuers are available. * `pricing`: Include pricing for the payment method.
        :param testmode: Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.  Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetMethodRequest(
            id=id,
            locale=locale,
            currency=currency,
            profile_id=profile_id,
            include=include,
            testmode=testmode,
        )

        req = self._build_request(
            method="GET",
            path="/methods/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="get-method",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/hal+json"):
            return utils.unmarshal_json(http_res.text, models.GetMethodResponseBody)
        if utils.match_response(http_res, "400", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.GetMethodMethodsResponseBodyData
            )
            raise models.GetMethodMethodsResponseBody(data=response_data)
        if utils.match_response(http_res, "404", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.GetMethodMethodsResponseResponseBodyData
            )
            raise models.GetMethodMethodsResponseResponseBody(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def get_async(
        self,
        *,
        id: str,
        locale: Optional[str] = None,
        currency: Optional[str] = None,
        profile_id: Optional[str] = None,
        include: OptionalNullable[str] = UNSET,
        testmode: OptionalNullable[bool] = False,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.GetMethodResponseBody:
        r"""Get payment method

        Retrieve a single payment method by its ID.

        If a method is not available on this profile, a `404 Not Found` response is returned. If the method is available but not enabled yet, a status `403 Forbidden` is returned. You can enable payments methods via the [Enable payment method endpoint](enable-method) of the Profiles API, or via the Mollie Dashboard.

        If you do not know the method's ID, you can use the [methods list endpoint](list-methods) to retrieve all payment methods that are available.

        Additionally, it is possible to check if wallet methods such as Apple Pay are enabled by passing the wallet ID (`applepay`) as the method ID.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **payments.read**](/reference/authentication)

        :param id: Provide the ID of the item you want to perform this operation on.
        :param locale: Passing a locale will translate the payment method name in the corresponding language.  Possible values: `en_US` `en_GB` `nl_NL` `nl_BE` `de_DE` `de_AT` `de_CH` `fr_FR` `fr_BE` `es_ES` `ca_ES` `pt_PT` `it_IT` `nb_NO` `sv_SE` `fi_FI` `da_DK` `is_IS` `hu_HU` `pl_PL` `lv_LV` `lt_LT`
        :param currency: If provided, the `minimumAmount` and `maximumAmount` will be converted to the given currency. An error is returned if the currency is not supported by the payment method.
        :param profile_id: The identifier referring to the [profile](get-profile) you wish to retrieve the payment method for.  Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted. For organization-level credentials such as OAuth access tokens however, the `profileId` parameter is required.
        :param include: This endpoint allows you to include additional information via the `include` query string parameter.  * `issuers`: Include issuer details such as which iDEAL or gift card issuers are available. * `pricing`: Include pricing for the payment method.
        :param testmode: Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.  Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetMethodRequest(
            id=id,
            locale=locale,
            currency=currency,
            profile_id=profile_id,
            include=include,
            testmode=testmode,
        )

        req = self._build_request_async(
            method="GET",
            path="/methods/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="get-method",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/hal+json"):
            return utils.unmarshal_json(http_res.text, models.GetMethodResponseBody)
        if utils.match_response(http_res, "400", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.GetMethodMethodsResponseBodyData
            )
            raise models.GetMethodMethodsResponseBody(data=response_data)
        if utils.match_response(http_res, "404", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.GetMethodMethodsResponseResponseBodyData
            )
            raise models.GetMethodMethodsResponseResponseBody(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    def enable_method(
        self,
        *,
        profile_id: str,
        id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.EnableMethodResponseBody:
        r"""Enable payment method

        Enable a payment method on a specific profile.

        When using a profile-specific API credential, the alias `me` can be used instead of the profile ID to refer to the current profile.

        Some payment methods require extra steps in order to be activated. In cases where a step at the payment method provider needs to be completed first, the status will be set to `pending-external` and the response will contain a link to complete the activation at the provider.

        To enable voucher or gift card issuers, refer to the [Enable payment method issuer](enable-method-issuer) endpoint.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **profiles.write**](/reference/authentication)

        :param profile_id: Provide the ID of the related profile.
        :param id: Provide the ID of the item you want to perform this operation on.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.EnableMethodRequest(
            profile_id=profile_id,
            id=id,
        )

        req = self._build_request(
            method="POST",
            path="/profiles/{profileId}/methods/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="enable-method",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/hal+json"):
            return utils.unmarshal_json(http_res.text, models.EnableMethodResponseBody)
        if utils.match_response(http_res, "404", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.EnableMethodMethodsResponseBodyData
            )
            raise models.EnableMethodMethodsResponseBody(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def enable_method_async(
        self,
        *,
        profile_id: str,
        id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.EnableMethodResponseBody:
        r"""Enable payment method

        Enable a payment method on a specific profile.

        When using a profile-specific API credential, the alias `me` can be used instead of the profile ID to refer to the current profile.

        Some payment methods require extra steps in order to be activated. In cases where a step at the payment method provider needs to be completed first, the status will be set to `pending-external` and the response will contain a link to complete the activation at the provider.

        To enable voucher or gift card issuers, refer to the [Enable payment method issuer](enable-method-issuer) endpoint.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **profiles.write**](/reference/authentication)

        :param profile_id: Provide the ID of the related profile.
        :param id: Provide the ID of the item you want to perform this operation on.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.EnableMethodRequest(
            profile_id=profile_id,
            id=id,
        )

        req = self._build_request_async(
            method="POST",
            path="/profiles/{profileId}/methods/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="enable-method",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/hal+json"):
            return utils.unmarshal_json(http_res.text, models.EnableMethodResponseBody)
        if utils.match_response(http_res, "404", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.EnableMethodMethodsResponseBodyData
            )
            raise models.EnableMethodMethodsResponseBody(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    def disable_method(
        self,
        *,
        profile_id: str,
        id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Any:
        r"""Disable payment method

        Disable a payment method on a specific profile.

        When using a profile-specific API credential, the alias `me` can be used instead of the profile ID to refer to the current profile.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **profiles.write**](/reference/authentication)

        :param profile_id: Provide the ID of the related profile.
        :param id: Provide the ID of the item you want to perform this operation on.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.DisableMethodRequest(
            profile_id=profile_id,
            id=id,
        )

        req = self._build_request(
            method="DELETE",
            path="/profiles/{profileId}/methods/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="disable-method",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "204", "application/hal+json"):
            return utils.unmarshal_json(http_res.text, Any)
        if utils.match_response(http_res, "404", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.DisableMethodResponseBodyData
            )
            raise models.DisableMethodResponseBody(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def disable_method_async(
        self,
        *,
        profile_id: str,
        id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Any:
        r"""Disable payment method

        Disable a payment method on a specific profile.

        When using a profile-specific API credential, the alias `me` can be used instead of the profile ID to refer to the current profile.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **profiles.write**](/reference/authentication)

        :param profile_id: Provide the ID of the related profile.
        :param id: Provide the ID of the item you want to perform this operation on.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.DisableMethodRequest(
            profile_id=profile_id,
            id=id,
        )

        req = self._build_request_async(
            method="DELETE",
            path="/profiles/{profileId}/methods/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="disable-method",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "204", "application/hal+json"):
            return utils.unmarshal_json(http_res.text, Any)
        if utils.match_response(http_res, "404", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.DisableMethodResponseBodyData
            )
            raise models.DisableMethodResponseBody(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    def enable_method_issuer(
        self,
        *,
        profile_id: str,
        method_id: str,
        id: str,
        contract_id: OptionalNullable[str] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.EnableMethodIssuerResponseBody:
        r"""Enable payment method issuer

        Enable an issuer for a payment method on a specific profile.

        Currently only the payment methods `voucher` and `giftcard` are supported.

        When using a profile-specific API credential, the alias `me` can be used instead of the profile ID to refer to the current profile.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **profiles.write**](/reference/authentication)

        :param profile_id: Provide the ID of the related profile.
        :param method_id: Provide the ID of the related payment method.
        :param id: Provide the ID of the item you want to perform this operation on.
        :param contract_id: When enabling a voucher issuer, an inbetween party may be involved which you have a contract with. Provide the contract ID for the first time you enable an issuer via this contractor.  You can update the contract ID as long as it is not approved yet, by repeating the API call with a different contract ID.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.EnableMethodIssuerRequest(
            profile_id=profile_id,
            method_id=method_id,
            id=id,
            request_body=models.EnableMethodIssuerRequestBody(
                contract_id=contract_id,
            ),
        )

        req = self._build_request(
            method="POST",
            path="/profiles/{profileId}/methods/{methodId}/issuers/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                True,
                "json",
                Optional[models.EnableMethodIssuerRequestBody],
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="enable-method-issuer",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/hal+json"):
            return utils.unmarshal_json(
                http_res.text, models.EnableMethodIssuerResponseBody
            )
        if utils.match_response(http_res, "404", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.EnableMethodIssuerMethodsResponseBodyData
            )
            raise models.EnableMethodIssuerMethodsResponseBody(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def enable_method_issuer_async(
        self,
        *,
        profile_id: str,
        method_id: str,
        id: str,
        contract_id: OptionalNullable[str] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.EnableMethodIssuerResponseBody:
        r"""Enable payment method issuer

        Enable an issuer for a payment method on a specific profile.

        Currently only the payment methods `voucher` and `giftcard` are supported.

        When using a profile-specific API credential, the alias `me` can be used instead of the profile ID to refer to the current profile.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **profiles.write**](/reference/authentication)

        :param profile_id: Provide the ID of the related profile.
        :param method_id: Provide the ID of the related payment method.
        :param id: Provide the ID of the item you want to perform this operation on.
        :param contract_id: When enabling a voucher issuer, an inbetween party may be involved which you have a contract with. Provide the contract ID for the first time you enable an issuer via this contractor.  You can update the contract ID as long as it is not approved yet, by repeating the API call with a different contract ID.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.EnableMethodIssuerRequest(
            profile_id=profile_id,
            method_id=method_id,
            id=id,
            request_body=models.EnableMethodIssuerRequestBody(
                contract_id=contract_id,
            ),
        )

        req = self._build_request_async(
            method="POST",
            path="/profiles/{profileId}/methods/{methodId}/issuers/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                True,
                "json",
                Optional[models.EnableMethodIssuerRequestBody],
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="enable-method-issuer",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/hal+json"):
            return utils.unmarshal_json(
                http_res.text, models.EnableMethodIssuerResponseBody
            )
        if utils.match_response(http_res, "404", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.EnableMethodIssuerMethodsResponseBodyData
            )
            raise models.EnableMethodIssuerMethodsResponseBody(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    def disable_method_issuer(
        self,
        *,
        profile_id: str,
        method_id: str,
        id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Any:
        r"""Disable payment method issuer

        Disable an issuer for a payment method on a specific profile.

        Currently only the payment methods `voucher` and `giftcard` are supported.

        When using a profile-specific API credential, the alias `me` can be used instead of the profile ID to refer to the current profile.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **profiles.write**](/reference/authentication)

        :param profile_id: Provide the ID of the related profile.
        :param method_id: Provide the ID of the related payment method.
        :param id: Provide the ID of the item you want to perform this operation on.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.DisableMethodIssuerRequest(
            profile_id=profile_id,
            method_id=method_id,
            id=id,
        )

        req = self._build_request(
            method="DELETE",
            path="/profiles/{profileId}/methods/{methodId}/issuers/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="disable-method-issuer",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "204", "application/hal+json"):
            return utils.unmarshal_json(http_res.text, Any)
        if utils.match_response(http_res, "404", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.DisableMethodIssuerResponseBodyData
            )
            raise models.DisableMethodIssuerResponseBody(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def disable_method_issuer_async(
        self,
        *,
        profile_id: str,
        method_id: str,
        id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Any:
        r"""Disable payment method issuer

        Disable an issuer for a payment method on a specific profile.

        Currently only the payment methods `voucher` and `giftcard` are supported.

        When using a profile-specific API credential, the alias `me` can be used instead of the profile ID to refer to the current profile.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **profiles.write**](/reference/authentication)

        :param profile_id: Provide the ID of the related profile.
        :param method_id: Provide the ID of the related payment method.
        :param id: Provide the ID of the item you want to perform this operation on.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.DisableMethodIssuerRequest(
            profile_id=profile_id,
            method_id=method_id,
            id=id,
        )

        req = self._build_request_async(
            method="DELETE",
            path="/profiles/{profileId}/methods/{methodId}/issuers/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="disable-method-issuer",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "204", "application/hal+json"):
            return utils.unmarshal_json(http_res.text, Any)
        if utils.match_response(http_res, "404", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.DisableMethodIssuerResponseBodyData
            )
            raise models.DisableMethodIssuerResponseBody(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )
