"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie import utils
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, PathParamMetadata, RequestMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class CancelOrderLinesAmountTypedDict(TypedDict):
    r"""The amount that you want to cancel. In almost all cases, Mollie can determine the amount automatically.

    The amount is required only if you are *partially* canceling an order line which has a non-zero `discountAmount`.

    The amount you can cancel depends on various properties of the order line and the cancel order lines request. The maximum that can be canceled is `unit price x quantity to cancel`.

    The minimum amount depends on the discount applied to the line, the quantity already shipped or canceled, the amounts already shipped or canceled and the quantity you want to cancel.

    If you do not send an amount, Mollie will determine the amount automatically or respond with an error if the amount cannot be determined automatically.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CancelOrderLinesAmount(BaseModel):
    r"""The amount that you want to cancel. In almost all cases, Mollie can determine the amount automatically.

    The amount is required only if you are *partially* canceling an order line which has a non-zero `discountAmount`.

    The amount you can cancel depends on various properties of the order line and the cancel order lines request. The maximum that can be canceled is `unit price x quantity to cancel`.

    The minimum amount depends on the discount applied to the line, the quantity already shipped or canceled, the amounts already shipped or canceled and the quantity you want to cancel.

    If you do not send an amount, Mollie will determine the amount automatically or respond with an error if the amount cannot be determined automatically.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CancelOrderLinesLinesTypedDict(TypedDict):
    id: str
    r"""The ID of the order line. For example: `odl_dgtxyl`."""
    quantity: NotRequired[Nullable[int]]
    r"""The number of items that should be canceled for this order line. When this parameter is omitted, the whole order line will be canceled. When part of the line has been shipped, the remaining quantity will be canceled and the order line will be marked `completed`.

    Must be less than the number of items already shipped or canceled for this order line.
    """
    amount: NotRequired[Nullable[CancelOrderLinesAmountTypedDict]]
    r"""The amount that you want to cancel. In almost all cases, Mollie can determine the amount automatically.

    The amount is required only if you are *partially* canceling an order line which has a non-zero `discountAmount`.

    The amount you can cancel depends on various properties of the order line and the cancel order lines request. The maximum that can be canceled is `unit price x quantity to cancel`.

    The minimum amount depends on the discount applied to the line, the quantity already shipped or canceled, the amounts already shipped or canceled and the quantity you want to cancel.

    If you do not send an amount, Mollie will determine the amount automatically or respond with an error if the amount cannot be determined automatically.
    """


class CancelOrderLinesLines(BaseModel):
    id: str
    r"""The ID of the order line. For example: `odl_dgtxyl`."""

    quantity: OptionalNullable[int] = UNSET
    r"""The number of items that should be canceled for this order line. When this parameter is omitted, the whole order line will be canceled. When part of the line has been shipped, the remaining quantity will be canceled and the order line will be marked `completed`.

    Must be less than the number of items already shipped or canceled for this order line.
    """

    amount: OptionalNullable[CancelOrderLinesAmount] = UNSET
    r"""The amount that you want to cancel. In almost all cases, Mollie can determine the amount automatically.

    The amount is required only if you are *partially* canceling an order line which has a non-zero `discountAmount`.

    The amount you can cancel depends on various properties of the order line and the cancel order lines request. The maximum that can be canceled is `unit price x quantity to cancel`.

    The minimum amount depends on the discount applied to the line, the quantity already shipped or canceled, the amounts already shipped or canceled and the quantity you want to cancel.

    If you do not send an amount, Mollie will determine the amount automatically or respond with an error if the amount cannot be determined automatically.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["quantity", "amount"]
        nullable_fields = ["quantity", "amount"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CancelOrderLinesRequestBodyTypedDict(TypedDict):
    lines: List[CancelOrderLinesLinesTypedDict]
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting `testmode` to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class CancelOrderLinesRequestBody(BaseModel):
    lines: List[CancelOrderLinesLines]

    testmode: OptionalNullable[bool] = False
    r"""Most API credentials are specifically created for either live mode or test mode. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting `testmode` to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["testmode"]
        nullable_fields = ["testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CancelOrderLinesRequestTypedDict(TypedDict):
    order_id: str
    r"""Provide the ID of the related order."""
    request_body: NotRequired[CancelOrderLinesRequestBodyTypedDict]


class CancelOrderLinesRequest(BaseModel):
    order_id: Annotated[
        str,
        pydantic.Field(alias="orderId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related order."""

    request_body: Annotated[
        Optional[CancelOrderLinesRequestBody],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ] = None


class CancelOrderLinesOrdersDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class CancelOrderLinesOrdersDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class CancelOrderLinesOrdersLinksTypedDict(TypedDict):
    documentation: NotRequired[CancelOrderLinesOrdersDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class CancelOrderLinesOrdersLinks(BaseModel):
    documentation: Optional[CancelOrderLinesOrdersDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class CancelOrderLinesOrdersResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[
        Optional[CancelOrderLinesOrdersLinks], pydantic.Field(alias="_links")
    ] = None


class CancelOrderLinesOrdersResponseBody(Exception):
    r"""An error response object."""

    data: CancelOrderLinesOrdersResponseBodyData

    def __init__(self, data: CancelOrderLinesOrdersResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, CancelOrderLinesOrdersResponseBodyData)


class CancelOrderLinesDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class CancelOrderLinesDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class CancelOrderLinesLinksTypedDict(TypedDict):
    documentation: NotRequired[CancelOrderLinesDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class CancelOrderLinesLinks(BaseModel):
    documentation: Optional[CancelOrderLinesDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class CancelOrderLinesResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[
        Optional[CancelOrderLinesLinks], pydantic.Field(alias="_links")
    ] = None


class CancelOrderLinesResponseBody(Exception):
    r"""An error response object."""

    data: CancelOrderLinesResponseBodyData

    def __init__(self, data: CancelOrderLinesResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, CancelOrderLinesResponseBodyData)
