"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie import utils
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, PathParamMetadata, RequestMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class CreateShipmentAmountTypedDict(TypedDict):
    r"""The amount that you want to ship. In almost all cases, Mollie can determine the amount automatically.

    The amount is required only if you are *partially* fulfilling an order line which has a non-zero `discountAmount`.

    If you do not send an amount, Mollie will determine the amount automatically or respond with an error if the amount cannot be determined automatically.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateShipmentAmount(BaseModel):
    r"""The amount that you want to ship. In almost all cases, Mollie can determine the amount automatically.

    The amount is required only if you are *partially* fulfilling an order line which has a non-zero `discountAmount`.

    If you do not send an amount, Mollie will determine the amount automatically or respond with an error if the amount cannot be determined automatically.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateShipmentLinesTypedDict(TypedDict):
    id: NotRequired[str]
    r"""The ID of the order line. For example: `odl_dgtxyl`."""
    quantity: NotRequired[Nullable[int]]
    r"""The number of items that should be shipped for this order line. When this parameter is omitted, all remaining unshipped items of this order line will be considered 'shipped'."""
    amount: NotRequired[Nullable[CreateShipmentAmountTypedDict]]
    r"""The amount that you want to ship. In almost all cases, Mollie can determine the amount automatically.

    The amount is required only if you are *partially* fulfilling an order line which has a non-zero `discountAmount`.

    If you do not send an amount, Mollie will determine the amount automatically or respond with an error if the amount cannot be determined automatically.
    """


class CreateShipmentLines(BaseModel):
    id: Optional[str] = None
    r"""The ID of the order line. For example: `odl_dgtxyl`."""

    quantity: OptionalNullable[int] = UNSET
    r"""The number of items that should be shipped for this order line. When this parameter is omitted, all remaining unshipped items of this order line will be considered 'shipped'."""

    amount: OptionalNullable[CreateShipmentAmount] = UNSET
    r"""The amount that you want to ship. In almost all cases, Mollie can determine the amount automatically.

    The amount is required only if you are *partially* fulfilling an order line which has a non-zero `discountAmount`.

    If you do not send an amount, Mollie will determine the amount automatically or respond with an error if the amount cannot be determined automatically.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "quantity", "amount"]
        nullable_fields = ["quantity", "amount"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class TrackingTypedDict(TypedDict):
    r"""Shipment tracking details. Can be omitted if tracking details are not available or not applicable."""

    carrier: NotRequired[str]
    r"""The name of the postal carrier."""
    code: NotRequired[str]
    r"""The track-and-trace code for the shipment."""
    url: NotRequired[str]
    r"""The URL where your customer can track the shipment."""


class Tracking(BaseModel):
    r"""Shipment tracking details. Can be omitted if tracking details are not available or not applicable."""

    carrier: Optional[str] = None
    r"""The name of the postal carrier."""

    code: Optional[str] = None
    r"""The track-and-trace code for the shipment."""

    url: Optional[str] = None
    r"""The URL where your customer can track the shipment."""


class CreateShipmentRequestBodyTypedDict(TypedDict):
    lines: NotRequired[Nullable[List[CreateShipmentLinesTypedDict]]]
    r"""The order lines that are being fulfilled with this shipment. If left blank, all open order lines will be considered fulfilled.

    For an in-depth explanation of all order line properties, refer to the `lines` parameter of the [Create order](create-order) endpoint.
    """
    tracking: NotRequired[Nullable[TrackingTypedDict]]
    r"""Shipment tracking details. Can be omitted if tracking details are not available or not applicable."""


class CreateShipmentRequestBody(BaseModel):
    lines: OptionalNullable[List[CreateShipmentLines]] = UNSET
    r"""The order lines that are being fulfilled with this shipment. If left blank, all open order lines will be considered fulfilled.

    For an in-depth explanation of all order line properties, refer to the `lines` parameter of the [Create order](create-order) endpoint.
    """

    tracking: OptionalNullable[Tracking] = UNSET
    r"""Shipment tracking details. Can be omitted if tracking details are not available or not applicable."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["lines", "tracking"]
        nullable_fields = ["lines", "tracking"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CreateShipmentRequestTypedDict(TypedDict):
    order_id: str
    r"""Provide the ID of the related order."""
    request_body: NotRequired[CreateShipmentRequestBodyTypedDict]


class CreateShipmentRequest(BaseModel):
    order_id: Annotated[
        str,
        pydantic.Field(alias="orderId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related order."""

    request_body: Annotated[
        Optional[CreateShipmentRequestBody],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ] = None


class CreateShipmentShipmentsDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class CreateShipmentShipmentsDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class CreateShipmentShipmentsLinksTypedDict(TypedDict):
    documentation: NotRequired[CreateShipmentShipmentsDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class CreateShipmentShipmentsLinks(BaseModel):
    documentation: Optional[CreateShipmentShipmentsDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class CreateShipmentShipmentsResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[
        Optional[CreateShipmentShipmentsLinks], pydantic.Field(alias="_links")
    ] = None


class CreateShipmentShipmentsResponseBody(Exception):
    r"""An error response object."""

    data: CreateShipmentShipmentsResponseBodyData

    def __init__(self, data: CreateShipmentShipmentsResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, CreateShipmentShipmentsResponseBodyData)


class CreateShipmentDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class CreateShipmentDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class CreateShipmentLinksTypedDict(TypedDict):
    documentation: NotRequired[CreateShipmentDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class CreateShipmentLinks(BaseModel):
    documentation: Optional[CreateShipmentDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class CreateShipmentResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[Optional[CreateShipmentLinks], pydantic.Field(alias="_links")] = (
        None
    )


class CreateShipmentResponseBody(Exception):
    r"""An error response object."""

    data: CreateShipmentResponseBodyData

    def __init__(self, data: CreateShipmentResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, CreateShipmentResponseBodyData)
