"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie import utils
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, PathParamMetadata, RequestMetadata
import pydantic
from pydantic import model_serializer
from typing import Any, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class CreateSubscriptionAmountTypedDict(TypedDict):
    r"""The amount for each individual payment that is charged with this subscription. For example, for a monthly subscription of €10, the subscription amount should be set to €10."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateSubscriptionAmount(BaseModel):
    r"""The amount for each individual payment that is charged with this subscription. For example, for a monthly subscription of €10, the subscription amount should be set to €10."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateSubscriptionSubscriptionsAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateSubscriptionSubscriptionsAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateSubscriptionApplicationFeeTypedDict(TypedDict):
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie merchants.

    Setting an application fee on the subscription will ensure this fee is charged on each individual payment.

    Refer to the `applicationFee` parameter on the [Get payment endpoint](get-payment) documentation for more information.
    """

    amount: NotRequired[CreateSubscriptionSubscriptionsAmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    description: NotRequired[str]


class CreateSubscriptionApplicationFee(BaseModel):
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie merchants.

    Setting an application fee on the subscription will ensure this fee is charged on each individual payment.

    Refer to the `applicationFee` parameter on the [Get payment endpoint](get-payment) documentation for more information.
    """

    amount: Optional[CreateSubscriptionSubscriptionsAmount] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    description: Optional[str] = None


class CreateSubscriptionMetadata2TypedDict(TypedDict):
    pass


class CreateSubscriptionMetadata2(BaseModel):
    pass


CreateSubscriptionMetadataTypedDict = TypeAliasType(
    "CreateSubscriptionMetadataTypedDict",
    Union[CreateSubscriptionMetadata2TypedDict, str, List[Any]],
)


CreateSubscriptionMetadata = TypeAliasType(
    "CreateSubscriptionMetadata", Union[CreateSubscriptionMetadata2, str, List[Any]]
)


class CreateSubscriptionRequestBodyTypedDict(TypedDict):
    amount: CreateSubscriptionAmountTypedDict
    r"""The amount for each individual payment that is charged with this subscription. For example, for a monthly subscription of €10, the subscription amount should be set to €10."""
    interval: str
    r"""Interval to wait between payments, for example `1 month` or `14 days`.

    The maximum interval is one year (`12 months`, `52 weeks`, or `365 days`).

    Possible values: `... days` `... weeks` `... months`
    """
    description: str
    r"""The subscription's description will be used as the description of the resulting individual payments and so showing up on the bank statement of the consumer.

    **Please note:** the description needs to be unique for the Customer in case it has multiple active subscriptions.
    """
    status: NotRequired[str]
    r"""The subscription's current status is directly related to the status of the underlying customer or mandate that is enabling the subscription.

    Possible values: `pending` `active` `canceled` `suspended` `completed`
    """
    times: NotRequired[int]
    r"""Total number of payments for the subscription. Once this number of payments is reached, the subscription is considered completed.

    Test mode subscriptions will get canceled automatically after 10 payments.
    """
    start_date: NotRequired[str]
    r"""The start date of the subscription in `YYYY-MM-DD` format."""
    method: NotRequired[Nullable[str]]
    r"""The payment method used for this subscription. If omitted, any of the customer's valid mandates may be used.

    Possible values: `creditcard` `directdebit` `paypal`
    """
    application_fee: NotRequired[CreateSubscriptionApplicationFeeTypedDict]
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie merchants.

    Setting an application fee on the subscription will ensure this fee is charged on each individual payment.

    Refer to the `applicationFee` parameter on the [Get payment endpoint](get-payment) documentation for more information.
    """
    metadata: NotRequired[Nullable[CreateSubscriptionMetadataTypedDict]]
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.

    Any metadata added to the subscription will be automatically forwarded to the payments generated for it.
    """
    webhook_url: NotRequired[str]
    r"""We will call this URL for any payment status changes of payments resulting from this subscription.

    This webhook will receive **all** events for the subscription's payments. This may include payment failures as well. Be sure to verify the payment's subscription ID and its status.
    """
    mandate_id: NotRequired[Nullable[str]]
    r"""The mandate used for this subscription, if any."""
    profile_id: NotRequired[Nullable[str]]
    r"""The identifier referring to the [profile](get-profile) this entity belongs to.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted in the creation request. For organization-level credentials such as OAuth access tokens however, the `profileId` parameter is required.
    """
    testmode: NotRequired[Nullable[bool]]
    r"""Whether to create the entity in test mode or live mode.

    Most API credentials are specifically created for either live mode or test mode, in which case this parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting `testmode` to `true`.
    """


class CreateSubscriptionRequestBody(BaseModel):
    amount: CreateSubscriptionAmount
    r"""The amount for each individual payment that is charged with this subscription. For example, for a monthly subscription of €10, the subscription amount should be set to €10."""

    interval: str
    r"""Interval to wait between payments, for example `1 month` or `14 days`.

    The maximum interval is one year (`12 months`, `52 weeks`, or `365 days`).

    Possible values: `... days` `... weeks` `... months`
    """

    description: str
    r"""The subscription's description will be used as the description of the resulting individual payments and so showing up on the bank statement of the consumer.

    **Please note:** the description needs to be unique for the Customer in case it has multiple active subscriptions.
    """

    status: Optional[str] = None
    r"""The subscription's current status is directly related to the status of the underlying customer or mandate that is enabling the subscription.

    Possible values: `pending` `active` `canceled` `suspended` `completed`
    """

    times: Optional[int] = None
    r"""Total number of payments for the subscription. Once this number of payments is reached, the subscription is considered completed.

    Test mode subscriptions will get canceled automatically after 10 payments.
    """

    start_date: Annotated[Optional[str], pydantic.Field(alias="startDate")] = None
    r"""The start date of the subscription in `YYYY-MM-DD` format."""

    method: OptionalNullable[str] = UNSET
    r"""The payment method used for this subscription. If omitted, any of the customer's valid mandates may be used.

    Possible values: `creditcard` `directdebit` `paypal`
    """

    application_fee: Annotated[
        Optional[CreateSubscriptionApplicationFee],
        pydantic.Field(alias="applicationFee"),
    ] = None
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie merchants.

    Setting an application fee on the subscription will ensure this fee is charged on each individual payment.

    Refer to the `applicationFee` parameter on the [Get payment endpoint](get-payment) documentation for more information.
    """

    metadata: OptionalNullable[CreateSubscriptionMetadata] = UNSET
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.

    Any metadata added to the subscription will be automatically forwarded to the payments generated for it.
    """

    webhook_url: Annotated[Optional[str], pydantic.Field(alias="webhookUrl")] = None
    r"""We will call this URL for any payment status changes of payments resulting from this subscription.

    This webhook will receive **all** events for the subscription's payments. This may include payment failures as well. Be sure to verify the payment's subscription ID and its status.
    """

    mandate_id: Annotated[OptionalNullable[str], pydantic.Field(alias="mandateId")] = (
        UNSET
    )
    r"""The mandate used for this subscription, if any."""

    profile_id: Annotated[OptionalNullable[str], pydantic.Field(alias="profileId")] = (
        UNSET
    )
    r"""The identifier referring to the [profile](get-profile) this entity belongs to.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted in the creation request. For organization-level credentials such as OAuth access tokens however, the `profileId` parameter is required.
    """

    testmode: OptionalNullable[bool] = False
    r"""Whether to create the entity in test mode or live mode.

    Most API credentials are specifically created for either live mode or test mode, in which case this parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting `testmode` to `true`.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "status",
            "times",
            "startDate",
            "method",
            "applicationFee",
            "metadata",
            "webhookUrl",
            "mandateId",
            "profileId",
            "testmode",
        ]
        nullable_fields = ["method", "metadata", "mandateId", "profileId", "testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CreateSubscriptionRequestTypedDict(TypedDict):
    customer_id: str
    r"""Provide the ID of the related customer."""
    request_body: NotRequired[CreateSubscriptionRequestBodyTypedDict]


class CreateSubscriptionRequest(BaseModel):
    customer_id: Annotated[
        str,
        pydantic.Field(alias="customerId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related customer."""

    request_body: Annotated[
        Optional[CreateSubscriptionRequestBody],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ] = None


class CreateSubscriptionDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class CreateSubscriptionDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class CreateSubscriptionLinksTypedDict(TypedDict):
    documentation: NotRequired[CreateSubscriptionDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class CreateSubscriptionLinks(BaseModel):
    documentation: Optional[CreateSubscriptionDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class CreateSubscriptionResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[
        Optional[CreateSubscriptionLinks], pydantic.Field(alias="_links")
    ] = None


class CreateSubscriptionResponseBody(Exception):
    r"""An error response object."""

    data: CreateSubscriptionResponseBodyData

    def __init__(self, data: CreateSubscriptionResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, CreateSubscriptionResponseBodyData)
