"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie import utils
from mollie.types import BaseModel, OptionalNullable, UNSET
from mollie.utils import FieldMetadata, PathParamMetadata
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class DisableMethodRequestTypedDict(TypedDict):
    profile_id: str
    r"""Provide the ID of the related profile."""
    id: str
    r"""Provide the ID of the item you want to perform this operation on."""


class DisableMethodRequest(BaseModel):
    profile_id: Annotated[
        str,
        pydantic.Field(alias="profileId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related profile."""

    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Provide the ID of the item you want to perform this operation on."""


class DisableMethodDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class DisableMethodDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class DisableMethodLinksTypedDict(TypedDict):
    documentation: NotRequired[DisableMethodDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class DisableMethodLinks(BaseModel):
    documentation: Optional[DisableMethodDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class DisableMethodResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[Optional[DisableMethodLinks], pydantic.Field(alias="_links")] = (
        None
    )


class DisableMethodResponseBody(Exception):
    r"""An error response object."""

    data: DisableMethodResponseBodyData

    def __init__(self, data: DisableMethodResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, DisableMethodResponseBodyData)
