"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie import utils
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, PathParamMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class EnableMethodRequestTypedDict(TypedDict):
    profile_id: str
    r"""Provide the ID of the related profile."""
    id: str
    r"""Provide the ID of the item you want to perform this operation on."""


class EnableMethodRequest(BaseModel):
    profile_id: Annotated[
        str,
        pydantic.Field(alias="profileId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related profile."""

    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Provide the ID of the item you want to perform this operation on."""


class EnableMethodMethodsDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class EnableMethodMethodsDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class EnableMethodMethodsLinksTypedDict(TypedDict):
    documentation: NotRequired[EnableMethodMethodsDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class EnableMethodMethodsLinks(BaseModel):
    documentation: Optional[EnableMethodMethodsDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class EnableMethodMethodsResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[
        Optional[EnableMethodMethodsLinks], pydantic.Field(alias="_links")
    ] = None


class EnableMethodMethodsResponseBody(Exception):
    r"""An error response object."""

    data: EnableMethodMethodsResponseBodyData

    def __init__(self, data: EnableMethodMethodsResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, EnableMethodMethodsResponseBodyData)


class EnableMethodMinimumAmountTypedDict(TypedDict):
    r"""The minimum payment amount required to use this payment method."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class EnableMethodMinimumAmount(BaseModel):
    r"""The minimum payment amount required to use this payment method."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class EnableMethodMaximumAmountTypedDict(TypedDict):
    r"""The maximum payment amount allowed when using this payment method. If there is no method-specific maximum, `null` is returned instead."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class EnableMethodMaximumAmount(BaseModel):
    r"""The maximum payment amount allowed when using this payment method. If there is no method-specific maximum, `null` is returned instead."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class EnableMethodImageTypedDict(TypedDict):
    r"""URLs of images representing the payment method."""

    size1x: NotRequired[str]
    r"""The URL pointing to an icon of 32 by 24 pixels."""
    size2x: NotRequired[str]
    r"""The URL pointing to an icon of 64 by 48 pixels."""
    svg: NotRequired[str]
    r"""The URL pointing to a vector version of the icon. Usage of this format is preferred, since the icon can scale to any desired size without compromising visual quality."""


class EnableMethodImage(BaseModel):
    r"""URLs of images representing the payment method."""

    size1x: Optional[str] = None
    r"""The URL pointing to an icon of 32 by 24 pixels."""

    size2x: Optional[str] = None
    r"""The URL pointing to an icon of 64 by 48 pixels."""

    svg: Optional[str] = None
    r"""The URL pointing to a vector version of the icon. Usage of this format is preferred, since the icon can scale to any desired size without compromising visual quality."""


class EnableMethodFixedTypedDict(TypedDict):
    r"""The fixed price charged per payment."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class EnableMethodFixed(BaseModel):
    r"""The fixed price charged per payment."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class EnableMethodPricingTypedDict(TypedDict):
    description: NotRequired[str]
    r"""A description of what the pricing applies to. For example, a specific country (`The Netherlands`) or a category of cards (`American Express`). If a `locale` is provided, the description may be translated."""
    fixed: NotRequired[EnableMethodFixedTypedDict]
    r"""The fixed price charged per payment."""
    variable: NotRequired[str]
    r"""The variable price charged per payment, as a percentage string."""
    fee_region: NotRequired[str]
    r"""Only present for credit card pricing. It will correspond with the `feeRegion` of credit card payments as returned in the [Payments API](get-payment)."""


class EnableMethodPricing(BaseModel):
    description: Optional[str] = None
    r"""A description of what the pricing applies to. For example, a specific country (`The Netherlands`) or a category of cards (`American Express`). If a `locale` is provided, the description may be translated."""

    fixed: Optional[EnableMethodFixed] = None
    r"""The fixed price charged per payment."""

    variable: Optional[str] = None
    r"""The variable price charged per payment, as a percentage string."""

    fee_region: Annotated[Optional[str], pydantic.Field(alias="feeRegion")] = None
    r"""Only present for credit card pricing. It will correspond with the `feeRegion` of credit card payments as returned in the [Payments API](get-payment)."""


class EnableMethodMethodsImageTypedDict(TypedDict):
    r"""URLs of images representing the issuer."""

    size1x: NotRequired[str]
    r"""The URL pointing to an icon of 32 by 24 pixels."""
    size2x: NotRequired[str]
    r"""The URL pointing to an icon of 64 by 48 pixels."""
    svg: NotRequired[str]
    r"""The URL pointing to a vector version of the icon. Usage of this format is preferred, since the icon can scale to any desired size without compromising visual quality."""


class EnableMethodMethodsImage(BaseModel):
    r"""URLs of images representing the issuer."""

    size1x: Optional[str] = None
    r"""The URL pointing to an icon of 32 by 24 pixels."""

    size2x: Optional[str] = None
    r"""The URL pointing to an icon of 64 by 48 pixels."""

    svg: Optional[str] = None
    r"""The URL pointing to a vector version of the icon. Usage of this format is preferred, since the icon can scale to any desired size without compromising visual quality."""


class EnableMethodIssuersTypedDict(TypedDict):
    resource: NotRequired[str]
    id: NotRequired[str]
    name: NotRequired[str]
    r"""The full name of the issuer."""
    image: NotRequired[EnableMethodMethodsImageTypedDict]
    r"""URLs of images representing the issuer."""


class EnableMethodIssuers(BaseModel):
    resource: Optional[str] = "issuer"

    id: Optional[str] = None

    name: Optional[str] = None
    r"""The full name of the issuer."""

    image: Optional[EnableMethodMethodsImage] = None
    r"""URLs of images representing the issuer."""


class EnableMethodSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class EnableMethodSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class EnableMethodDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class EnableMethodDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class EnableMethodLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[EnableMethodSelfTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: NotRequired[EnableMethodDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class EnableMethodLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[EnableMethodSelf], pydantic.Field(alias="self")] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: Optional[EnableMethodDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class EnableMethodResponseBodyTypedDict(TypedDict):
    r"""The payment method object."""

    resource: NotRequired[str]
    r"""Indicates the response contains a payment method object. Will always contain the string `method` for this endpoint."""
    id: NotRequired[str]
    r"""The unique identifier of the payment method. When used during [payment creation](create-payment), the payment method selection screen will be skipped.

    Possible values: `alma` `applepay` `bacs` `bancomatpay` `bancontact` `banktransfer` `belfius` `billie` `blik` `creditcard` `directdebit` `eps` `giftcard` `ideal` `in3` `kbc` `klarna` `klarnapaylater` `klarnapaynow` `klarnasliceit` `mybank` `paypal` `paysafecard` `przelewy24` `riverty` `satispay` `trustly` `twint` `voucher`
    """
    description: NotRequired[str]
    r"""The full name of the payment method.

    If a `locale` parameter is provided, the name is translated to the given locale if possible.
    """
    minimum_amount: NotRequired[EnableMethodMinimumAmountTypedDict]
    r"""The minimum payment amount required to use this payment method."""
    maximum_amount: NotRequired[Nullable[EnableMethodMaximumAmountTypedDict]]
    r"""The maximum payment amount allowed when using this payment method. If there is no method-specific maximum, `null` is returned instead."""
    image: NotRequired[EnableMethodImageTypedDict]
    r"""URLs of images representing the payment method."""
    status: NotRequired[str]
    r"""The payment method's activation status for this profile.

    Possible values:
    * `activated`: The payment method is activated and ready for use.
    * `pending-boarding`: Mollie is waiting for you to finish onboarding in the Merchant Dashboard before the payment method can be activated.
    * `pending-review`: Mollie needs to review your request for this payment method before it can be activated.
    * `pending-external`: Activation of this payment method relies on you taking action with an external party, for example signing up with PayPal or a giftcard issuer.
    * `rejected`: Your request for this payment method was rejected. Whenever Mollie rejects such a request, you will always be informed via email.
    * `null`: This payment method was not requested.
    """
    pricing: NotRequired[List[EnableMethodPricingTypedDict]]
    r"""**Optional include.** Array of objects describing the pricing configuration applicable for this payment method on your account."""
    issuers: NotRequired[List[EnableMethodIssuersTypedDict]]
    r"""**Optional include.** Array of objects for each 'issuer' that is available for this payment method. Only relevant for iDEAL, KBC/CBC, gift cards, and vouchers."""
    links: NotRequired[EnableMethodLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class EnableMethodResponseBody(BaseModel):
    r"""The payment method object."""

    resource: Optional[str] = "method"
    r"""Indicates the response contains a payment method object. Will always contain the string `method` for this endpoint."""

    id: Optional[str] = None
    r"""The unique identifier of the payment method. When used during [payment creation](create-payment), the payment method selection screen will be skipped.

    Possible values: `alma` `applepay` `bacs` `bancomatpay` `bancontact` `banktransfer` `belfius` `billie` `blik` `creditcard` `directdebit` `eps` `giftcard` `ideal` `in3` `kbc` `klarna` `klarnapaylater` `klarnapaynow` `klarnasliceit` `mybank` `paypal` `paysafecard` `przelewy24` `riverty` `satispay` `trustly` `twint` `voucher`
    """

    description: Optional[str] = None
    r"""The full name of the payment method.

    If a `locale` parameter is provided, the name is translated to the given locale if possible.
    """

    minimum_amount: Annotated[
        Optional[EnableMethodMinimumAmount], pydantic.Field(alias="minimumAmount")
    ] = None
    r"""The minimum payment amount required to use this payment method."""

    maximum_amount: Annotated[
        OptionalNullable[EnableMethodMaximumAmount],
        pydantic.Field(alias="maximumAmount"),
    ] = UNSET
    r"""The maximum payment amount allowed when using this payment method. If there is no method-specific maximum, `null` is returned instead."""

    image: Optional[EnableMethodImage] = None
    r"""URLs of images representing the payment method."""

    status: Optional[str] = None
    r"""The payment method's activation status for this profile.

    Possible values:
    * `activated`: The payment method is activated and ready for use.
    * `pending-boarding`: Mollie is waiting for you to finish onboarding in the Merchant Dashboard before the payment method can be activated.
    * `pending-review`: Mollie needs to review your request for this payment method before it can be activated.
    * `pending-external`: Activation of this payment method relies on you taking action with an external party, for example signing up with PayPal or a giftcard issuer.
    * `rejected`: Your request for this payment method was rejected. Whenever Mollie rejects such a request, you will always be informed via email.
    * `null`: This payment method was not requested.
    """

    pricing: Optional[List[EnableMethodPricing]] = None
    r"""**Optional include.** Array of objects describing the pricing configuration applicable for this payment method on your account."""

    issuers: Optional[List[EnableMethodIssuers]] = None
    r"""**Optional include.** Array of objects for each 'issuer' that is available for this payment method. Only relevant for iDEAL, KBC/CBC, gift cards, and vouchers."""

    links: Annotated[Optional[EnableMethodLinks], pydantic.Field(alias="_links")] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "resource",
            "id",
            "description",
            "minimumAmount",
            "maximumAmount",
            "image",
            "status",
            "pricing",
            "issuers",
            "_links",
        ]
        nullable_fields = ["maximumAmount"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
