"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import Any, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetCurrentProfileReviewTypedDict(TypedDict):
    r"""Present if changes have been made that have not yet been approved by Mollie. Changes to test profiles are approved automatically, unless a switch to a live profile has been requested. The review object will therefore usually be `null` in test mode."""

    status: NotRequired[str]
    r"""The status of the requested changes.

    Possible values: `pending` `rejected`
    """


class GetCurrentProfileReview(BaseModel):
    r"""Present if changes have been made that have not yet been approved by Mollie. Changes to test profiles are approved automatically, unless a switch to a live profile has been requested. The review object will therefore usually be `null` in test mode."""

    status: Optional[str] = None
    r"""The status of the requested changes.

    Possible values: `pending` `rejected`
    """


class GetCurrentProfileSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetCurrentProfileSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetCurrentProfileDashboardTypedDict(TypedDict):
    r"""Link to the profile in the Mollie dashboard."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetCurrentProfileDashboard(BaseModel):
    r"""Link to the profile in the Mollie dashboard."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetCurrentProfileChargebacksTypedDict(TypedDict):
    r"""The API resource URL of the chargebacks that belong to this profile."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetCurrentProfileChargebacks(BaseModel):
    r"""The API resource URL of the chargebacks that belong to this profile."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetCurrentProfileMethodsTypedDict(TypedDict):
    r"""The API resource URL of the methods that are enabled for this profile."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetCurrentProfileMethods(BaseModel):
    r"""The API resource URL of the methods that are enabled for this profile."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetCurrentProfilePaymentsTypedDict(TypedDict):
    r"""The API resource URL of the payments that belong to this profile."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetCurrentProfilePayments(BaseModel):
    r"""The API resource URL of the payments that belong to this profile."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetCurrentProfileRefundsTypedDict(TypedDict):
    r"""The API resource URL of the refunds that belong to this profile."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetCurrentProfileRefunds(BaseModel):
    r"""The API resource URL of the refunds that belong to this profile."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetCurrentProfileCheckoutPreviewURLTypedDict(TypedDict):
    r"""The hosted checkout preview URL. You need to be logged in to access this page."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetCurrentProfileCheckoutPreviewURL(BaseModel):
    r"""The hosted checkout preview URL. You need to be logged in to access this page."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetCurrentProfileDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetCurrentProfileDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetCurrentProfileLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[GetCurrentProfileSelfTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    dashboard: NotRequired[GetCurrentProfileDashboardTypedDict]
    r"""Link to the profile in the Mollie dashboard."""
    chargebacks: NotRequired[GetCurrentProfileChargebacksTypedDict]
    r"""The API resource URL of the chargebacks that belong to this profile."""
    methods: NotRequired[GetCurrentProfileMethodsTypedDict]
    r"""The API resource URL of the methods that are enabled for this profile."""
    payments: NotRequired[GetCurrentProfilePaymentsTypedDict]
    r"""The API resource URL of the payments that belong to this profile."""
    refunds: NotRequired[GetCurrentProfileRefundsTypedDict]
    r"""The API resource URL of the refunds that belong to this profile."""
    checkout_preview_url: NotRequired[GetCurrentProfileCheckoutPreviewURLTypedDict]
    r"""The hosted checkout preview URL. You need to be logged in to access this page."""
    documentation: NotRequired[GetCurrentProfileDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetCurrentProfileLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[GetCurrentProfileSelf], pydantic.Field(alias="self")] = (
        None
    )
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    dashboard: Optional[GetCurrentProfileDashboard] = None
    r"""Link to the profile in the Mollie dashboard."""

    chargebacks: Optional[GetCurrentProfileChargebacks] = None
    r"""The API resource URL of the chargebacks that belong to this profile."""

    methods: Optional[GetCurrentProfileMethods] = None
    r"""The API resource URL of the methods that are enabled for this profile."""

    payments: Optional[GetCurrentProfilePayments] = None
    r"""The API resource URL of the payments that belong to this profile."""

    refunds: Optional[GetCurrentProfileRefunds] = None
    r"""The API resource URL of the refunds that belong to this profile."""

    checkout_preview_url: Annotated[
        Optional[GetCurrentProfileCheckoutPreviewURL],
        pydantic.Field(alias="checkoutPreviewUrl"),
    ] = None
    r"""The hosted checkout preview URL. You need to be logged in to access this page."""

    documentation: Optional[GetCurrentProfileDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetCurrentProfileResponseBodyTypedDict(TypedDict):
    r"""The current profile object. For a complete reference of the profile object, refer to the [Get profile](get-profile) endpoint documentation."""

    resource: NotRequired[str]
    r"""Indicates the response contains a profile object. Will always contain the string `profile` for this endpoint."""
    id: NotRequired[str]
    r"""The identifier uniquely referring to this profile. Example: `pfl_v9hTwCvYqw`."""
    mode: NotRequired[str]
    r"""Whether this entity was created in live mode or in test mode.

    Possible values: `live` `test`
    """
    name: NotRequired[str]
    r"""The profile's name, this will usually reflect the trade name or brand name of the profile's website or application."""
    website: NotRequired[str]
    r"""The URL to the profile's website or application. Only `https` or `http` URLs are allowed. No `@` signs are allowed."""
    email: NotRequired[str]
    r"""The email address associated with the profile's trade name or brand."""
    phone: NotRequired[str]
    r"""The phone number associated with the profile's trade name or brand."""
    description: NotRequired[Nullable[str]]
    r"""The products or services offered by the profile's website or application."""
    countries_of_activity: NotRequired[List[Any]]
    r"""A list of countries where you expect that the majority of the profile's customers reside, in ISO 3166-1 alpha-2 format."""
    business_category: NotRequired[str]
    r"""The industry associated with the profile's trade name or brand. Please refer to the [business category list](common-data-types#business-category) for all possible options."""
    status: NotRequired[str]
    r"""The profile status determines whether the profile is able to receive live payments.

    * `unverified`: The profile has not been verified yet and can only be used to create test payments.
    * `verified`: The profile has been verified and can be used to create live payments and test payments.
    * `blocked`: The profile is blocked and can no longer be used or changed.

    Possible values: `unverified` `verified` `blocked`
    """
    review: NotRequired[Nullable[GetCurrentProfileReviewTypedDict]]
    r"""Present if changes have been made that have not yet been approved by Mollie. Changes to test profiles are approved automatically, unless a switch to a live profile has been requested. The review object will therefore usually be `null` in test mode."""
    created_at: NotRequired[str]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    links: NotRequired[GetCurrentProfileLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class GetCurrentProfileResponseBody(BaseModel):
    r"""The current profile object. For a complete reference of the profile object, refer to the [Get profile](get-profile) endpoint documentation."""

    resource: Optional[str] = "profile"
    r"""Indicates the response contains a profile object. Will always contain the string `profile` for this endpoint."""

    id: Optional[str] = None
    r"""The identifier uniquely referring to this profile. Example: `pfl_v9hTwCvYqw`."""

    mode: Optional[str] = None
    r"""Whether this entity was created in live mode or in test mode.

    Possible values: `live` `test`
    """

    name: Optional[str] = None
    r"""The profile's name, this will usually reflect the trade name or brand name of the profile's website or application."""

    website: Optional[str] = None
    r"""The URL to the profile's website or application. Only `https` or `http` URLs are allowed. No `@` signs are allowed."""

    email: Optional[str] = None
    r"""The email address associated with the profile's trade name or brand."""

    phone: Optional[str] = None
    r"""The phone number associated with the profile's trade name or brand."""

    description: OptionalNullable[str] = UNSET
    r"""The products or services offered by the profile's website or application."""

    countries_of_activity: Annotated[
        Optional[List[Any]], pydantic.Field(alias="countriesOfActivity")
    ] = None
    r"""A list of countries where you expect that the majority of the profile's customers reside, in ISO 3166-1 alpha-2 format."""

    business_category: Annotated[
        Optional[str], pydantic.Field(alias="businessCategory")
    ] = None
    r"""The industry associated with the profile's trade name or brand. Please refer to the [business category list](common-data-types#business-category) for all possible options."""

    status: Optional[str] = None
    r"""The profile status determines whether the profile is able to receive live payments.

    * `unverified`: The profile has not been verified yet and can only be used to create test payments.
    * `verified`: The profile has been verified and can be used to create live payments and test payments.
    * `blocked`: The profile is blocked and can no longer be used or changed.

    Possible values: `unverified` `verified` `blocked`
    """

    review: OptionalNullable[GetCurrentProfileReview] = UNSET
    r"""Present if changes have been made that have not yet been approved by Mollie. Changes to test profiles are approved automatically, unless a switch to a live profile has been requested. The review object will therefore usually be `null` in test mode."""

    created_at: Annotated[Optional[str], pydantic.Field(alias="createdAt")] = None
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    links: Annotated[
        Optional[GetCurrentProfileLinks], pydantic.Field(alias="_links")
    ] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "resource",
            "id",
            "mode",
            "name",
            "website",
            "email",
            "phone",
            "description",
            "countriesOfActivity",
            "businessCategory",
            "status",
            "review",
            "createdAt",
            "_links",
        ]
        nullable_fields = ["description", "review"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
