"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie import utils
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing import Any, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class GetOrderRequestTypedDict(TypedDict):
    id: str
    r"""Provide the ID of the item you want to perform this operation on."""
    embed: NotRequired[Nullable[str]]
    r"""This endpoint allows embedding related API items by appending the following values via the `embed` query string parameter.

    * `payments`: Include all payments created for this order.
    * `refunds`: Include all refunds created for this order.
    * `shipments`: Include all shipments created for this order.
    """
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class GetOrderRequest(BaseModel):
    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Provide the ID of the item you want to perform this operation on."""

    embed: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""This endpoint allows embedding related API items by appending the following values via the `embed` query string parameter.

    * `payments`: Include all payments created for this order.
    * `refunds`: Include all refunds created for this order.
    * `shipments`: Include all shipments created for this order.
    """

    testmode: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = False
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["embed", "testmode"]
        nullable_fields = ["embed", "testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetOrderOrdersDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class GetOrderOrdersDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class GetOrderOrdersResponseLinksTypedDict(TypedDict):
    documentation: NotRequired[GetOrderOrdersDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class GetOrderOrdersResponseLinks(BaseModel):
    documentation: Optional[GetOrderOrdersDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class GetOrderOrdersResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[
        Optional[GetOrderOrdersResponseLinks], pydantic.Field(alias="_links")
    ] = None


class GetOrderOrdersResponseBody(Exception):
    r"""An error response object."""

    data: GetOrderOrdersResponseBodyData

    def __init__(self, data: GetOrderOrdersResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, GetOrderOrdersResponseBodyData)


class GetOrderUnitPriceTypedDict(TypedDict):
    r"""The price of a single item including VAT.

    For example: `{\"currency\":\"EUR\", \"value\":\"89.00\"}` if the box of LEGO costs €89.00 each.

    For types `discount`, `store_credit`, and `gift_card`, the unit price must be negative.

    The unit price can be zero in case of free items.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetOrderUnitPrice(BaseModel):
    r"""The price of a single item including VAT.

    For example: `{\"currency\":\"EUR\", \"value\":\"89.00\"}` if the box of LEGO costs €89.00 each.

    For types `discount`, `store_credit`, and `gift_card`, the unit price must be negative.

    The unit price can be zero in case of free items.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetOrderDiscountAmountTypedDict(TypedDict):
    r"""Any line-specific discounts, as a positive amount. Not relevant if the line itself is already a discount type."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetOrderDiscountAmount(BaseModel):
    r"""Any line-specific discounts, as a positive amount. Not relevant if the line itself is already a discount type."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetOrderTotalAmountTypedDict(TypedDict):
    r"""The total amount of the line, including VAT and discounts.

    Should match the following formula: `(unitPrice × quantity) - discountAmount`.

    The sum of all `totalAmount` values of all order lines should be equal to the full payment amount.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetOrderTotalAmount(BaseModel):
    r"""The total amount of the line, including VAT and discounts.

    Should match the following formula: `(unitPrice × quantity) - discountAmount`.

    The sum of all `totalAmount` values of all order lines should be equal to the full payment amount.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetOrderVatAmountTypedDict(TypedDict):
    r"""The amount of value-added tax on the line. The `totalAmount` field includes VAT, so the `vatAmount` can be calculated with the formula `totalAmount × (vatRate / (100 + vatRate))`.

    Any deviations from this will result in an error.

    For example, for a `totalAmount` of SEK 100.00 with a 25.00% VAT rate, we expect a VAT amount of `SEK 100.00 × (25 / 125) = SEK 20.00`.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetOrderVatAmount(BaseModel):
    r"""The amount of value-added tax on the line. The `totalAmount` field includes VAT, so the `vatAmount` can be calculated with the formula `totalAmount × (vatRate / (100 + vatRate))`.

    Any deviations from this will result in an error.

    For example, for a `totalAmount` of SEK 100.00 with a 25.00% VAT rate, we expect a VAT amount of `SEK 100.00 × (25 / 125) = SEK 20.00`.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetOrderMetadataOrders2TypedDict(TypedDict):
    pass


class GetOrderMetadataOrders2(BaseModel):
    pass


GetOrderOrdersMetadataTypedDict = TypeAliasType(
    "GetOrderOrdersMetadataTypedDict",
    Union[GetOrderMetadataOrders2TypedDict, str, List[Any]],
)


GetOrderOrdersMetadata = TypeAliasType(
    "GetOrderOrdersMetadata", Union[GetOrderMetadataOrders2, str, List[Any]]
)


class GetOrderOrdersSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetOrderOrdersSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ImageURLTypedDict(TypedDict):
    r"""A link pointing to an image of the product sold."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ImageURL(BaseModel):
    r"""A link pointing to an image of the product sold."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ProductURLTypedDict(TypedDict):
    r"""A link pointing to the product page in your web shop of the product sold."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ProductURL(BaseModel):
    r"""A link pointing to the product page in your web shop of the product sold."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetOrderOrdersLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[GetOrderOrdersSelfTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    image_url: NotRequired[ImageURLTypedDict]
    r"""A link pointing to an image of the product sold."""
    product_url: NotRequired[ProductURLTypedDict]
    r"""A link pointing to the product page in your web shop of the product sold."""


class GetOrderOrdersLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[GetOrderOrdersSelf], pydantic.Field(alias="self")] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    image_url: Annotated[Optional[ImageURL], pydantic.Field(alias="imageUrl")] = None
    r"""A link pointing to an image of the product sold."""

    product_url: Annotated[Optional[ProductURL], pydantic.Field(alias="productUrl")] = (
        None
    )
    r"""A link pointing to the product page in your web shop of the product sold."""


class GetOrderLinesTypedDict(TypedDict):
    name: str
    r"""A description of the line item. For example *LEGO 4440 Forest Police Station*."""
    quantity: int
    r"""The number of items."""
    unit_price: GetOrderUnitPriceTypedDict
    r"""The price of a single item including VAT.

    For example: `{\"currency\":\"EUR\", \"value\":\"89.00\"}` if the box of LEGO costs €89.00 each.

    For types `discount`, `store_credit`, and `gift_card`, the unit price must be negative.

    The unit price can be zero in case of free items.
    """
    total_amount: GetOrderTotalAmountTypedDict
    r"""The total amount of the line, including VAT and discounts.

    Should match the following formula: `(unitPrice × quantity) - discountAmount`.

    The sum of all `totalAmount` values of all order lines should be equal to the full payment amount.
    """
    resource: NotRequired[str]
    r"""Indicates the response contains an order line object. Will always contain the string `orderline`."""
    id: NotRequired[str]
    r"""The identifier uniquely referring to this order line. Mollie assigns this identifier at order line creation time. Example: `odl_jp31jz`."""
    type: NotRequired[str]
    r"""The type of product purchased. For example, a physical or a digital product.

    Possible values: `physical` `digital` `shipping_fee` `discount` `store_credit` `gift_card` `surcharge` (default: `physical`)
    """
    quantity_unit: NotRequired[str]
    r"""The unit for the quantity. For example *pcs*, *kg*, or *cm*."""
    discount_amount: NotRequired[GetOrderDiscountAmountTypedDict]
    r"""Any line-specific discounts, as a positive amount. Not relevant if the line itself is already a discount type."""
    vat_rate: NotRequired[str]
    r"""The VAT rate applied to the line, for example `21.00` for 21%. The vatRate should be passed as a string and not as a float, to ensure the correct number of decimals are passed."""
    vat_amount: NotRequired[GetOrderVatAmountTypedDict]
    r"""The amount of value-added tax on the line. The `totalAmount` field includes VAT, so the `vatAmount` can be calculated with the formula `totalAmount × (vatRate / (100 + vatRate))`.

    Any deviations from this will result in an error.

    For example, for a `totalAmount` of SEK 100.00 with a 25.00% VAT rate, we expect a VAT amount of `SEK 100.00 × (25 / 125) = SEK 20.00`.
    """
    sku: NotRequired[str]
    r"""The SKU, EAN, ISBN or UPC of the product sold."""
    category: NotRequired[Nullable[str]]
    r"""The voucher category, in case of an order line eligible for a voucher. See the [Integrating Vouchers](integrating-vouchers) guide for more information.

    Possible values: `meal` `eco` `gift` `sport_culture`
    """
    status: NotRequired[str]
    r"""The status of the order line.

    Possible values: `created` `authorized` `paid` `shipping` `completed` `canceled`
    """
    is_cancelable: NotRequired[bool]
    r"""Whether the order line can still be canceled."""
    metadata: NotRequired[Nullable[GetOrderOrdersMetadataTypedDict]]
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""
    order_id: NotRequired[str]
    r"""The unique identifier of the order this order line belongs to. For example: `ord_8wmqcHMN4U`."""
    created_at: NotRequired[str]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    links: NotRequired[GetOrderOrdersLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class GetOrderLines(BaseModel):
    name: str
    r"""A description of the line item. For example *LEGO 4440 Forest Police Station*."""

    quantity: int
    r"""The number of items."""

    unit_price: Annotated[GetOrderUnitPrice, pydantic.Field(alias="unitPrice")]
    r"""The price of a single item including VAT.

    For example: `{\"currency\":\"EUR\", \"value\":\"89.00\"}` if the box of LEGO costs €89.00 each.

    For types `discount`, `store_credit`, and `gift_card`, the unit price must be negative.

    The unit price can be zero in case of free items.
    """

    total_amount: Annotated[GetOrderTotalAmount, pydantic.Field(alias="totalAmount")]
    r"""The total amount of the line, including VAT and discounts.

    Should match the following formula: `(unitPrice × quantity) - discountAmount`.

    The sum of all `totalAmount` values of all order lines should be equal to the full payment amount.
    """

    resource: Optional[str] = "orderline"
    r"""Indicates the response contains an order line object. Will always contain the string `orderline`."""

    id: Optional[str] = None
    r"""The identifier uniquely referring to this order line. Mollie assigns this identifier at order line creation time. Example: `odl_jp31jz`."""

    type: Optional[str] = None
    r"""The type of product purchased. For example, a physical or a digital product.

    Possible values: `physical` `digital` `shipping_fee` `discount` `store_credit` `gift_card` `surcharge` (default: `physical`)
    """

    quantity_unit: Annotated[Optional[str], pydantic.Field(alias="quantityUnit")] = None
    r"""The unit for the quantity. For example *pcs*, *kg*, or *cm*."""

    discount_amount: Annotated[
        Optional[GetOrderDiscountAmount], pydantic.Field(alias="discountAmount")
    ] = None
    r"""Any line-specific discounts, as a positive amount. Not relevant if the line itself is already a discount type."""

    vat_rate: Annotated[Optional[str], pydantic.Field(alias="vatRate")] = None
    r"""The VAT rate applied to the line, for example `21.00` for 21%. The vatRate should be passed as a string and not as a float, to ensure the correct number of decimals are passed."""

    vat_amount: Annotated[
        Optional[GetOrderVatAmount], pydantic.Field(alias="vatAmount")
    ] = None
    r"""The amount of value-added tax on the line. The `totalAmount` field includes VAT, so the `vatAmount` can be calculated with the formula `totalAmount × (vatRate / (100 + vatRate))`.

    Any deviations from this will result in an error.

    For example, for a `totalAmount` of SEK 100.00 with a 25.00% VAT rate, we expect a VAT amount of `SEK 100.00 × (25 / 125) = SEK 20.00`.
    """

    sku: Optional[str] = None
    r"""The SKU, EAN, ISBN or UPC of the product sold."""

    category: OptionalNullable[str] = UNSET
    r"""The voucher category, in case of an order line eligible for a voucher. See the [Integrating Vouchers](integrating-vouchers) guide for more information.

    Possible values: `meal` `eco` `gift` `sport_culture`
    """

    status: Optional[str] = None
    r"""The status of the order line.

    Possible values: `created` `authorized` `paid` `shipping` `completed` `canceled`
    """

    is_cancelable: Annotated[Optional[bool], pydantic.Field(alias="isCancelable")] = (
        None
    )
    r"""Whether the order line can still be canceled."""

    metadata: OptionalNullable[GetOrderOrdersMetadata] = UNSET
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""

    order_id: Annotated[Optional[str], pydantic.Field(alias="orderId")] = None
    r"""The unique identifier of the order this order line belongs to. For example: `ord_8wmqcHMN4U`."""

    created_at: Annotated[Optional[str], pydantic.Field(alias="createdAt")] = None
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    links: Annotated[Optional[GetOrderOrdersLinks], pydantic.Field(alias="_links")] = (
        None
    )
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "resource",
            "id",
            "type",
            "quantityUnit",
            "discountAmount",
            "vatRate",
            "vatAmount",
            "sku",
            "category",
            "status",
            "isCancelable",
            "metadata",
            "orderId",
            "createdAt",
            "_links",
        ]
        nullable_fields = ["category", "metadata"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetOrderAmountTypedDict(TypedDict):
    r"""The amount that you want to charge, e.g. `{currency:\"EUR\", value:\"1000.00\"}` if you would want to charge €1000.00.

    You can find the minimum and maximum amounts per payment method in our help center. Additionally, they can be retrieved using the Get method endpoint.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetOrderAmount(BaseModel):
    r"""The amount that you want to charge, e.g. `{currency:\"EUR\", value:\"1000.00\"}` if you would want to charge €1000.00.

    You can find the minimum and maximum amounts per payment method in our help center. Additionally, they can be retrieved using the Get method endpoint.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class AmountRefundedTypedDict(TypedDict):
    r"""The total amount that is already refunded. Only available when refunds are available for this order. For some payment methods, this amount may be higher than the order amount, for example to allow reimbursement of the costs for a return shipment to the customer."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class AmountRefunded(BaseModel):
    r"""The total amount that is already refunded. Only available when refunds are available for this order. For some payment methods, this amount may be higher than the order amount, for example to allow reimbursement of the costs for a return shipment to the customer."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class AmountCapturedTypedDict(TypedDict):
    r"""The total amount that is already captured for this order. Only available when this order supports captures."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class AmountCaptured(BaseModel):
    r"""The total amount that is already captured for this order. Only available when this order supports captures."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetOrderBillingAddressTypedDict(TypedDict):
    r"""The customer's billing address details. The billing address is required, unless a fast checkout method like PayPal Express Checkout is providing the billing address."""

    street_and_number: str
    r"""A street and street number."""
    city: str
    country: str
    r"""A country code in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format."""
    title: NotRequired[str]
    r"""The title of the person, for example *Mr.* or *Mrs.*."""
    given_name: NotRequired[str]
    r"""The given name (first name) of the person should be at least two characters and cannot contain only numbers."""
    family_name: NotRequired[str]
    r"""The given family name (surname) of the person should be at least two characters and cannot contain only numbers."""
    organization_name: NotRequired[str]
    r"""The name of the organization, in case the addressee is an organization."""
    street_additional: NotRequired[str]
    r"""Any additional addressing details, for example an apartment number."""
    postal_code: NotRequired[str]
    r"""A postal code. This field may be required if the provided country has a postal code system."""
    email: NotRequired[str]
    phone: NotRequired[str]
    r"""If provided, it must be in the [E.164](https://en.wikipedia.org/wiki/E.164) format. For example: +31208202070."""
    region: NotRequired[str]


class GetOrderBillingAddress(BaseModel):
    r"""The customer's billing address details. The billing address is required, unless a fast checkout method like PayPal Express Checkout is providing the billing address."""

    street_and_number: Annotated[str, pydantic.Field(alias="streetAndNumber")]
    r"""A street and street number."""

    city: str

    country: str
    r"""A country code in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format."""

    title: Optional[str] = None
    r"""The title of the person, for example *Mr.* or *Mrs.*."""

    given_name: Annotated[Optional[str], pydantic.Field(alias="givenName")] = None
    r"""The given name (first name) of the person should be at least two characters and cannot contain only numbers."""

    family_name: Annotated[Optional[str], pydantic.Field(alias="familyName")] = None
    r"""The given family name (surname) of the person should be at least two characters and cannot contain only numbers."""

    organization_name: Annotated[
        Optional[str], pydantic.Field(alias="organizationName")
    ] = None
    r"""The name of the organization, in case the addressee is an organization."""

    street_additional: Annotated[
        Optional[str], pydantic.Field(alias="streetAdditional")
    ] = None
    r"""Any additional addressing details, for example an apartment number."""

    postal_code: Annotated[Optional[str], pydantic.Field(alias="postalCode")] = None
    r"""A postal code. This field may be required if the provided country has a postal code system."""

    email: Optional[str] = None

    phone: Optional[str] = None
    r"""If provided, it must be in the [E.164](https://en.wikipedia.org/wiki/E.164) format. For example: +31208202070."""

    region: Optional[str] = None


class GetOrderShippingAddressTypedDict(TypedDict):
    r"""The customer's shipping address details. We advise to provide these details to improve fraud protection and conversion. This is particularly relevant for card payments."""

    street_and_number: str
    r"""A street and street number."""
    city: str
    country: str
    r"""A country code in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format."""
    title: NotRequired[str]
    r"""The title of the person, for example *Mr.* or *Mrs.*."""
    given_name: NotRequired[str]
    r"""The given name (first name) of the person should be at least two characters and cannot contain only numbers."""
    family_name: NotRequired[str]
    r"""The given family name (surname) of the person should be at least two characters and cannot contain only numbers."""
    organization_name: NotRequired[str]
    r"""The name of the organization, in case the addressee is an organization."""
    street_additional: NotRequired[str]
    r"""Any additional addressing details, for example an apartment number."""
    postal_code: NotRequired[str]
    r"""A postal code. This field may be required if the provided country has a postal code system."""
    email: NotRequired[str]
    phone: NotRequired[str]
    r"""If provided, it must be in the [E.164](https://en.wikipedia.org/wiki/E.164) format. For example: +31208202070."""
    region: NotRequired[str]


class GetOrderShippingAddress(BaseModel):
    r"""The customer's shipping address details. We advise to provide these details to improve fraud protection and conversion. This is particularly relevant for card payments."""

    street_and_number: Annotated[str, pydantic.Field(alias="streetAndNumber")]
    r"""A street and street number."""

    city: str

    country: str
    r"""A country code in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format."""

    title: Optional[str] = None
    r"""The title of the person, for example *Mr.* or *Mrs.*."""

    given_name: Annotated[Optional[str], pydantic.Field(alias="givenName")] = None
    r"""The given name (first name) of the person should be at least two characters and cannot contain only numbers."""

    family_name: Annotated[Optional[str], pydantic.Field(alias="familyName")] = None
    r"""The given family name (surname) of the person should be at least two characters and cannot contain only numbers."""

    organization_name: Annotated[
        Optional[str], pydantic.Field(alias="organizationName")
    ] = None
    r"""The name of the organization, in case the addressee is an organization."""

    street_additional: Annotated[
        Optional[str], pydantic.Field(alias="streetAdditional")
    ] = None
    r"""Any additional addressing details, for example an apartment number."""

    postal_code: Annotated[Optional[str], pydantic.Field(alias="postalCode")] = None
    r"""A postal code. This field may be required if the provided country has a postal code system."""

    email: Optional[str] = None

    phone: Optional[str] = None
    r"""If provided, it must be in the [E.164](https://en.wikipedia.org/wiki/E.164) format. For example: +31208202070."""

    region: Optional[str] = None


class GetOrderMetadata2TypedDict(TypedDict):
    pass


class GetOrderMetadata2(BaseModel):
    pass


GetOrderMetadataTypedDict = TypeAliasType(
    "GetOrderMetadataTypedDict", Union[GetOrderMetadata2TypedDict, str, List[Any]]
)


GetOrderMetadata = TypeAliasType(
    "GetOrderMetadata", Union[GetOrderMetadata2, str, List[Any]]
)


class GetOrderPaymentTypedDict(TypedDict):
    r"""Any payment specific properties (for example, the `dueDate` for bank transfer payments) can be passed here. See [method-specific parameters](extra-payment-parameters) for all the possible fields."""


class GetOrderPayment(BaseModel):
    r"""Any payment specific properties (for example, the `dueDate` for bank transfer payments) can be passed here. See [method-specific parameters](extra-payment-parameters) for all the possible fields."""


class GetOrderSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetOrderSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class CheckoutTypedDict(TypedDict):
    r"""The URL your customer should visit to make the payment. This is where you should redirect the customer to."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class Checkout(BaseModel):
    r"""The URL your customer should visit to make the payment. This is where you should redirect the customer to."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetOrderDashboardTypedDict(TypedDict):
    r"""Direct link to the order in the Mollie dashboard."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetOrderDashboard(BaseModel):
    r"""Direct link to the order in the Mollie dashboard."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetOrderDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetOrderDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetOrderLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[GetOrderSelfTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    checkout: NotRequired[Nullable[CheckoutTypedDict]]
    r"""The URL your customer should visit to make the payment. This is where you should redirect the customer to."""
    dashboard: NotRequired[GetOrderDashboardTypedDict]
    r"""Direct link to the order in the Mollie dashboard."""
    documentation: NotRequired[GetOrderDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetOrderLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[GetOrderSelf], pydantic.Field(alias="self")] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    checkout: OptionalNullable[Checkout] = UNSET
    r"""The URL your customer should visit to make the payment. This is where you should redirect the customer to."""

    dashboard: Optional[GetOrderDashboard] = None
    r"""Direct link to the order in the Mollie dashboard."""

    documentation: Optional[GetOrderDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["self", "checkout", "dashboard", "documentation"]
        nullable_fields = ["checkout"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetOrderResponseBodyTypedDict(TypedDict):
    r"""The order object."""

    resource: NotRequired[str]
    r"""Indicates the response contains an order object. Will always contain the string `order` for this endpoint."""
    id: NotRequired[str]
    r"""The identifier uniquely referring to this order. Mollie assigns this identifier at payment creation time. Mollie will always refer to the order by this ID. Example: `ord_vsKJpSsabw`."""
    mode: NotRequired[str]
    r"""Whether this entity was created in live mode or in test mode.

    Possible values: `live` `test`
    """
    order_number: NotRequired[str]
    r"""The order number for this order. We recommend each order number to be unique."""
    lines: NotRequired[List[GetOrderLinesTypedDict]]
    r"""The order lines for the order. Each line contains details such as a description of the item ordered and its price.

    All lines must have the same currency as the payment.
    """
    amount: NotRequired[GetOrderAmountTypedDict]
    r"""The amount that you want to charge, e.g. `{currency:\"EUR\", value:\"1000.00\"}` if you would want to charge €1000.00.

    You can find the minimum and maximum amounts per payment method in our help center. Additionally, they can be retrieved using the Get method endpoint.
    """
    amount_refunded: NotRequired[Nullable[AmountRefundedTypedDict]]
    r"""The total amount that is already refunded. Only available when refunds are available for this order. For some payment methods, this amount may be higher than the order amount, for example to allow reimbursement of the costs for a return shipment to the customer."""
    amount_captured: NotRequired[Nullable[AmountCapturedTypedDict]]
    r"""The total amount that is already captured for this order. Only available when this order supports captures."""
    redirect_url: NotRequired[Nullable[str]]
    r"""The URL your customer will be redirected to after the payment process.

    It could make sense for the redirectUrl to contain a unique identifier – like your order ID – so you can show the right page referencing the order when your customer returns.

    The parameter is normally required, but can be omitted for recurring payments (`sequenceType: recurring`) and for Apple Pay payments with an `applePayPaymentToken`.
    """
    cancel_url: NotRequired[Nullable[str]]
    r"""The URL your customer will be redirected to when the customer explicitly cancels the payment. If this URL is not provided, the customer will be redirected to the `redirectUrl` instead — see above.

    Mollie will always give you status updates via webhooks, including for the canceled status. This parameter is therefore entirely optional, but can be useful when implementing a dedicated customer-facing flow to handle payment cancellations.
    """
    webhook_url: NotRequired[Nullable[str]]
    r"""The webhook URL where we will send order status updates to.

    The webhookUrl is optional, but without a webhook you will miss out on important status changes to your order.

    The webhookUrl must be reachable from Mollie's point of view, so you cannot use `localhost`. If you want to use webhook during development on `localhost`, you must use a tool like ngrok to have the webhooks delivered to your local machine.
    """
    billing_address: NotRequired[GetOrderBillingAddressTypedDict]
    r"""The customer's billing address details. The billing address is required, unless a fast checkout method like PayPal Express Checkout is providing the billing address."""
    shipping_address: NotRequired[GetOrderShippingAddressTypedDict]
    r"""The customer's shipping address details. We advise to provide these details to improve fraud protection and conversion. This is particularly relevant for card payments."""
    locale: NotRequired[str]
    r"""Allows you to preset the language to be used in the hosted payment pages shown to the customer. Setting a locale is highly recommended and will greatly improve your conversion rate. When this parameter is omitted the browser language will be used instead if supported by the payment method. You can provide any `xx_XX` format ISO 15897 locale, but our hosted payment pages currently only support the specified languages.

    For bank transfer payments specifically, the locale will determine the target bank account the customer has to transfer the money to. We have dedicated bank accounts for Belgium, Germany, and The Netherlands. Having the customer use a local bank account greatly increases the conversion and speed of payment.

    Possible values: `en_US` `en_GB` `nl_NL` `nl_BE` `fr_FR` `fr_BE` `de_DE` `de_AT` `de_CH` `es_ES` `ca_ES` `pt_PT` `it_IT` `nb_NO` `sv_SE` `fi_FI` `da_DK` `is_IS` `hu_HU` `pl_PL` `lv_LV` `lt_LT`
    """
    method: NotRequired[Nullable[str]]
    r"""Normally, a payment method screen is shown. However, when using this parameter, you can choose a specific payment method and your customer will skip the selection screen and is sent directly to the chosen payment method. The parameter enables you to fully integrate the payment method selection into your website.

    You can also specify the methods in an array. By doing so we will still show the payment method selection screen but will only show the methods specified in the array. For example, you can use this functionality to only show payment methods from a specific country to your customer `['bancontact', 'belfius']`.

    Possible values: `applepay` `bancomatpay` `bancontact` `banktransfer` `belfius` `billie` `creditcard` `directdebit` `eps` `giftcard` `ideal` `in3` `kbc` `klarna` `klarnapaylater` `klarnapaynow` `klarnasliceit` `mybank` `paypal` `paysafecard` `przelewy24` `riverty` `satispay` `trustly` `twint` `voucher`
    """
    shopper_country_must_match_billing_country: NotRequired[bool]
    r"""For digital goods, you must make sure to apply the VAT rate from your customer's country in most jurisdictions. You can use this parameter to restrict the payment methods available to your customer to methods from the billing country only.

    This field is similar to the `restrictPaymentMethodsToCountry` field in the Payments API.
    """
    metadata: NotRequired[Nullable[GetOrderMetadataTypedDict]]
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""
    status: NotRequired[str]
    r"""The order's status. Refer to the [documentation regarding statuses](order-status-changes) for more info about which statuses occur at what point.

    Possible values: `created` `pending` `authorized` `paid` `shipping` `canceled` `expired` `completed`
    """
    is_cancelable: NotRequired[Nullable[bool]]
    r"""Whether the order can be canceled. This parameter is omitted if the order reaches a final state."""
    payment: NotRequired[Nullable[GetOrderPaymentTypedDict]]
    r"""Any payment specific properties (for example, the `dueDate` for bank transfer payments) can be passed here. See [method-specific parameters](extra-payment-parameters) for all the possible fields."""
    profile_id: NotRequired[Nullable[str]]
    r"""The identifier referring to the [profile](get-profile) this entity belongs to.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted in the creation request. For organization-level credentials such as OAuth access tokens however, the `profileId` parameter is required.
    """
    created_at: NotRequired[str]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    authorized_at: NotRequired[Nullable[str]]
    r"""The date and time the order became authorized, in ISO 8601 format. This parameter is omitted if the order is not authorized (yet)."""
    paid_at: NotRequired[Nullable[str]]
    r"""The date and time the order became paid, in ISO 8601 format. This parameter is omitted if the order is not completed (yet)."""
    canceled_at: NotRequired[Nullable[str]]
    r"""The date and time the order was canceled, in ISO 8601 format. This parameter is omitted if the order is not canceled (yet)."""
    expires_at: NotRequired[Nullable[str]]
    r"""The date the order should expire in `YYYY-MM-DD` format. The minimum date is tomorrow and the maximum date is 100 days after tomorrow.

    It is not possible to use Klarna when your expiry date is more than 28 days in the future, unless you agreed on a different maximum with Klarna.
    """
    expired_at: NotRequired[Nullable[str]]
    r"""The date and time the order was expired, in ISO 8601 format. This parameter is omitted if the order did not expire (yet)."""
    completed_at: NotRequired[Nullable[str]]
    r"""The date and time the order was completed, in ISO 8601 format. This parameter is omitted if the order is not completed (yet)."""
    links: NotRequired[GetOrderLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class GetOrderResponseBody(BaseModel):
    r"""The order object."""

    resource: Optional[str] = "order"
    r"""Indicates the response contains an order object. Will always contain the string `order` for this endpoint."""

    id: Optional[str] = None
    r"""The identifier uniquely referring to this order. Mollie assigns this identifier at payment creation time. Mollie will always refer to the order by this ID. Example: `ord_vsKJpSsabw`."""

    mode: Optional[str] = None
    r"""Whether this entity was created in live mode or in test mode.

    Possible values: `live` `test`
    """

    order_number: Annotated[Optional[str], pydantic.Field(alias="orderNumber")] = None
    r"""The order number for this order. We recommend each order number to be unique."""

    lines: Optional[List[GetOrderLines]] = None
    r"""The order lines for the order. Each line contains details such as a description of the item ordered and its price.

    All lines must have the same currency as the payment.
    """

    amount: Optional[GetOrderAmount] = None
    r"""The amount that you want to charge, e.g. `{currency:\"EUR\", value:\"1000.00\"}` if you would want to charge €1000.00.

    You can find the minimum and maximum amounts per payment method in our help center. Additionally, they can be retrieved using the Get method endpoint.
    """

    amount_refunded: Annotated[
        OptionalNullable[AmountRefunded], pydantic.Field(alias="amountRefunded")
    ] = UNSET
    r"""The total amount that is already refunded. Only available when refunds are available for this order. For some payment methods, this amount may be higher than the order amount, for example to allow reimbursement of the costs for a return shipment to the customer."""

    amount_captured: Annotated[
        OptionalNullable[AmountCaptured], pydantic.Field(alias="amountCaptured")
    ] = UNSET
    r"""The total amount that is already captured for this order. Only available when this order supports captures."""

    redirect_url: Annotated[
        OptionalNullable[str], pydantic.Field(alias="redirectUrl")
    ] = UNSET
    r"""The URL your customer will be redirected to after the payment process.

    It could make sense for the redirectUrl to contain a unique identifier – like your order ID – so you can show the right page referencing the order when your customer returns.

    The parameter is normally required, but can be omitted for recurring payments (`sequenceType: recurring`) and for Apple Pay payments with an `applePayPaymentToken`.
    """

    cancel_url: Annotated[OptionalNullable[str], pydantic.Field(alias="cancelUrl")] = (
        UNSET
    )
    r"""The URL your customer will be redirected to when the customer explicitly cancels the payment. If this URL is not provided, the customer will be redirected to the `redirectUrl` instead — see above.

    Mollie will always give you status updates via webhooks, including for the canceled status. This parameter is therefore entirely optional, but can be useful when implementing a dedicated customer-facing flow to handle payment cancellations.
    """

    webhook_url: Annotated[
        OptionalNullable[str], pydantic.Field(alias="webhookUrl")
    ] = UNSET
    r"""The webhook URL where we will send order status updates to.

    The webhookUrl is optional, but without a webhook you will miss out on important status changes to your order.

    The webhookUrl must be reachable from Mollie's point of view, so you cannot use `localhost`. If you want to use webhook during development on `localhost`, you must use a tool like ngrok to have the webhooks delivered to your local machine.
    """

    billing_address: Annotated[
        Optional[GetOrderBillingAddress], pydantic.Field(alias="billingAddress")
    ] = None
    r"""The customer's billing address details. The billing address is required, unless a fast checkout method like PayPal Express Checkout is providing the billing address."""

    shipping_address: Annotated[
        Optional[GetOrderShippingAddress], pydantic.Field(alias="shippingAddress")
    ] = None
    r"""The customer's shipping address details. We advise to provide these details to improve fraud protection and conversion. This is particularly relevant for card payments."""

    locale: Optional[str] = None
    r"""Allows you to preset the language to be used in the hosted payment pages shown to the customer. Setting a locale is highly recommended and will greatly improve your conversion rate. When this parameter is omitted the browser language will be used instead if supported by the payment method. You can provide any `xx_XX` format ISO 15897 locale, but our hosted payment pages currently only support the specified languages.

    For bank transfer payments specifically, the locale will determine the target bank account the customer has to transfer the money to. We have dedicated bank accounts for Belgium, Germany, and The Netherlands. Having the customer use a local bank account greatly increases the conversion and speed of payment.

    Possible values: `en_US` `en_GB` `nl_NL` `nl_BE` `fr_FR` `fr_BE` `de_DE` `de_AT` `de_CH` `es_ES` `ca_ES` `pt_PT` `it_IT` `nb_NO` `sv_SE` `fi_FI` `da_DK` `is_IS` `hu_HU` `pl_PL` `lv_LV` `lt_LT`
    """

    method: OptionalNullable[str] = UNSET
    r"""Normally, a payment method screen is shown. However, when using this parameter, you can choose a specific payment method and your customer will skip the selection screen and is sent directly to the chosen payment method. The parameter enables you to fully integrate the payment method selection into your website.

    You can also specify the methods in an array. By doing so we will still show the payment method selection screen but will only show the methods specified in the array. For example, you can use this functionality to only show payment methods from a specific country to your customer `['bancontact', 'belfius']`.

    Possible values: `applepay` `bancomatpay` `bancontact` `banktransfer` `belfius` `billie` `creditcard` `directdebit` `eps` `giftcard` `ideal` `in3` `kbc` `klarna` `klarnapaylater` `klarnapaynow` `klarnasliceit` `mybank` `paypal` `paysafecard` `przelewy24` `riverty` `satispay` `trustly` `twint` `voucher`
    """

    shopper_country_must_match_billing_country: Annotated[
        Optional[bool], pydantic.Field(alias="shopperCountryMustMatchBillingCountry")
    ] = None
    r"""For digital goods, you must make sure to apply the VAT rate from your customer's country in most jurisdictions. You can use this parameter to restrict the payment methods available to your customer to methods from the billing country only.

    This field is similar to the `restrictPaymentMethodsToCountry` field in the Payments API.
    """

    metadata: OptionalNullable[GetOrderMetadata] = UNSET
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""

    status: Optional[str] = None
    r"""The order's status. Refer to the [documentation regarding statuses](order-status-changes) for more info about which statuses occur at what point.

    Possible values: `created` `pending` `authorized` `paid` `shipping` `canceled` `expired` `completed`
    """

    is_cancelable: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="isCancelable")
    ] = UNSET
    r"""Whether the order can be canceled. This parameter is omitted if the order reaches a final state."""

    payment: OptionalNullable[GetOrderPayment] = UNSET
    r"""Any payment specific properties (for example, the `dueDate` for bank transfer payments) can be passed here. See [method-specific parameters](extra-payment-parameters) for all the possible fields."""

    profile_id: Annotated[OptionalNullable[str], pydantic.Field(alias="profileId")] = (
        UNSET
    )
    r"""The identifier referring to the [profile](get-profile) this entity belongs to.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted in the creation request. For organization-level credentials such as OAuth access tokens however, the `profileId` parameter is required.
    """

    created_at: Annotated[Optional[str], pydantic.Field(alias="createdAt")] = None
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    authorized_at: Annotated[
        OptionalNullable[str], pydantic.Field(alias="authorizedAt")
    ] = UNSET
    r"""The date and time the order became authorized, in ISO 8601 format. This parameter is omitted if the order is not authorized (yet)."""

    paid_at: Annotated[OptionalNullable[str], pydantic.Field(alias="paidAt")] = UNSET
    r"""The date and time the order became paid, in ISO 8601 format. This parameter is omitted if the order is not completed (yet)."""

    canceled_at: Annotated[
        OptionalNullable[str], pydantic.Field(alias="canceledAt")
    ] = UNSET
    r"""The date and time the order was canceled, in ISO 8601 format. This parameter is omitted if the order is not canceled (yet)."""

    expires_at: Annotated[OptionalNullable[str], pydantic.Field(alias="expiresAt")] = (
        UNSET
    )
    r"""The date the order should expire in `YYYY-MM-DD` format. The minimum date is tomorrow and the maximum date is 100 days after tomorrow.

    It is not possible to use Klarna when your expiry date is more than 28 days in the future, unless you agreed on a different maximum with Klarna.
    """

    expired_at: Annotated[OptionalNullable[str], pydantic.Field(alias="expiredAt")] = (
        UNSET
    )
    r"""The date and time the order was expired, in ISO 8601 format. This parameter is omitted if the order did not expire (yet)."""

    completed_at: Annotated[
        OptionalNullable[str], pydantic.Field(alias="completedAt")
    ] = UNSET
    r"""The date and time the order was completed, in ISO 8601 format. This parameter is omitted if the order is not completed (yet)."""

    links: Annotated[Optional[GetOrderLinks], pydantic.Field(alias="_links")] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "resource",
            "id",
            "mode",
            "orderNumber",
            "lines",
            "amount",
            "amountRefunded",
            "amountCaptured",
            "redirectUrl",
            "cancelUrl",
            "webhookUrl",
            "billingAddress",
            "shippingAddress",
            "locale",
            "method",
            "shopperCountryMustMatchBillingCountry",
            "metadata",
            "status",
            "isCancelable",
            "payment",
            "profileId",
            "createdAt",
            "authorizedAt",
            "paidAt",
            "canceledAt",
            "expiresAt",
            "expiredAt",
            "completedAt",
            "_links",
        ]
        nullable_fields = [
            "amountRefunded",
            "amountCaptured",
            "redirectUrl",
            "cancelUrl",
            "webhookUrl",
            "method",
            "metadata",
            "isCancelable",
            "payment",
            "profileId",
            "authorizedAt",
            "paidAt",
            "canceledAt",
            "expiresAt",
            "expiredAt",
            "completedAt",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
