"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class UserAgentTokensTypedDict(TypedDict):
    token: NotRequired[str]
    r"""The unique User-Agent token."""
    starts_at: NotRequired[str]
    r"""The date from which the token is active, in ISO 8601 format."""
    ends_at: NotRequired[Nullable[str]]
    r"""The date until when the token will be active, in ISO 8601 format. Will be `null` if the token does not have an end date (yet)."""


class UserAgentTokens(BaseModel):
    token: Optional[str] = None
    r"""The unique User-Agent token."""

    starts_at: Annotated[Optional[str], pydantic.Field(alias="startsAt")] = None
    r"""The date from which the token is active, in ISO 8601 format."""

    ends_at: Annotated[OptionalNullable[str], pydantic.Field(alias="endsAt")] = UNSET
    r"""The date until when the token will be active, in ISO 8601 format. Will be `null` if the token does not have an end date (yet)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["token", "startsAt", "endsAt"]
        nullable_fields = ["endsAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetPartnerStatusSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetPartnerStatusSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class SignuplinkTypedDict(TypedDict):
    r"""The URL that can be used to have new organizations sign up and be automatically linked to this partner. Will be omitted if the partner is not of type `signuplink`."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class Signuplink(BaseModel):
    r"""The URL that can be used to have new organizations sign up and be automatically linked to this partner. Will be omitted if the partner is not of type `signuplink`."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetPartnerStatusDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetPartnerStatusDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetPartnerStatusLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[GetPartnerStatusSelfTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    signuplink: NotRequired[SignuplinkTypedDict]
    r"""The URL that can be used to have new organizations sign up and be automatically linked to this partner. Will be omitted if the partner is not of type `signuplink`."""
    documentation: NotRequired[GetPartnerStatusDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetPartnerStatusLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[GetPartnerStatusSelf], pydantic.Field(alias="self")] = (
        None
    )
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    signuplink: Optional[Signuplink] = None
    r"""The URL that can be used to have new organizations sign up and be automatically linked to this partner. Will be omitted if the partner is not of type `signuplink`."""

    documentation: Optional[GetPartnerStatusDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetPartnerStatusResponseBodyTypedDict(TypedDict):
    r"""The partner status object."""

    partner_type: Nullable[str]
    r"""Indicates the type of partner. Will be `null` if the currently authenticated organization is not enrolled as a partner.

    Possible values: `oauth` `signuplink` `useragent`
    """
    resource: NotRequired[str]
    r"""Indicates the response contains a partner status object. Will always contain the string `partner` for this endpoint."""
    is_commission_partner: NotRequired[bool]
    r"""Whether the current organization is receiving commissions."""
    user_agent_tokens: NotRequired[List[UserAgentTokensTypedDict]]
    r"""Array of User-Agent token objects. Present if the organization is a partner of type `useragent`, or if they were in the past."""
    partner_contract_signed_at: NotRequired[Nullable[str]]
    r"""The date the partner contract was signed, in ISO 8601 format. Omitted if no contract has been signed (yet)."""
    partner_contract_update_available: NotRequired[bool]
    r"""Whether an update to the partner contract is available and requiring the organization's agreement."""
    partner_contract_expires_at: NotRequired[str]
    r"""The expiration date of the signed partner contract, in ISO 8601 format. Omitted if contract has no expiration date (yet)."""
    links: NotRequired[GetPartnerStatusLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class GetPartnerStatusResponseBody(BaseModel):
    r"""The partner status object."""

    partner_type: Annotated[Nullable[str], pydantic.Field(alias="partnerType")]
    r"""Indicates the type of partner. Will be `null` if the currently authenticated organization is not enrolled as a partner.

    Possible values: `oauth` `signuplink` `useragent`
    """

    resource: Optional[str] = "partner"
    r"""Indicates the response contains a partner status object. Will always contain the string `partner` for this endpoint."""

    is_commission_partner: Annotated[
        Optional[bool], pydantic.Field(alias="isCommissionPartner")
    ] = None
    r"""Whether the current organization is receiving commissions."""

    user_agent_tokens: Annotated[
        Optional[List[UserAgentTokens]], pydantic.Field(alias="userAgentTokens")
    ] = None
    r"""Array of User-Agent token objects. Present if the organization is a partner of type `useragent`, or if they were in the past."""

    partner_contract_signed_at: Annotated[
        OptionalNullable[str], pydantic.Field(alias="partnerContractSignedAt")
    ] = UNSET
    r"""The date the partner contract was signed, in ISO 8601 format. Omitted if no contract has been signed (yet)."""

    partner_contract_update_available: Annotated[
        Optional[bool], pydantic.Field(alias="partnerContractUpdateAvailable")
    ] = None
    r"""Whether an update to the partner contract is available and requiring the organization's agreement."""

    partner_contract_expires_at: Annotated[
        Optional[str], pydantic.Field(alias="partnerContractExpiresAt")
    ] = None
    r"""The expiration date of the signed partner contract, in ISO 8601 format. Omitted if contract has no expiration date (yet)."""

    links: Annotated[
        Optional[GetPartnerStatusLinks], pydantic.Field(alias="_links")
    ] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "resource",
            "isCommissionPartner",
            "userAgentTokens",
            "partnerContractSignedAt",
            "partnerContractUpdateAvailable",
            "partnerContractExpiresAt",
            "_links",
        ]
        nullable_fields = ["partnerType", "partnerContractSignedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
