"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie import utils
from mollie.types import BaseModel, OptionalNullable, UNSET
from mollie.utils import FieldMetadata, PathParamMetadata
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetSettlementRefundsRequestTypedDict(TypedDict):
    settlement_id: str
    r"""Provide the ID of the related settlement."""


class GetSettlementRefundsRequest(BaseModel):
    settlement_id: Annotated[
        str,
        pydantic.Field(alias="settlementId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related settlement."""


class GetSettlementRefundsDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class GetSettlementRefundsDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class GetSettlementRefundsLinksTypedDict(TypedDict):
    documentation: NotRequired[GetSettlementRefundsDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class GetSettlementRefundsLinks(BaseModel):
    documentation: Optional[GetSettlementRefundsDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class GetSettlementRefundsResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[
        Optional[GetSettlementRefundsLinks], pydantic.Field(alias="_links")
    ] = None


class GetSettlementRefundsResponseBody(Exception):
    r"""An error response object."""

    data: GetSettlementRefundsResponseBodyData

    def __init__(self, data: GetSettlementRefundsResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, GetSettlementRefundsResponseBodyData)
