"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie import utils
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetShipmentRequestTypedDict(TypedDict):
    order_id: str
    r"""Provide the ID of the related order."""
    id: str
    r"""Provide the ID of the item you want to perform this operation on."""
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class GetShipmentRequest(BaseModel):
    order_id: Annotated[
        str,
        pydantic.Field(alias="orderId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related order."""

    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Provide the ID of the item you want to perform this operation on."""

    testmode: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = False
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["testmode"]
        nullable_fields = ["testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetShipmentShipmentsDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class GetShipmentShipmentsDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class GetShipmentShipmentsLinksTypedDict(TypedDict):
    documentation: NotRequired[GetShipmentShipmentsDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class GetShipmentShipmentsLinks(BaseModel):
    documentation: Optional[GetShipmentShipmentsDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class GetShipmentShipmentsResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[
        Optional[GetShipmentShipmentsLinks], pydantic.Field(alias="_links")
    ] = None


class GetShipmentShipmentsResponseBody(Exception):
    r"""An error response object."""

    data: GetShipmentShipmentsResponseBodyData

    def __init__(self, data: GetShipmentShipmentsResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, GetShipmentShipmentsResponseBodyData)


class GetShipmentUnitPriceTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetShipmentUnitPrice(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetShipmentTotalAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetShipmentTotalAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetShipmentVatAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetShipmentVatAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetShipmentLinesTypedDict(TypedDict):
    resource: NotRequired[str]
    id: NotRequired[str]
    r"""The ID of the order line. For example: `odl_dgtxyl`."""
    type: NotRequired[str]
    name: NotRequired[str]
    quantity: NotRequired[Nullable[int]]
    r"""The number of items that should be shipped for this order line. When this parameter is omitted, all remaining unshipped items of this order line will be considered 'shipped'."""
    unit_price: NotRequired[GetShipmentUnitPriceTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    total_amount: NotRequired[GetShipmentTotalAmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    vat_rate: NotRequired[str]
    vat_amount: NotRequired[GetShipmentVatAmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    sku: NotRequired[str]
    status: NotRequired[str]
    order_id: NotRequired[str]
    created_at: NotRequired[str]


class GetShipmentLines(BaseModel):
    resource: Optional[str] = None

    id: Optional[str] = None
    r"""The ID of the order line. For example: `odl_dgtxyl`."""

    type: Optional[str] = None

    name: Optional[str] = None

    quantity: OptionalNullable[int] = UNSET
    r"""The number of items that should be shipped for this order line. When this parameter is omitted, all remaining unshipped items of this order line will be considered 'shipped'."""

    unit_price: Annotated[
        Optional[GetShipmentUnitPrice], pydantic.Field(alias="unitPrice")
    ] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    total_amount: Annotated[
        Optional[GetShipmentTotalAmount], pydantic.Field(alias="totalAmount")
    ] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    vat_rate: Annotated[Optional[str], pydantic.Field(alias="vatRate")] = None

    vat_amount: Annotated[
        Optional[GetShipmentVatAmount], pydantic.Field(alias="vatAmount")
    ] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    sku: Optional[str] = None

    status: Optional[str] = None

    order_id: Annotated[Optional[str], pydantic.Field(alias="orderId")] = None

    created_at: Annotated[Optional[str], pydantic.Field(alias="createdAt")] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "resource",
            "id",
            "type",
            "name",
            "quantity",
            "unitPrice",
            "totalAmount",
            "vatRate",
            "vatAmount",
            "sku",
            "status",
            "orderId",
            "createdAt",
        ]
        nullable_fields = ["quantity"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetShipmentTrackingTypedDict(TypedDict):
    r"""Shipment tracking details. Can be omitted if tracking details are not available or not applicable."""

    carrier: NotRequired[str]
    r"""The name of the postal carrier."""
    code: NotRequired[str]
    r"""The track-and-trace code for the shipment."""
    url: NotRequired[str]
    r"""The URL where your customer can track the shipment."""


class GetShipmentTracking(BaseModel):
    r"""Shipment tracking details. Can be omitted if tracking details are not available or not applicable."""

    carrier: Optional[str] = None
    r"""The name of the postal carrier."""

    code: Optional[str] = None
    r"""The track-and-trace code for the shipment."""

    url: Optional[str] = None
    r"""The URL where your customer can track the shipment."""


class GetShipmentSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetShipmentSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class OrderTypedDict(TypedDict):
    r"""The API resource URL of the [order](get-order) that this shipment belongs to."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class Order(BaseModel):
    r"""The API resource URL of the [order](get-order) that this shipment belongs to."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetShipmentDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetShipmentDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetShipmentLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[GetShipmentSelfTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    order: NotRequired[OrderTypedDict]
    r"""The API resource URL of the [order](get-order) that this shipment belongs to."""
    documentation: NotRequired[GetShipmentDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetShipmentLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[GetShipmentSelf], pydantic.Field(alias="self")] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    order: Optional[Order] = None
    r"""The API resource URL of the [order](get-order) that this shipment belongs to."""

    documentation: Optional[GetShipmentDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetShipmentResponseBodyTypedDict(TypedDict):
    r"""The shipment object."""

    resource: NotRequired[str]
    r"""Indicates the response contains a shipment object. Will always contain the string `shipment` for this endpoint."""
    id: NotRequired[str]
    r"""The identifier uniquely referring to this shipment. Example: `shp_3wmsgCJN4U`."""
    mode: NotRequired[str]
    r"""Whether this entity was created in live mode or in test mode.

    Possible values: `live` `test`
    """
    lines: NotRequired[Nullable[List[GetShipmentLinesTypedDict]]]
    r"""The order lines that are being fulfilled with this shipment. If left blank, all open order lines will be considered fulfilled.

    For an in-depth explanation of all order line properties, refer to the `lines` parameter of the [Create order](create-order) endpoint.
    """
    tracking: NotRequired[Nullable[GetShipmentTrackingTypedDict]]
    r"""Shipment tracking details. Can be omitted if tracking details are not available or not applicable."""
    order_id: NotRequired[str]
    r"""The unique identifier of the order this shipment was created for. For example: `ord_8wmqcHMN4U`."""
    created_at: NotRequired[str]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    links: NotRequired[GetShipmentLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class GetShipmentResponseBody(BaseModel):
    r"""The shipment object."""

    resource: Optional[str] = "shipment"
    r"""Indicates the response contains a shipment object. Will always contain the string `shipment` for this endpoint."""

    id: Optional[str] = None
    r"""The identifier uniquely referring to this shipment. Example: `shp_3wmsgCJN4U`."""

    mode: Optional[str] = None
    r"""Whether this entity was created in live mode or in test mode.

    Possible values: `live` `test`
    """

    lines: OptionalNullable[List[GetShipmentLines]] = UNSET
    r"""The order lines that are being fulfilled with this shipment. If left blank, all open order lines will be considered fulfilled.

    For an in-depth explanation of all order line properties, refer to the `lines` parameter of the [Create order](create-order) endpoint.
    """

    tracking: OptionalNullable[GetShipmentTracking] = UNSET
    r"""Shipment tracking details. Can be omitted if tracking details are not available or not applicable."""

    order_id: Annotated[Optional[str], pydantic.Field(alias="orderId")] = None
    r"""The unique identifier of the order this shipment was created for. For example: `ord_8wmqcHMN4U`."""

    created_at: Annotated[Optional[str], pydantic.Field(alias="createdAt")] = None
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    links: Annotated[Optional[GetShipmentLinks], pydantic.Field(alias="_links")] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "resource",
            "id",
            "mode",
            "lines",
            "tracking",
            "orderId",
            "createdAt",
            "_links",
        ]
        nullable_fields = ["lines", "tracking"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
