"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie import utils
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListAllMethodsQueryParamAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListAllMethodsQueryParamAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: Annotated[str, FieldMetadata(query=True)]
    r"""A three-character ISO 4217 currency code."""

    value: Annotated[str, FieldMetadata(query=True)]
    r"""A string containing an exact monetary amount in the given currency."""


class ListAllMethodsRequestTypedDict(TypedDict):
    locale: NotRequired[str]
    r"""Passing a locale will sort the payment methods in the preferred order for the country, and translate the payment method names in the corresponding language.

    Possible values: `en_US` `en_GB` `nl_NL` `nl_BE` `de_DE` `de_AT` `de_CH` `fr_FR` `fr_BE` `es_ES` `ca_ES` `pt_PT` `it_IT` `nb_NO` `sv_SE` `fi_FI` `da_DK` `is_IS` `hu_HU` `pl_PL` `lv_LV` `lt_LT`
    """
    amount: NotRequired[ListAllMethodsQueryParamAmountTypedDict]
    r"""If supplied, only payment methods that support the amount and currency are returned.

    Example: `/v2/methods/all?amount[value]=100.00&amount[currency]=USD`
    """
    include: NotRequired[Nullable[str]]
    r"""This endpoint allows you to include additional information via the `include` query string parameter.

    * `issuers`: Include issuer details such as which iDEAL or gift card issuers are available.
    * `pricing`: Include pricing for each payment method.
    """


class ListAllMethodsRequest(BaseModel):
    locale: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Passing a locale will sort the payment methods in the preferred order for the country, and translate the payment method names in the corresponding language.

    Possible values: `en_US` `en_GB` `nl_NL` `nl_BE` `de_DE` `de_AT` `de_CH` `fr_FR` `fr_BE` `es_ES` `ca_ES` `pt_PT` `it_IT` `nb_NO` `sv_SE` `fi_FI` `da_DK` `is_IS` `hu_HU` `pl_PL` `lv_LV` `lt_LT`
    """

    amount: Annotated[
        Optional[ListAllMethodsQueryParamAmount],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""If supplied, only payment methods that support the amount and currency are returned.

    Example: `/v2/methods/all?amount[value]=100.00&amount[currency]=USD`
    """

    include: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""This endpoint allows you to include additional information via the `include` query string parameter.

    * `issuers`: Include issuer details such as which iDEAL or gift card issuers are available.
    * `pricing`: Include pricing for each payment method.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["locale", "amount", "include"]
        nullable_fields = ["include"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListAllMethodsMethodsDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class ListAllMethodsMethodsDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class ListAllMethodsMethodsLinksTypedDict(TypedDict):
    documentation: NotRequired[ListAllMethodsMethodsDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class ListAllMethodsMethodsLinks(BaseModel):
    documentation: Optional[ListAllMethodsMethodsDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class ListAllMethodsMethodsResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[
        Optional[ListAllMethodsMethodsLinks], pydantic.Field(alias="_links")
    ] = None


class ListAllMethodsMethodsResponseBody(Exception):
    r"""An error response object."""

    data: ListAllMethodsMethodsResponseBodyData

    def __init__(self, data: ListAllMethodsMethodsResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, ListAllMethodsMethodsResponseBodyData)


class ListAllMethodsMethodsTypedDict(TypedDict):
    pass


class ListAllMethodsMethods(BaseModel):
    pass


class ListAllMethodsEmbeddedTypedDict(TypedDict):
    methods: NotRequired[List[ListAllMethodsMethodsTypedDict]]
    r"""An array of payment method objects. For a complete reference of the payment method object, refer to the [Get payment method endpoint](get-method) documentation."""


class ListAllMethodsEmbedded(BaseModel):
    methods: Optional[List[ListAllMethodsMethods]] = None
    r"""An array of payment method objects. For a complete reference of the payment method object, refer to the [Get payment method endpoint](get-method) documentation."""


class ListAllMethodsSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListAllMethodsSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListAllMethodsDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListAllMethodsDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListAllMethodsLinksTypedDict(TypedDict):
    self_: NotRequired[ListAllMethodsSelfTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: NotRequired[ListAllMethodsDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListAllMethodsLinks(BaseModel):
    self_: Annotated[Optional[ListAllMethodsSelf], pydantic.Field(alias="self")] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: Optional[ListAllMethodsDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListAllMethodsResponseBodyTypedDict(TypedDict):
    r"""A list of payment method objects. For a complete reference of the payment method object, refer to the [Get payment method endpoint](get-method) documentation."""

    count: NotRequired[int]
    r"""The number of payment method objects in this result set. Results are **not** paginated."""
    embedded: NotRequired[ListAllMethodsEmbeddedTypedDict]
    links: NotRequired[ListAllMethodsLinksTypedDict]


class ListAllMethodsResponseBody(BaseModel):
    r"""A list of payment method objects. For a complete reference of the payment method object, refer to the [Get payment method endpoint](get-method) documentation."""

    count: Optional[int] = None
    r"""The number of payment method objects in this result set. Results are **not** paginated."""

    embedded: Annotated[
        Optional[ListAllMethodsEmbedded], pydantic.Field(alias="_embedded")
    ] = None

    links: Annotated[Optional[ListAllMethodsLinks], pydantic.Field(alias="_links")] = (
        None
    )
