"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie import utils
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListAllSubscriptionsRequestTypedDict(TypedDict):
    from_: NotRequired[str]
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the result set."""
    limit: NotRequired[Nullable[int]]
    r"""The maximum number of items to return. Defaults to 50 items."""
    profile_id: NotRequired[Nullable[str]]
    r"""The identifier referring to the [profile](get-profile) you wish to retrieve subscriptions for.

    Most API credentials are linked to a single profile. In these cases the `profileId` is already implied.

    To retrieve all subscriptions across the organization, use an organization-level API credential and omit the `profileId` parameter.
    """
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class ListAllSubscriptionsRequest(BaseModel):
    from_: Annotated[
        Optional[str],
        pydantic.Field(alias="from"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the result set."""

    limit: Annotated[
        OptionalNullable[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 50
    r"""The maximum number of items to return. Defaults to 50 items."""

    profile_id: Annotated[
        OptionalNullable[str],
        pydantic.Field(alias="profileId"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""The identifier referring to the [profile](get-profile) you wish to retrieve subscriptions for.

    Most API credentials are linked to a single profile. In these cases the `profileId` is already implied.

    To retrieve all subscriptions across the organization, use an organization-level API credential and omit the `profileId` parameter.
    """

    testmode: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = False
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["from", "limit", "profileId", "testmode"]
        nullable_fields = ["limit", "profileId", "testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListAllSubscriptionsSubscriptionsResponseDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class ListAllSubscriptionsSubscriptionsResponseDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class ListAllSubscriptionsSubscriptionsResponseLinksTypedDict(TypedDict):
    documentation: NotRequired[
        ListAllSubscriptionsSubscriptionsResponseDocumentationTypedDict
    ]
    r"""The URL to the generic Mollie API error handling guide."""


class ListAllSubscriptionsSubscriptionsResponseLinks(BaseModel):
    documentation: Optional[ListAllSubscriptionsSubscriptionsResponseDocumentation] = (
        None
    )
    r"""The URL to the generic Mollie API error handling guide."""


class ListAllSubscriptionsSubscriptionsResponseResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[
        Optional[ListAllSubscriptionsSubscriptionsResponseLinks],
        pydantic.Field(alias="_links"),
    ] = None


class ListAllSubscriptionsSubscriptionsResponseResponseBody(Exception):
    r"""An error response object."""

    data: ListAllSubscriptionsSubscriptionsResponseResponseBodyData

    def __init__(self, data: ListAllSubscriptionsSubscriptionsResponseResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(
            self.data, ListAllSubscriptionsSubscriptionsResponseResponseBodyData
        )


class ListAllSubscriptionsSubscriptionsDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class ListAllSubscriptionsSubscriptionsDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class ListAllSubscriptionsSubscriptionsLinksTypedDict(TypedDict):
    documentation: NotRequired[ListAllSubscriptionsSubscriptionsDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class ListAllSubscriptionsSubscriptionsLinks(BaseModel):
    documentation: Optional[ListAllSubscriptionsSubscriptionsDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class ListAllSubscriptionsSubscriptionsResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[
        Optional[ListAllSubscriptionsSubscriptionsLinks], pydantic.Field(alias="_links")
    ] = None


class ListAllSubscriptionsSubscriptionsResponseBody(Exception):
    r"""An error response object."""

    data: ListAllSubscriptionsSubscriptionsResponseBodyData

    def __init__(self, data: ListAllSubscriptionsSubscriptionsResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(
            self.data, ListAllSubscriptionsSubscriptionsResponseBodyData
        )


class ListAllSubscriptionsSubscriptionsTypedDict(TypedDict):
    pass


class ListAllSubscriptionsSubscriptions(BaseModel):
    pass


class ListAllSubscriptionsEmbeddedTypedDict(TypedDict):
    subscriptions: NotRequired[List[ListAllSubscriptionsSubscriptionsTypedDict]]
    r"""A list of subscription objects. For a complete reference of the subscription object, refer to the [Get subscription endpoint](get-subscription) documentation."""


class ListAllSubscriptionsEmbedded(BaseModel):
    subscriptions: Optional[List[ListAllSubscriptionsSubscriptions]] = None
    r"""A list of subscription objects. For a complete reference of the subscription object, refer to the [Get subscription endpoint](get-subscription) documentation."""


class ListAllSubscriptionsSelfTypedDict(TypedDict):
    r"""The URL to the current set of items."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListAllSubscriptionsSelf(BaseModel):
    r"""The URL to the current set of items."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListAllSubscriptionsPreviousTypedDict(TypedDict):
    r"""The previous set of items, if available."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListAllSubscriptionsPrevious(BaseModel):
    r"""The previous set of items, if available."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListAllSubscriptionsNextTypedDict(TypedDict):
    r"""The next set of items, if available."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListAllSubscriptionsNext(BaseModel):
    r"""The next set of items, if available."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListAllSubscriptionsDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListAllSubscriptionsDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListAllSubscriptionsLinksTypedDict(TypedDict):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[ListAllSubscriptionsSelfTypedDict]
    r"""The URL to the current set of items."""
    previous: NotRequired[Nullable[ListAllSubscriptionsPreviousTypedDict]]
    r"""The previous set of items, if available."""
    next: NotRequired[Nullable[ListAllSubscriptionsNextTypedDict]]
    r"""The next set of items, if available."""
    documentation: NotRequired[ListAllSubscriptionsDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListAllSubscriptionsLinks(BaseModel):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[
        Optional[ListAllSubscriptionsSelf], pydantic.Field(alias="self")
    ] = None
    r"""The URL to the current set of items."""

    previous: OptionalNullable[ListAllSubscriptionsPrevious] = UNSET
    r"""The previous set of items, if available."""

    next: OptionalNullable[ListAllSubscriptionsNext] = UNSET
    r"""The next set of items, if available."""

    documentation: Optional[ListAllSubscriptionsDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["self", "previous", "next", "documentation"]
        nullable_fields = ["previous", "next"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListAllSubscriptionsResponseBodyTypedDict(TypedDict):
    r"""A list of subscription objects. For a complete reference of the subscription object, refer to the [Get subscription endpoint](get-subscription) documentation."""

    count: NotRequired[int]
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default limit is 50 items.
    """
    embedded: NotRequired[ListAllSubscriptionsEmbeddedTypedDict]
    links: NotRequired[ListAllSubscriptionsLinksTypedDict]
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""


class ListAllSubscriptionsResponseBody(BaseModel):
    r"""A list of subscription objects. For a complete reference of the subscription object, refer to the [Get subscription endpoint](get-subscription) documentation."""

    count: Optional[int] = None
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default limit is 50 items.
    """

    embedded: Annotated[
        Optional[ListAllSubscriptionsEmbedded], pydantic.Field(alias="_embedded")
    ] = None

    links: Annotated[
        Optional[ListAllSubscriptionsLinks], pydantic.Field(alias="_links")
    ] = None
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""
