"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie import utils
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListInvoicesRequestTypedDict(TypedDict):
    reference: NotRequired[Nullable[str]]
    r"""Filter for an invoice with a specific invoice reference, for example `2024.10000`."""
    year: NotRequired[Nullable[str]]
    r"""Filter for invoices of a specific year, for example `2024`."""
    month: NotRequired[Nullable[str]]
    r"""Filter for invoices of a specific month, for example `01`."""
    from_: NotRequired[Nullable[str]]
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the result set."""
    limit: NotRequired[Nullable[int]]
    r"""The maximum number of items to return. Defaults to 50 items."""
    sort: NotRequired[Nullable[str]]
    r"""Used for setting the direction of the result set. Defaults to descending order, meaning the results are ordered from newest to oldest.

    Possible values: `asc` `desc` (default: `desc`)
    """


class ListInvoicesRequest(BaseModel):
    reference: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filter for an invoice with a specific invoice reference, for example `2024.10000`."""

    year: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filter for invoices of a specific year, for example `2024`."""

    month: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filter for invoices of a specific month, for example `01`."""

    from_: Annotated[
        OptionalNullable[str],
        pydantic.Field(alias="from"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the result set."""

    limit: Annotated[
        OptionalNullable[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 50
    r"""The maximum number of items to return. Defaults to 50 items."""

    sort: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Used for setting the direction of the result set. Defaults to descending order, meaning the results are ordered from newest to oldest.

    Possible values: `asc` `desc` (default: `desc`)
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["reference", "year", "month", "from", "limit", "sort"]
        nullable_fields = ["reference", "year", "month", "from", "limit", "sort"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListInvoicesInvoicesResponseDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class ListInvoicesInvoicesResponseDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class ListInvoicesInvoicesResponseLinksTypedDict(TypedDict):
    documentation: NotRequired[ListInvoicesInvoicesResponseDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class ListInvoicesInvoicesResponseLinks(BaseModel):
    documentation: Optional[ListInvoicesInvoicesResponseDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class ListInvoicesInvoicesResponseResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[
        Optional[ListInvoicesInvoicesResponseLinks], pydantic.Field(alias="_links")
    ] = None


class ListInvoicesInvoicesResponseResponseBody(Exception):
    r"""An error response object."""

    data: ListInvoicesInvoicesResponseResponseBodyData

    def __init__(self, data: ListInvoicesInvoicesResponseResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(
            self.data, ListInvoicesInvoicesResponseResponseBodyData
        )


class ListInvoicesInvoicesDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class ListInvoicesInvoicesDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class ListInvoicesInvoicesLinksTypedDict(TypedDict):
    documentation: NotRequired[ListInvoicesInvoicesDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class ListInvoicesInvoicesLinks(BaseModel):
    documentation: Optional[ListInvoicesInvoicesDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class ListInvoicesInvoicesResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[
        Optional[ListInvoicesInvoicesLinks], pydantic.Field(alias="_links")
    ] = None


class ListInvoicesInvoicesResponseBody(Exception):
    r"""An error response object."""

    data: ListInvoicesInvoicesResponseBodyData

    def __init__(self, data: ListInvoicesInvoicesResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, ListInvoicesInvoicesResponseBodyData)


class ListInvoicesInvoicesTypedDict(TypedDict):
    pass


class ListInvoicesInvoices(BaseModel):
    pass


class ListInvoicesEmbeddedTypedDict(TypedDict):
    invoices: NotRequired[List[ListInvoicesInvoicesTypedDict]]
    r"""An array of invoice objects. For a complete reference of the invoice object, refer to the [Get invoice endpoint](get-invoice) documentation."""


class ListInvoicesEmbedded(BaseModel):
    invoices: Optional[List[ListInvoicesInvoices]] = None
    r"""An array of invoice objects. For a complete reference of the invoice object, refer to the [Get invoice endpoint](get-invoice) documentation."""


class ListInvoicesSelfTypedDict(TypedDict):
    r"""The URL to the current set of items."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListInvoicesSelf(BaseModel):
    r"""The URL to the current set of items."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListInvoicesPreviousTypedDict(TypedDict):
    r"""The previous set of items, if available."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListInvoicesPrevious(BaseModel):
    r"""The previous set of items, if available."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListInvoicesNextTypedDict(TypedDict):
    r"""The next set of items, if available."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListInvoicesNext(BaseModel):
    r"""The next set of items, if available."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListInvoicesDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListInvoicesDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListInvoicesLinksTypedDict(TypedDict):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[ListInvoicesSelfTypedDict]
    r"""The URL to the current set of items."""
    previous: NotRequired[Nullable[ListInvoicesPreviousTypedDict]]
    r"""The previous set of items, if available."""
    next: NotRequired[Nullable[ListInvoicesNextTypedDict]]
    r"""The next set of items, if available."""
    documentation: NotRequired[ListInvoicesDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListInvoicesLinks(BaseModel):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[ListInvoicesSelf], pydantic.Field(alias="self")] = None
    r"""The URL to the current set of items."""

    previous: OptionalNullable[ListInvoicesPrevious] = UNSET
    r"""The previous set of items, if available."""

    next: OptionalNullable[ListInvoicesNext] = UNSET
    r"""The next set of items, if available."""

    documentation: Optional[ListInvoicesDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["self", "previous", "next", "documentation"]
        nullable_fields = ["previous", "next"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListInvoicesResponseBodyTypedDict(TypedDict):
    r"""A list of invoice objects. For a complete reference of the invoice object, refer to the [Get invoice endpoint](get-invoice) documentation."""

    count: NotRequired[int]
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default limit is 50 items.
    """
    embedded: NotRequired[ListInvoicesEmbeddedTypedDict]
    links: NotRequired[ListInvoicesLinksTypedDict]
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""


class ListInvoicesResponseBody(BaseModel):
    r"""A list of invoice objects. For a complete reference of the invoice object, refer to the [Get invoice endpoint](get-invoice) documentation."""

    count: Optional[int] = None
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default limit is 50 items.
    """

    embedded: Annotated[
        Optional[ListInvoicesEmbedded], pydantic.Field(alias="_embedded")
    ] = None

    links: Annotated[Optional[ListInvoicesLinks], pydantic.Field(alias="_links")] = None
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""
